/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.collect.ImmutableList;
import com.plotsquared.google.Binding;
import com.plotsquared.google.internal.ErrorFormatter;
import com.plotsquared.google.internal.ErrorId;
import com.plotsquared.google.internal.InternalErrorDetail;
import com.plotsquared.google.internal.Messages;
import com.plotsquared.google.spi.ErrorDetail;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.stream.Collectors;

final class BindingAlreadySetError
extends InternalErrorDetail<BindingAlreadySetError> {
    private final Binding<?> binding;
    private final Binding<?> original;

    BindingAlreadySetError(Binding<?> binding, Binding<?> binding2, List<Object> list) {
        super(ErrorId.BINDING_ALREADY_SET, String.format("%s was bound multiple times.", Messages.convert(binding.getKey())), list, null);
        this.binding = binding;
        this.original = binding2;
    }

    @Override
    public boolean isMergeable(ErrorDetail<?> errorDetail) {
        return errorDetail instanceof BindingAlreadySetError && ((BindingAlreadySetError)errorDetail).binding.getKey().equals(this.binding.getKey());
    }

    @Override
    public void formatDetail(List<ErrorDetail<?>> list, Formatter formatter) {
        ArrayList<ImmutableList> arrayList = new ArrayList<ImmutableList>();
        arrayList.add(ImmutableList.of((Object)this.original.getSource()));
        arrayList.add(ImmutableList.of((Object)this.binding.getSource()));
        arrayList.addAll(list.stream().map(errorDetail -> ((BindingAlreadySetError)errorDetail).binding.getSource()).map(ImmutableList::of).collect(Collectors.toList()));
        formatter.format("\n%s\n", Messages.bold("Bound at:"));
        for (int i = 0; i < arrayList.size(); ++i) {
            ErrorFormatter.formatSources(i + 1, (List)arrayList.get(i), formatter);
        }
    }

    @Override
    public BindingAlreadySetError withSources(List<Object> list) {
        return new BindingAlreadySetError(this.binding, this.original, list);
    }
}

