/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.plotsquared.google.Binding;
import com.plotsquared.google.Key;
import com.plotsquared.google.Provider;
import com.plotsquared.google.internal.AbstractBindingProcessor;
import com.plotsquared.google.internal.BindingImpl;
import com.plotsquared.google.internal.BoundProviderFactory;
import com.plotsquared.google.internal.ConstantFactory;
import com.plotsquared.google.internal.ConstructorBindingImpl;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.ErrorsException;
import com.plotsquared.google.internal.ExposedBindingImpl;
import com.plotsquared.google.internal.ExposedKeyFactory;
import com.plotsquared.google.internal.FactoryProxy;
import com.plotsquared.google.internal.Initializable;
import com.plotsquared.google.internal.Initializer;
import com.plotsquared.google.internal.InstanceBindingImpl;
import com.plotsquared.google.internal.InternalFactory;
import com.plotsquared.google.internal.InternalFactoryToInitializableAdapter;
import com.plotsquared.google.internal.InternalProviderInstanceBindingImpl;
import com.plotsquared.google.internal.LinkedBindingImpl;
import com.plotsquared.google.internal.LinkedProviderBindingImpl;
import com.plotsquared.google.internal.ProcessedBindingData;
import com.plotsquared.google.internal.ProviderInstanceBindingImpl;
import com.plotsquared.google.internal.ProviderMethod;
import com.plotsquared.google.internal.Scoping;
import com.plotsquared.google.spi.ConstructorBinding;
import com.plotsquared.google.spi.ConvertedConstantBinding;
import com.plotsquared.google.spi.ExposedBinding;
import com.plotsquared.google.spi.InjectionPoint;
import com.plotsquared.google.spi.InstanceBinding;
import com.plotsquared.google.spi.LinkedKeyBinding;
import com.plotsquared.google.spi.PrivateElements;
import com.plotsquared.google.spi.ProviderBinding;
import com.plotsquared.google.spi.ProviderInstanceBinding;
import com.plotsquared.google.spi.ProviderKeyBinding;
import com.plotsquared.google.spi.UntargettedBinding;
import java.util.Set;

final class BindingProcessor
extends AbstractBindingProcessor {
    private final Initializer initializer;

    BindingProcessor(Errors errors, Initializer initializer, ProcessedBindingData processedBindingData) {
        super(errors, processedBindingData);
        this.initializer = initializer;
    }

    @Override
    public <T> Boolean visit(Binding<T> binding) {
        Class<T> clazz = binding.getKey().getTypeLiteral().getRawType();
        if (Void.class.equals(clazz)) {
            if (binding instanceof ProviderInstanceBinding && ((ProviderInstanceBinding)binding).getUserSuppliedProvider() instanceof ProviderMethod) {
                this.errors.voidProviderMethod();
            } else {
                this.errors.missingConstantValues();
            }
            return true;
        }
        if (clazz == Provider.class) {
            this.errors.bindingToProvider();
            return true;
        }
        return (Boolean)binding.acceptTargetVisitor(new AbstractBindingProcessor.Processor<T, Boolean>((BindingImpl)binding){

            @Override
            public Boolean visit(ConstructorBinding<? extends T> constructorBinding) {
                this.prepareBinding();
                try {
                    ConstructorBindingImpl constructorBindingImpl = ConstructorBindingImpl.create(BindingProcessor.this.injector, this.key, constructorBinding.getConstructor(), this.source, this.scoping, BindingProcessor.this.errors, false, false);
                    this.scheduleInitialization(constructorBindingImpl);
                    BindingProcessor.this.putBinding(constructorBindingImpl);
                }
                catch (ErrorsException errorsException) {
                    BindingProcessor.this.errors.merge(errorsException.getErrors());
                    BindingProcessor.this.putBinding(BindingProcessor.this.invalidBinding(BindingProcessor.this.injector, this.key, this.source));
                }
                return true;
            }

            @Override
            public Boolean visit(InstanceBinding<? extends T> instanceBinding) {
                this.prepareBinding();
                Set<InjectionPoint> set = instanceBinding.getInjectionPoints();
                Object t = instanceBinding.getInstance();
                InstanceBinding instanceBinding2 = instanceBinding;
                Initializable initializable = BindingProcessor.this.initializer.requestInjection(BindingProcessor.this.injector, null, t, instanceBinding2, this.source, set, BindingProcessor.this.errors);
                ConstantFactory constantFactory = new ConstantFactory(initializable);
                InternalFactory internalFactory = Scoping.scope(this.key, BindingProcessor.this.injector, constantFactory, this.source, this.scoping);
                BindingProcessor.this.putBinding(new InstanceBindingImpl(BindingProcessor.this.injector, this.key, this.source, internalFactory, set, t));
                return true;
            }

            @Override
            public Boolean visit(ProviderInstanceBinding<? extends T> providerInstanceBinding) {
                this.prepareBinding();
                jakarta.inject.Provider provider = providerInstanceBinding.getUserSuppliedProvider();
                if (provider instanceof InternalProviderInstanceBindingImpl.Factory) {
                    InternalProviderInstanceBindingImpl.Factory factory = (InternalProviderInstanceBindingImpl.Factory)provider;
                    return this.visitInternalProviderInstanceBindingFactory(factory);
                }
                Set<InjectionPoint> set = providerInstanceBinding.getInjectionPoints();
                Initializable initializable = BindingProcessor.this.initializer.requestInjection(BindingProcessor.this.injector, null, provider, null, this.source, set, BindingProcessor.this.errors);
                InternalFactoryToInitializableAdapter internalFactoryToInitializableAdapter = new InternalFactoryToInitializableAdapter(initializable, this.source, BindingProcessor.this.injector.provisionListenerStore.get(providerInstanceBinding));
                InternalFactory internalFactory = Scoping.scope(this.key, BindingProcessor.this.injector, internalFactoryToInitializableAdapter, this.source, this.scoping);
                BindingProcessor.this.putBinding(new ProviderInstanceBindingImpl(BindingProcessor.this.injector, this.key, this.source, internalFactory, this.scoping, provider, set));
                return true;
            }

            @Override
            public Boolean visit(ProviderKeyBinding<? extends T> providerKeyBinding) {
                this.prepareBinding();
                Key key = providerKeyBinding.getProviderKey();
                BoundProviderFactory boundProviderFactory = new BoundProviderFactory(BindingProcessor.this.injector, key, this.source, BindingProcessor.this.injector.provisionListenerStore.get(providerKeyBinding));
                BindingProcessor.this.processedBindingData.addCreationListener(boundProviderFactory);
                InternalFactory internalFactory = Scoping.scope(this.key, BindingProcessor.this.injector, boundProviderFactory, this.source, this.scoping);
                BindingProcessor.this.putBinding(new LinkedProviderBindingImpl(BindingProcessor.this.injector, this.key, this.source, internalFactory, this.scoping, key));
                return true;
            }

            @Override
            public Boolean visit(LinkedKeyBinding<? extends T> linkedKeyBinding) {
                this.prepareBinding();
                Key key = linkedKeyBinding.getLinkedKey();
                if (this.key.equals(key)) {
                    BindingProcessor.this.errors.recursiveBinding(this.key, key);
                }
                FactoryProxy factoryProxy = new FactoryProxy(BindingProcessor.this.injector, this.key, key, this.source);
                BindingProcessor.this.processedBindingData.addCreationListener(factoryProxy);
                InternalFactory internalFactory = Scoping.scope(this.key, BindingProcessor.this.injector, factoryProxy, this.source, this.scoping);
                BindingProcessor.this.putBinding(new LinkedBindingImpl(BindingProcessor.this.injector, this.key, this.source, internalFactory, this.scoping, key));
                return true;
            }

            private Boolean visitInternalProviderInstanceBindingFactory(InternalProviderInstanceBindingImpl.Factory<T> factory) {
                InternalProviderInstanceBindingImpl internalProviderInstanceBindingImpl = new InternalProviderInstanceBindingImpl(BindingProcessor.this.injector, this.key, this.source, factory, Scoping.scope(this.key, BindingProcessor.this.injector, factory, this.source, this.scoping), this.scoping);
                switch (internalProviderInstanceBindingImpl.getInitializationTiming()) {
                    case DELAYED: {
                        this.scheduleDelayedInitialization(internalProviderInstanceBindingImpl);
                        break;
                    }
                    case EAGER: {
                        this.scheduleInitialization(internalProviderInstanceBindingImpl);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                BindingProcessor.this.putBinding(internalProviderInstanceBindingImpl);
                return true;
            }

            @Override
            public Boolean visit(UntargettedBinding<? extends T> untargettedBinding) {
                return false;
            }

            @Override
            public Boolean visit(ExposedBinding<? extends T> exposedBinding) {
                throw new IllegalArgumentException("Cannot apply a non-module element");
            }

            @Override
            public Boolean visit(ConvertedConstantBinding<? extends T> convertedConstantBinding) {
                throw new IllegalArgumentException("Cannot apply a non-module element");
            }

            @Override
            public Boolean visit(ProviderBinding<? extends T> providerBinding) {
                throw new IllegalArgumentException("Cannot apply a non-module element");
            }

            @Override
            protected Boolean visitOther(Binding<? extends T> binding) {
                throw new IllegalStateException("BindingProcessor should override all visitations");
            }
        });
    }

    @Override
    public Boolean visit(PrivateElements privateElements) {
        for (Key<?> key : privateElements.getExposedKeys()) {
            this.bindExposed(privateElements, key);
        }
        return false;
    }

    private <T> void bindExposed(PrivateElements privateElements, Key<T> key) {
        ExposedKeyFactory<T> exposedKeyFactory = new ExposedKeyFactory<T>(key, privateElements);
        this.processedBindingData.addCreationListener(exposedKeyFactory);
        this.putBinding(new ExposedBindingImpl<T>(this.injector, privateElements.getExposedSource(key), key, exposedKeyFactory, privateElements));
    }
}

