/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.plotsquared.google.Key;
import com.plotsquared.google.internal.ConstructionContext;
import com.plotsquared.google.internal.CreationListener;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.ErrorsException;
import com.plotsquared.google.internal.InjectorImpl;
import com.plotsquared.google.internal.InternalContext;
import com.plotsquared.google.internal.InternalFactory;
import com.plotsquared.google.internal.InternalProvisionException;
import com.plotsquared.google.internal.ProviderInternalFactory;
import com.plotsquared.google.internal.ProvisionListenerStackCallback;
import com.plotsquared.google.spi.Dependency;
import jakarta.inject.Provider;

final class BoundProviderFactory<T>
extends ProviderInternalFactory<T>
implements CreationListener {
    private final ProvisionListenerStackCallback<T> provisionCallback;
    private final InjectorImpl injector;
    final Key<? extends Provider<? extends T>> providerKey;
    private InternalFactory<? extends Provider<? extends T>> providerFactory;

    BoundProviderFactory(InjectorImpl injectorImpl, Key<? extends Provider<? extends T>> key, Object object, ProvisionListenerStackCallback<T> provisionListenerStackCallback) {
        super(object);
        this.provisionCallback = provisionListenerStackCallback;
        this.injector = injectorImpl;
        this.providerKey = key;
    }

    @Override
    public void notify(Errors errors) {
        try {
            this.providerFactory = this.injector.getInternalFactory(this.providerKey, errors.withSource(this.source), InjectorImpl.JitLimitation.NEW_OR_EXISTING_JIT);
        }
        catch (ErrorsException errorsException) {
            errors.merge(errorsException.getErrors());
        }
    }

    @Override
    public T get(InternalContext internalContext, Dependency<?> dependency, boolean bl) {
        try {
            Provider<? extends T> provider = this.providerFactory.get(internalContext, dependency, true);
            return this.circularGet(provider, internalContext, dependency, this.provisionCallback);
        }
        catch (InternalProvisionException internalProvisionException) {
            throw internalProvisionException.addSource(this.providerKey);
        }
    }

    @Override
    protected T provision(Provider<? extends T> provider, Dependency<?> dependency, ConstructionContext<T> constructionContext) {
        try {
            return super.provision(provider, dependency, constructionContext);
        }
        catch (RuntimeException runtimeException) {
            throw InternalProvisionException.errorInProvider(runtimeException);
        }
    }

    public String toString() {
        return this.providerKey.toString();
    }
}

