/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.collect.ImmutableSet;
import com.plotsquared.google.Binder;
import com.plotsquared.google.Key;
import com.plotsquared.google.binder.AnnotatedConstantBindingBuilder;
import com.plotsquared.google.binder.ConstantBindingBuilder;
import com.plotsquared.google.internal.AbstractBindingBuilder;
import com.plotsquared.google.internal.BindingImpl;
import com.plotsquared.google.internal.InstanceBindingImpl;
import com.plotsquared.google.spi.Element;
import com.plotsquared.google.spi.InjectionPoint;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;

public final class ConstantBindingBuilderImpl<T>
extends AbstractBindingBuilder<T>
implements AnnotatedConstantBindingBuilder,
ConstantBindingBuilder {
    public ConstantBindingBuilderImpl(Binder binder, List<Element> list, Object object) {
        super(binder, list, object, NULL_KEY);
    }

    @Override
    public ConstantBindingBuilder annotatedWith(Class<? extends Annotation> clazz) {
        this.annotatedWithInternal(clazz);
        return this;
    }

    @Override
    public ConstantBindingBuilder annotatedWith(Annotation annotation) {
        this.annotatedWithInternal(annotation);
        return this;
    }

    @Override
    public void to(String string) {
        this.toConstant(String.class, string);
    }

    @Override
    public void to(int n) {
        this.toConstant(Integer.class, n);
    }

    @Override
    public void to(long l) {
        this.toConstant(Long.class, l);
    }

    @Override
    public void to(boolean bl) {
        this.toConstant(Boolean.class, bl);
    }

    @Override
    public void to(double d) {
        this.toConstant(Double.class, d);
    }

    @Override
    public void to(float f) {
        this.toConstant(Float.class, Float.valueOf(f));
    }

    @Override
    public void to(short s) {
        this.toConstant(Short.class, s);
    }

    @Override
    public void to(char c) {
        this.toConstant(Character.class, Character.valueOf(c));
    }

    @Override
    public void to(byte by) {
        this.toConstant(Byte.class, by);
    }

    @Override
    public void to(Class<?> clazz) {
        this.toConstant(Class.class, clazz);
    }

    @Override
    public <E extends Enum<E>> void to(E e) {
        this.toConstant(e.getDeclaringClass(), e);
    }

    private void toConstant(Class<?> clazz, Object object) {
        Class<?> clazz2 = clazz;
        Object object2 = object;
        if (this.keyTypeIsSet()) {
            this.binder.addError("Constant value is set more than once.", new Object[0]);
            return;
        }
        BindingImpl bindingImpl = this.getBinding();
        Key<?> key = bindingImpl.getKey().ofType(clazz2);
        if (object2 == null) {
            this.binder.addError("Binding to null instances is not allowed. Use toProvider(Providers.of(null)) if this is your intended behaviour.", new Object[0]);
        }
        this.setBinding(new InstanceBindingImpl<Object>(bindingImpl.getSource(), key, bindingImpl.getScoping(), (Set<InjectionPoint>)ImmutableSet.of(), object2));
    }

    public String toString() {
        return "ConstantBindingBuilder";
    }
}

