/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.plotsquared.google.internal.BytecodeGen;
import com.plotsquared.google.internal.DelegatingInvocationHandler;
import com.plotsquared.google.internal.InjectorImpl;
import com.plotsquared.google.internal.InternalProvisionException;
import java.util.ArrayList;
import java.util.List;

final class ConstructionContext<T> {
    T currentReference;
    boolean constructing;
    List<DelegatingInvocationHandler<T>> invocationHandlers;

    ConstructionContext() {
    }

    public T getCurrentReference() {
        return this.currentReference;
    }

    public void removeCurrentReference() {
        this.currentReference = null;
    }

    public void setCurrentReference(T t) {
        this.currentReference = t;
    }

    public boolean isConstructing() {
        return this.constructing;
    }

    public void startConstruction() {
        this.constructing = true;
    }

    public void finishConstruction() {
        this.constructing = false;
        this.invocationHandlers = null;
    }

    public Object createProxy(InjectorImpl.InjectorOptions injectorOptions, Class<?> clazz) {
        if (injectorOptions.disableCircularProxies) {
            throw InternalProvisionException.circularDependenciesDisabled(clazz);
        }
        if (!clazz.isInterface()) {
            throw InternalProvisionException.cannotProxyClass(clazz);
        }
        if (this.invocationHandlers == null) {
            this.invocationHandlers = new ArrayList<DelegatingInvocationHandler<T>>();
        }
        DelegatingInvocationHandler delegatingInvocationHandler = new DelegatingInvocationHandler();
        this.invocationHandlers.add(delegatingInvocationHandler);
        return BytecodeGen.newCircularProxy(clazz, delegatingInvocationHandler);
    }

    public void setProxyDelegates(T t) {
        if (this.invocationHandlers != null) {
            for (DelegatingInvocationHandler<T> delegatingInvocationHandler : this.invocationHandlers) {
                delegatingInvocationHandler.setDelegate(t);
            }
            this.invocationHandlers = null;
        }
    }
}

