/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.plotsquared.core.aopalliance.intercept.MethodInterceptor;
import com.plotsquared.google.Binder;
import com.plotsquared.google.ConfigurationException;
import com.plotsquared.google.Key;
import com.plotsquared.google.internal.Annotations;
import com.plotsquared.google.internal.BindingImpl;
import com.plotsquared.google.internal.ConstructionProxy;
import com.plotsquared.google.internal.ConstructorInjector;
import com.plotsquared.google.internal.DefaultConstructionProxyFactory;
import com.plotsquared.google.internal.DelayedInitialize;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.GuiceInternal;
import com.plotsquared.google.internal.InjectorImpl;
import com.plotsquared.google.internal.InternalContext;
import com.plotsquared.google.internal.InternalFactory;
import com.plotsquared.google.internal.InternalProvisionException;
import com.plotsquared.google.internal.KotlinSupport;
import com.plotsquared.google.internal.ProvisionListenerStackCallback;
import com.plotsquared.google.internal.Scoping;
import com.plotsquared.google.internal.util.Classes;
import com.plotsquared.google.spi.BindingTargetVisitor;
import com.plotsquared.google.spi.ConstructorBinding;
import com.plotsquared.google.spi.Dependency;
import com.plotsquared.google.spi.Elements;
import com.plotsquared.google.spi.InjectionPoint;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class ConstructorBindingImpl<T>
extends BindingImpl<T>
implements ConstructorBinding<T>,
DelayedInitialize {
    private final Factory<T> factory;
    private final InjectionPoint constructorInjectionPoint;

    private ConstructorBindingImpl(InjectorImpl injectorImpl, Key<T> key, Object object, InternalFactory<? extends T> internalFactory, Scoping scoping, Factory<T> factory, InjectionPoint injectionPoint) {
        super(injectorImpl, key, object, internalFactory, scoping);
        this.factory = factory;
        this.constructorInjectionPoint = injectionPoint;
    }

    public ConstructorBindingImpl(Key<T> key, Object object, Scoping scoping, InjectionPoint injectionPoint, Set<InjectionPoint> set) {
        super(object, key, scoping);
        this.factory = new Factory(false, key);
        ConstructionProxy constructionProxy = new DefaultConstructionProxyFactory(injectionPoint).create();
        this.constructorInjectionPoint = injectionPoint;
        ((Factory)this.factory).constructorInjector = new ConstructorInjector(set, constructionProxy, null, null);
    }

    static <T> ConstructorBindingImpl<T> create(InjectorImpl injectorImpl, Key<T> key, InjectionPoint injectionPoint, Object object, Scoping scoping, Errors errors, boolean bl, boolean bl2) {
        Object object2;
        Object object3;
        Class<Object> clazz;
        int n = errors.size();
        Class<Object> clazz2 = clazz = injectionPoint == null ? key.getTypeLiteral().getRawType() : injectionPoint.getDeclaringType().getRawType();
        if (Modifier.isAbstract(clazz.getModifiers())) {
            errors.missingImplementationWithHint(key, injectorImpl);
        }
        if (Classes.isInnerClass(clazz)) {
            errors.cannotInjectInnerClass(clazz);
        }
        if (KotlinSupport.getInstance().isLocalClass(clazz)) {
            errors.cannotInjectLocalClass(clazz);
        }
        errors.throwIfNewErrors(n);
        if (injectionPoint == null) {
            try {
                injectionPoint = InjectionPoint.forConstructorOf(key.getTypeLiteral(), bl2);
            }
            catch (ConfigurationException configurationException) {
                throw errors.merge(configurationException.getErrorMessages()).toException();
            }
        }
        if (!scoping.isExplicitlyScoped() && (object3 = Annotations.findScopeAnnotation(errors, object2 = injectionPoint.getMember().getDeclaringClass())) != null) {
            scoping = Scoping.makeInjectable(Scoping.forAnnotation(object3), injectorImpl, errors.withSource(clazz));
        }
        errors.throwIfNewErrors(n);
        object2 = new Factory(bl, key);
        object3 = Scoping.scope(key, injectorImpl, object2, object, scoping);
        return new ConstructorBindingImpl<T>(injectorImpl, key, object, object3, scoping, object2, injectionPoint);
    }

    @Override
    public void initialize(InjectorImpl injectorImpl, Errors errors) {
        ((Factory)this.factory).constructorInjector = injectorImpl.constructors.get(this.constructorInjectionPoint, errors);
        ((Factory)this.factory).provisionCallback = injectorImpl.provisionListenerStore.get(this);
    }

    boolean isInitialized() {
        return ((Factory)this.factory).constructorInjector != null;
    }

    InjectionPoint getInternalConstructor() {
        if (((Factory)this.factory).constructorInjector != null) {
            return ((Factory)this.factory).constructorInjector.getConstructionProxy().getInjectionPoint();
        }
        return this.constructorInjectionPoint;
    }

    Set<Dependency<?>> getInternalDependencies() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (((Factory)this.factory).constructorInjector == null) {
            builder.add((Object)this.constructorInjectionPoint);
            try {
                builder.addAll(InjectionPoint.forInstanceMethodsAndFields(this.constructorInjectionPoint.getDeclaringType()));
            }
            catch (ConfigurationException configurationException) {}
        } else {
            builder.add((Object)this.getConstructor()).addAll(this.getInjectableMembers());
        }
        return Dependency.forInjectionPoints((Set<InjectionPoint>)builder.build());
    }

    @Override
    public <V> V acceptTargetVisitor(BindingTargetVisitor<? super T, V> bindingTargetVisitor) {
        Preconditions.checkState((((Factory)this.factory).constructorInjector != null ? 1 : 0) != 0, (Object)"not initialized");
        return bindingTargetVisitor.visit(this);
    }

    @Override
    public InjectionPoint getConstructor() {
        Preconditions.checkState((((Factory)this.factory).constructorInjector != null ? 1 : 0) != 0, (Object)"Binding is not ready");
        return ((Factory)this.factory).constructorInjector.getConstructionProxy().getInjectionPoint();
    }

    @Override
    public Set<InjectionPoint> getInjectableMembers() {
        Preconditions.checkState((((Factory)this.factory).constructorInjector != null ? 1 : 0) != 0, (Object)"Binding is not ready");
        return ((Factory)this.factory).constructorInjector.getInjectableMembers();
    }

    @Override
    public Map<Method, List<MethodInterceptor>> getMethodInterceptors() {
        Preconditions.checkState((((Factory)this.factory).constructorInjector != null ? 1 : 0) != 0, (Object)"Binding is not ready");
        return ((Factory)this.factory).constructorInjector.getConstructionProxy().getMethodInterceptors();
    }

    @Override
    public Set<Dependency<?>> getDependencies() {
        return Dependency.forInjectionPoints((Set<InjectionPoint>)new ImmutableSet.Builder().add((Object)this.getConstructor()).addAll(this.getInjectableMembers()).build());
    }

    @Override
    protected BindingImpl<T> withScoping(Scoping scoping) {
        return new ConstructorBindingImpl(null, this.getKey(), this.getSource(), this.factory, scoping, this.factory, this.constructorInjectionPoint);
    }

    @Override
    protected BindingImpl<T> withKey(Key<T> key) {
        return new ConstructorBindingImpl<T>(null, key, this.getSource(), this.factory, this.getScoping(), this.factory, this.constructorInjectionPoint);
    }

    @Override
    public void applyTo(Binder binder) {
        InjectionPoint injectionPoint = this.getConstructor();
        this.getScoping().applyTo(Elements.withTrustedSource(GuiceInternal.GUICE_INTERNAL, binder, this.getSource()).bind(this.getKey()).toConstructor((Constructor)this.getConstructor().getMember(), injectionPoint.getDeclaringType()));
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(ConstructorBinding.class).add("key", this.getKey()).add("source", this.getSource()).add("scope", (Object)this.getScoping()).toString();
    }

    public boolean equals(Object object) {
        if (object instanceof ConstructorBindingImpl) {
            ConstructorBindingImpl constructorBindingImpl = (ConstructorBindingImpl)object;
            return this.getKey().equals(constructorBindingImpl.getKey()) && this.getScoping().equals(constructorBindingImpl.getScoping()) && Objects.equal((Object)this.constructorInjectionPoint, (Object)constructorBindingImpl.constructorInjectionPoint);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getKey(), this.getScoping(), this.constructorInjectionPoint});
    }

    private static class Factory<T>
    implements InternalFactory<T> {
        private final boolean failIfNotLinked;
        private final Key<?> key;
        private ConstructorInjector<T> constructorInjector;
        private ProvisionListenerStackCallback<T> provisionCallback;

        Factory(boolean bl, Key<?> key) {
            this.failIfNotLinked = bl;
            this.key = key;
        }

        @Override
        public T get(InternalContext internalContext, Dependency<?> dependency, boolean bl) {
            ConstructorInjector<T> constructorInjector = this.constructorInjector;
            if (constructorInjector == null) {
                throw new IllegalStateException("Constructor not ready");
            }
            if (!bl && this.failIfNotLinked) {
                throw InternalProvisionException.jitDisabled(this.key);
            }
            return (T)constructorInjector.construct(internalContext, dependency, this.provisionCallback);
        }
    }
}

