/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.collect.ImmutableSet;
import com.plotsquared.core.annotation.Nullable;
import com.plotsquared.google.internal.ConstructionContext;
import com.plotsquared.google.internal.ConstructionProxy;
import com.plotsquared.google.internal.InternalContext;
import com.plotsquared.google.internal.InternalProvisionException;
import com.plotsquared.google.internal.MembersInjectorImpl;
import com.plotsquared.google.internal.ProvisionListenerStackCallback;
import com.plotsquared.google.internal.SingleParameterInjector;
import com.plotsquared.google.spi.Dependency;
import com.plotsquared.google.spi.InjectionPoint;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;

final class ConstructorInjector<T> {
    private final ImmutableSet<InjectionPoint> injectableMembers;
    private final SingleParameterInjector<?>[] parameterInjectors;
    private final ConstructionProxy<T> constructionProxy;
    private final MembersInjectorImpl<T> membersInjector;

    ConstructorInjector(Set<InjectionPoint> set, ConstructionProxy<T> constructionProxy, SingleParameterInjector<?>[] singleParameterInjectorArray, MembersInjectorImpl<T> membersInjectorImpl) {
        this.injectableMembers = ImmutableSet.copyOf(set);
        this.constructionProxy = constructionProxy;
        this.parameterInjectors = singleParameterInjectorArray;
        this.membersInjector = membersInjectorImpl;
    }

    public ImmutableSet<InjectionPoint> getInjectableMembers() {
        return this.injectableMembers;
    }

    ConstructionProxy<T> getConstructionProxy() {
        return this.constructionProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object construct(final InternalContext internalContext, Dependency<?> dependency, @Nullable ProvisionListenerStackCallback<T> provisionListenerStackCallback) {
        final ConstructionContext constructionContext = internalContext.getConstructionContext(this);
        if (constructionContext.isConstructing()) {
            return constructionContext.createProxy(internalContext.getInjectorOptions(), dependency.getKey().getTypeLiteral().getRawType());
        }
        Object t = constructionContext.getCurrentReference();
        if (t != null) {
            if (internalContext.getInjectorOptions().disableCircularProxies) {
                throw InternalProvisionException.circularDependenciesDisabled(dependency.getKey().getTypeLiteral().getRawType());
            }
            return t;
        }
        constructionContext.startConstruction();
        try {
            if (provisionListenerStackCallback == null) {
                Object t2 = this.provision(internalContext, constructionContext);
                return t2;
            }
            T t3 = provisionListenerStackCallback.provision(internalContext, new ProvisionListenerStackCallback.ProvisionCallback<T>(){

                @Override
                public T call() {
                    return ConstructorInjector.this.provision(internalContext, constructionContext);
                }
            });
            return t3;
        }
        finally {
            constructionContext.finishConstruction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T provision(InternalContext internalContext, ConstructionContext<T> constructionContext) {
        try {
            T t;
            Object object;
            try {
                object = SingleParameterInjector.getAll(internalContext, this.parameterInjectors);
                t = this.constructionProxy.newInstance((Object[])object);
                constructionContext.setProxyDelegates(t);
            }
            finally {
                constructionContext.finishConstruction();
            }
            constructionContext.setCurrentReference(t);
            object = this.membersInjector;
            ((MembersInjectorImpl)object).injectMembers(t, internalContext, false);
            ((MembersInjectorImpl)object).notifyListeners(t);
            T t2 = t;
            return t2;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause() != null ? invocationTargetException.getCause() : invocationTargetException;
            throw InternalProvisionException.errorInjectingConstructor(throwable).addSource(this.constructionProxy.getInjectionPoint());
        }
        finally {
            constructionContext.removeCurrentReference();
        }
    }
}

