/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.collect.Lists;
import com.plotsquared.google.Key;
import com.plotsquared.google.MembersInjector;
import com.plotsquared.google.Provider;
import com.plotsquared.google.TypeLiteral;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.InjectorImpl;
import com.plotsquared.google.internal.LookupProcessor;
import com.plotsquared.google.internal.Lookups;
import com.plotsquared.google.spi.Element;
import com.plotsquared.google.spi.MembersInjectorLookup;
import com.plotsquared.google.spi.ProviderLookup;
import java.util.List;

final class DeferredLookups
implements Lookups {
    private final InjectorImpl injector;
    private final List<Element> lookups = Lists.newArrayList();

    DeferredLookups(InjectorImpl injectorImpl) {
        this.injector = injectorImpl;
    }

    void initialize(Errors errors) {
        this.injector.lookups = this.injector;
        new LookupProcessor(errors).process(this.injector, this.lookups);
    }

    @Override
    public <T> Provider<T> getProvider(Key<T> key) {
        ProviderLookup<T> providerLookup = new ProviderLookup<T>(key, key);
        this.lookups.add(providerLookup);
        return providerLookup.getProvider();
    }

    @Override
    public <T> MembersInjector<T> getMembersInjector(TypeLiteral<T> typeLiteral) {
        MembersInjectorLookup<T> membersInjectorLookup = new MembersInjectorLookup<T>(typeLiteral, typeLiteral);
        this.lookups.add(membersInjectorLookup);
        return membersInjectorLookup.getMembersInjector();
    }
}

