/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.base.MoreObjects;
import com.plotsquared.google.Key;
import com.plotsquared.google.internal.CreationListener;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.ErrorsException;
import com.plotsquared.google.internal.InjectorImpl;
import com.plotsquared.google.internal.InternalContext;
import com.plotsquared.google.internal.InternalFactory;
import com.plotsquared.google.internal.InternalProvisionException;
import com.plotsquared.google.spi.Dependency;

final class FactoryProxy<T>
implements InternalFactory<T>,
CreationListener {
    private final InjectorImpl injector;
    private final Key<T> key;
    private final Key<? extends T> targetKey;
    private final Object source;
    private InternalFactory<? extends T> targetFactory;

    FactoryProxy(InjectorImpl injectorImpl, Key<T> key, Key<? extends T> key2, Object object) {
        this.injector = injectorImpl;
        this.key = key;
        this.targetKey = key2;
        this.source = object;
    }

    @Override
    public void notify(Errors errors) {
        try {
            this.targetFactory = this.injector.getInternalFactory(this.targetKey, errors.withSource(this.source), InjectorImpl.JitLimitation.NEW_OR_EXISTING_JIT);
        }
        catch (ErrorsException errorsException) {
            errors.merge(errorsException.getErrors());
        }
    }

    @Override
    public T get(InternalContext internalContext, Dependency<?> dependency, boolean bl) {
        Key<? extends T> key = this.targetKey;
        try {
            return this.targetFactory.get(internalContext, dependency, true);
        }
        catch (InternalProvisionException internalProvisionException) {
            throw internalProvisionException.addSource(key);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(FactoryProxy.class).add("key", this.key).add("provider", this.targetFactory).toString();
    }
}

