/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.plotsquared.google.internal.ErrorId;
import com.plotsquared.google.internal.InternalErrorDetail;
import com.plotsquared.google.internal.SourceFormatter;
import com.plotsquared.google.spi.ErrorDetail;
import java.io.Serializable;
import java.util.Formatter;
import java.util.List;

public final class GenericErrorDetail
extends InternalErrorDetail<GenericErrorDetail>
implements Serializable {
    public GenericErrorDetail(ErrorId errorId, String string, List<Object> list, Throwable throwable) {
        super(errorId, (String)Preconditions.checkNotNull((Object)string, (Object)"message"), list, throwable);
    }

    @Override
    public void formatDetail(List<ErrorDetail<?>> list, Formatter formatter) {
        Preconditions.checkArgument((boolean)list.isEmpty(), (Object)"Unexpected mergeable errors");
        List<Object> list2 = this.getSources();
        for (Object e : Lists.reverse(list2)) {
            formatter.format("  ", new Object[0]);
            new SourceFormatter(e, formatter, false).format();
        }
    }

    @Override
    public GenericErrorDetail withSources(List<Object> list) {
        return new GenericErrorDetail(this.errorId, this.getMessage(), list, this.getCause());
    }
}

