/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.base.Objects;
import com.plotsquared.google.Binding;
import com.plotsquared.google.Injector;
import com.plotsquared.google.Scope;
import com.plotsquared.google.Scopes;
import com.plotsquared.google.TypeLiteral;
import com.plotsquared.google.internal.Element;
import com.plotsquared.google.spi.BindingScopingVisitor;
import com.plotsquared.google.spi.ConstructorBinding;
import com.plotsquared.google.spi.ConvertedConstantBinding;
import com.plotsquared.google.spi.DefaultBindingTargetVisitor;
import com.plotsquared.google.spi.ExposedBinding;
import com.plotsquared.google.spi.InstanceBinding;
import com.plotsquared.google.spi.LinkedKeyBinding;
import com.plotsquared.google.spi.ProviderBinding;
import com.plotsquared.google.spi.ProviderInstanceBinding;
import com.plotsquared.google.spi.ProviderKeyBinding;
import com.plotsquared.google.spi.UntargettedBinding;
import java.lang.annotation.Annotation;

class Indexer
extends DefaultBindingTargetVisitor<Object, IndexedBinding>
implements BindingScopingVisitor<Object> {
    final Injector injector;
    private static final Object EAGER_SINGLETON = new Object();

    Indexer(Injector injector) {
        this.injector = injector;
    }

    boolean isIndexable(Binding<?> binding) {
        return binding.getKey().getAnnotation() instanceof Element;
    }

    private Object scope(Binding<?> binding) {
        return binding.acceptScopingVisitor(this);
    }

    @Override
    public IndexedBinding visit(ConstructorBinding<? extends Object> constructorBinding) {
        return new IndexedBinding(constructorBinding, BindingType.CONSTRUCTOR, this.scope(constructorBinding), constructorBinding.getConstructor());
    }

    @Override
    public IndexedBinding visit(ConvertedConstantBinding<? extends Object> convertedConstantBinding) {
        return new IndexedBinding(convertedConstantBinding, BindingType.CONSTANT, this.scope(convertedConstantBinding), convertedConstantBinding.getValue());
    }

    @Override
    public IndexedBinding visit(ExposedBinding<? extends Object> exposedBinding) {
        return new IndexedBinding(exposedBinding, BindingType.EXPOSED, this.scope(exposedBinding), exposedBinding);
    }

    @Override
    public IndexedBinding visit(InstanceBinding<? extends Object> instanceBinding) {
        return new IndexedBinding(instanceBinding, BindingType.INSTANCE, this.scope(instanceBinding), instanceBinding.getInstance());
    }

    @Override
    public IndexedBinding visit(LinkedKeyBinding<? extends Object> linkedKeyBinding) {
        return new IndexedBinding(linkedKeyBinding, BindingType.LINKED_KEY, this.scope(linkedKeyBinding), linkedKeyBinding.getLinkedKey());
    }

    @Override
    public IndexedBinding visit(ProviderBinding<? extends Object> providerBinding) {
        return new IndexedBinding(providerBinding, BindingType.PROVIDED_BY, this.scope(providerBinding), this.injector.getBinding(providerBinding.getProvidedKey()));
    }

    @Override
    public IndexedBinding visit(ProviderInstanceBinding<? extends Object> providerInstanceBinding) {
        return new IndexedBinding(providerInstanceBinding, BindingType.PROVIDER_INSTANCE, this.scope(providerInstanceBinding), providerInstanceBinding.getUserSuppliedProvider());
    }

    @Override
    public IndexedBinding visit(ProviderKeyBinding<? extends Object> providerKeyBinding) {
        return new IndexedBinding(providerKeyBinding, BindingType.PROVIDER_KEY, this.scope(providerKeyBinding), providerKeyBinding.getProviderKey());
    }

    @Override
    public IndexedBinding visit(UntargettedBinding<? extends Object> untargettedBinding) {
        return new IndexedBinding(untargettedBinding, BindingType.UNTARGETTED, this.scope(untargettedBinding), null);
    }

    @Override
    public Object visitEagerSingleton() {
        return EAGER_SINGLETON;
    }

    @Override
    public Object visitNoScoping() {
        return Scopes.NO_SCOPE;
    }

    @Override
    public Object visitScope(Scope scope) {
        return scope;
    }

    @Override
    public Object visitScopeAnnotation(Class<? extends Annotation> clazz) {
        return clazz;
    }

    static class IndexedBinding {
        final String annotationName;
        final Element.Type annotationType;
        final TypeLiteral<?> typeLiteral;
        final Object scope;
        final BindingType type;
        final Object extraEquality;

        IndexedBinding(Binding<?> binding, BindingType bindingType, Object object, Object object2) {
            this.scope = object;
            this.type = bindingType;
            this.extraEquality = object2;
            this.typeLiteral = binding.getKey().getTypeLiteral();
            Element element = (Element)binding.getKey().getAnnotation();
            this.annotationName = element.setName();
            this.annotationType = element.type();
        }

        public boolean equals(Object object) {
            if (!(object instanceof IndexedBinding)) {
                return false;
            }
            IndexedBinding indexedBinding = (IndexedBinding)object;
            return this.type == indexedBinding.type && Objects.equal((Object)this.scope, (Object)indexedBinding.scope) && this.typeLiteral.equals(indexedBinding.typeLiteral) && this.annotationType == indexedBinding.annotationType && this.annotationName.equals(indexedBinding.annotationName) && Objects.equal((Object)this.extraEquality, (Object)indexedBinding.extraEquality);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.type, this.scope, this.typeLiteral, this.annotationType, this.annotationName, this.extraEquality});
        }
    }

    static enum BindingType {
        INSTANCE,
        PROVIDER_INSTANCE,
        PROVIDER_KEY,
        LINKED_KEY,
        UNTARGETTED,
        CONSTRUCTOR,
        CONSTANT,
        EXPOSED,
        PROVIDED_BY;

    }
}

