/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.plotsquared.google.Binding;
import com.plotsquared.google.Key;
import com.plotsquared.google.Stage;
import com.plotsquared.google.TypeLiteral;
import com.plotsquared.google.internal.CycleDetectingLock;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.ErrorsException;
import com.plotsquared.google.internal.Initializable;
import com.plotsquared.google.internal.Initializables;
import com.plotsquared.google.internal.InjectorImpl;
import com.plotsquared.google.internal.InternalProvisionException;
import com.plotsquared.google.internal.MembersInjectorImpl;
import com.plotsquared.google.internal.ProvisionListenerStackCallback;
import com.plotsquared.google.spi.InjectionPoint;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;

final class Initializer {
    private volatile boolean validationStarted = false;
    private final CycleDetectingLock.CycleDetectingLockFactory<Class<?>> cycleDetectingLockFactory = new CycleDetectingLock.CycleDetectingLockFactory();
    private final List<InjectableReference<?>> pendingInjections = Lists.newArrayList();
    private final IdentityHashMap<Object, InjectableReference<?>> initializablesCache = Maps.newIdentityHashMap();

    Initializer() {
    }

    <T> Initializable<T> requestInjection(InjectorImpl injectorImpl, TypeLiteral<T> typeLiteral, T t, Binding<T> binding, Object object, Set<InjectionPoint> set, Errors errors) {
        InjectableReference<Object> injectableReference;
        ProvisionListenerStackCallback<T> provisionListenerStackCallback;
        Preconditions.checkNotNull((Object)object);
        Preconditions.checkState((!this.validationStarted ? 1 : 0) != 0, (Object)"Member injection could not be requested after validation is started");
        ProvisionListenerStackCallback<T> provisionListenerStackCallback2 = provisionListenerStackCallback = binding == null ? null : injectorImpl.provisionListenerStore.get(binding);
        if (t == null || set.isEmpty() && !injectorImpl.membersInjectorStore.hasTypeListeners() && provisionListenerStackCallback == null) {
            return Initializables.of(t);
        }
        if (typeLiteral == null) {
            injectableReference = TypeLiteral.get(t.getClass());
            typeLiteral = injectableReference;
        }
        if (this.initializablesCache.containsKey(t)) {
            injectableReference = this.initializablesCache.get(t);
            if (!((InjectableReference)injectableReference).type.equals(typeLiteral)) {
                errors.requestInjectionWithDifferentTypes(t, ((InjectableReference)injectableReference).type, ((InjectableReference)injectableReference).source, typeLiteral);
            }
            return injectableReference;
        }
        injectableReference = new InjectableReference<T>(injectorImpl, t, typeLiteral, binding == null ? null : binding.getKey(), provisionListenerStackCallback, object, this.cycleDetectingLockFactory.create(t.getClass()));
        this.initializablesCache.put(t, injectableReference);
        this.pendingInjections.add(injectableReference);
        return injectableReference;
    }

    void validateOustandingInjections(Errors errors) {
        this.validationStarted = true;
        this.initializablesCache.clear();
        for (InjectableReference<?> injectableReference : this.pendingInjections) {
            try {
                injectableReference.validate(errors);
            }
            catch (ErrorsException errorsException) {
                errors.merge(errorsException.getErrors());
            }
        }
    }

    void injectAll(Errors errors) {
        Preconditions.checkState((boolean)this.validationStarted, (Object)"Validation should be done before injection");
        for (InjectableReference<?> injectableReference : this.pendingInjections) {
            try {
                injectableReference.get();
            }
            catch (InternalProvisionException internalProvisionException) {
                errors.merge(internalProvisionException);
            }
        }
        this.pendingInjections.clear();
    }

    private static class InjectableReference<T>
    implements Initializable<T> {
        private volatile InjectableReferenceState state = InjectableReferenceState.NEW;
        private volatile MembersInjectorImpl<T> membersInjector = null;
        private final InjectorImpl injector;
        private final T instance;
        private final TypeLiteral<T> type;
        private final Object source;
        private final Key<T> key;
        private final ProvisionListenerStackCallback<T> provisionCallback;
        private final CycleDetectingLock<?> lock;

        public InjectableReference(InjectorImpl injectorImpl, T t, TypeLiteral<T> typeLiteral, Key<T> key, ProvisionListenerStackCallback<T> provisionListenerStackCallback, Object object, CycleDetectingLock<?> cycleDetectingLock) {
            this.injector = injectorImpl;
            this.key = key;
            this.provisionCallback = provisionListenerStackCallback;
            this.instance = Preconditions.checkNotNull(t, (Object)"instance");
            this.type = (TypeLiteral)Preconditions.checkNotNull(typeLiteral, (Object)"type");
            this.source = Preconditions.checkNotNull((Object)object, (Object)"source");
            this.lock = (CycleDetectingLock)Preconditions.checkNotNull(cycleDetectingLock, (Object)"lock");
        }

        public void validate(Errors errors) {
            this.membersInjector = this.injector.membersInjectorStore.get(this.type, errors.withSource(this.source));
            Preconditions.checkNotNull(this.membersInjector, (String)"No membersInjector available for type: %s, from key: %s", this.type, this.key);
            this.state = InjectableReferenceState.VALIDATED;
        }

        @Override
        public T get() {
            if (this.state == InjectableReferenceState.READY) {
                return this.instance;
            }
            ListMultimap<Thread, ?> listMultimap = this.lock.lockOrDetectPotentialLocksCycle();
            if (!listMultimap.isEmpty()) {
                return this.instance;
            }
            try {
                switch (this.state) {
                    case READY: {
                        T t = this.instance;
                        return t;
                    }
                    case INJECTING: {
                        T t = this.instance;
                        return t;
                    }
                    case VALIDATED: {
                        this.state = InjectableReferenceState.INJECTING;
                        break;
                    }
                    case NEW: {
                        throw new IllegalStateException("InjectableReference is not validated yet");
                    }
                    default: {
                        throw new IllegalStateException("Unknown state: " + (Object)((Object)this.state));
                    }
                }
                try {
                    this.membersInjector.injectAndNotify(this.instance, this.key, this.provisionCallback, this.source, this.injector.options.stage == Stage.TOOL);
                }
                catch (InternalProvisionException internalProvisionException) {
                    throw internalProvisionException.addSource(this.source);
                }
                this.state = InjectableReferenceState.READY;
                T t = this.instance;
                return t;
            }
            finally {
                this.lock.unlock();
            }
        }

        public String toString() {
            return this.instance.toString();
        }
    }

    private static enum InjectableReferenceState {
        NEW,
        VALIDATED,
        INJECTING,
        READY;

    }
}

