/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.plotsquared.google.Binder;
import com.plotsquared.google.Injector;
import com.plotsquared.google.Key;
import com.plotsquared.google.Module;
import com.plotsquared.google.Provider;
import com.plotsquared.google.Scopes;
import com.plotsquared.google.Singleton;
import com.plotsquared.google.Stage;
import com.plotsquared.google.internal.BindingProcessor;
import com.plotsquared.google.internal.ConstantFactory;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.GuiceInternal;
import com.plotsquared.google.internal.Initializables;
import com.plotsquared.google.internal.Initializer;
import com.plotsquared.google.internal.InjectorBindingData;
import com.plotsquared.google.internal.InjectorImpl;
import com.plotsquared.google.internal.InjectorJitBindingData;
import com.plotsquared.google.internal.InjectorOptionsProcessor;
import com.plotsquared.google.internal.InstanceBindingImpl;
import com.plotsquared.google.internal.InterceptorBindingProcessor;
import com.plotsquared.google.internal.InternalContext;
import com.plotsquared.google.internal.InternalFactory;
import com.plotsquared.google.internal.ListenerBindingProcessor;
import com.plotsquared.google.internal.MembersInjectorStore;
import com.plotsquared.google.internal.MessageProcessor;
import com.plotsquared.google.internal.ModuleAnnotatedMethodScannerProcessor;
import com.plotsquared.google.internal.PrivateElementProcessor;
import com.plotsquared.google.internal.PrivateElementsImpl;
import com.plotsquared.google.internal.ProcessedBindingData;
import com.plotsquared.google.internal.ProviderInstanceBindingImpl;
import com.plotsquared.google.internal.ProvisionListenerCallbackStore;
import com.plotsquared.google.internal.ScopeBindingProcessor;
import com.plotsquared.google.internal.Scoping;
import com.plotsquared.google.internal.TypeConverterBindingProcessor;
import com.plotsquared.google.internal.UntargettedBindingProcessor;
import com.plotsquared.google.internal.util.ContinuousStopwatch;
import com.plotsquared.google.internal.util.SourceProvider;
import com.plotsquared.google.spi.BindingSourceRestriction;
import com.plotsquared.google.spi.Dependency;
import com.plotsquared.google.spi.Element;
import com.plotsquared.google.spi.Elements;
import com.plotsquared.google.spi.InjectionPoint;
import com.plotsquared.google.spi.ModuleAnnotatedMethodScannerBinding;
import com.plotsquared.google.spi.PrivateElements;
import com.plotsquared.google.spi.ProvisionListenerBinding;
import com.plotsquared.google.spi.TypeListenerBinding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;

final class InjectorShell {
    private final List<Element> elements;
    private final InjectorImpl injector;

    private InjectorShell(List<Element> list, InjectorImpl injectorImpl) {
        this.elements = list;
        this.injector = injectorImpl;
    }

    InjectorImpl getInjector() {
        return this.injector;
    }

    List<Element> getElements() {
        return this.elements;
    }

    private static void bindInjector(InjectorImpl injectorImpl) {
        Key<Injector> key = Key.get(Injector.class);
        InjectorFactory injectorFactory = new InjectorFactory(injectorImpl);
        injectorImpl.getBindingData().putBinding(key, new ProviderInstanceBindingImpl<Injector>(injectorImpl, key, SourceProvider.UNKNOWN_SOURCE, injectorFactory, Scoping.UNSCOPED, injectorFactory, (Set<InjectionPoint>)ImmutableSet.of()));
    }

    private static void bindLogger(InjectorImpl injectorImpl) {
        Key<Logger> key = Key.get(Logger.class);
        LoggerFactory loggerFactory = new LoggerFactory();
        injectorImpl.getBindingData().putBinding(key, new ProviderInstanceBindingImpl<Logger>(injectorImpl, key, SourceProvider.UNKNOWN_SOURCE, loggerFactory, Scoping.UNSCOPED, loggerFactory, (Set<InjectionPoint>)ImmutableSet.of()));
    }

    private static void bindStage(InjectorImpl injectorImpl, Stage stage) {
        Key<Stage> key = Key.get(Stage.class);
        InstanceBindingImpl<Stage> instanceBindingImpl = new InstanceBindingImpl<Stage>(injectorImpl, key, SourceProvider.UNKNOWN_SOURCE, new ConstantFactory<Stage>(Initializables.of(stage)), (Set<InjectionPoint>)ImmutableSet.of(), stage);
        injectorImpl.getBindingData().putBinding(key, instanceBindingImpl);
    }

    private static class InheritedScannersModule
    implements Module {
        private final InjectorBindingData bindingData;

        InheritedScannersModule(InjectorBindingData injectorBindingData) {
            this.bindingData = injectorBindingData;
        }

        @Override
        public void configure(Binder binder) {
            for (ModuleAnnotatedMethodScannerBinding moduleAnnotatedMethodScannerBinding : this.bindingData.getScannerBindings()) {
                moduleAnnotatedMethodScannerBinding.applyTo(binder);
            }
        }
    }

    private static class RootModule
    implements Module {
        private RootModule() {
        }

        @Override
        public void configure(Binder binder) {
            binder = binder.withSource(SourceProvider.UNKNOWN_SOURCE);
            binder.bindScope(Singleton.class, Scopes.SINGLETON);
            binder.bindScope(jakarta.inject.Singleton.class, Scopes.SINGLETON);
        }
    }

    private static class LoggerFactory
    implements InternalFactory<Logger>,
    Provider<Logger> {
        private LoggerFactory() {
        }

        @Override
        public Logger get(InternalContext internalContext, Dependency<?> dependency, boolean bl) {
            InjectionPoint injectionPoint = dependency.getInjectionPoint();
            return injectionPoint == null ? Logger.getAnonymousLogger() : Logger.getLogger(injectionPoint.getMember().getDeclaringClass().getName());
        }

        @Override
        public Logger get() {
            return Logger.getAnonymousLogger();
        }

        public String toString() {
            return "Provider<Logger>";
        }
    }

    private static class InjectorFactory
    implements InternalFactory<Injector>,
    Provider<Injector> {
        private final Injector injector;

        private InjectorFactory(Injector injector) {
            this.injector = injector;
        }

        @Override
        public Injector get(InternalContext internalContext, Dependency<?> dependency, boolean bl) {
            return this.injector;
        }

        @Override
        public Injector get() {
            return this.injector;
        }

        public String toString() {
            return "Provider<Injector>";
        }
    }

    static class Builder {
        private final List<Element> elements = Lists.newArrayList();
        private final List<Module> modules = Lists.newArrayList();
        private InjectorBindingData bindingData;
        private InjectorJitBindingData jitBindingData;
        private InjectorImpl parent;
        private InjectorImpl.InjectorOptions options;
        private Stage stage;
        private PrivateElementsImpl privateElements;

        Builder() {
        }

        Builder stage(Stage stage) {
            this.stage = stage;
            return this;
        }

        Builder parent(InjectorImpl injectorImpl) {
            this.parent = injectorImpl;
            this.jitBindingData = new InjectorJitBindingData(Optional.of(injectorImpl.getJitBindingData()));
            this.bindingData = new InjectorBindingData(Optional.of(injectorImpl.getBindingData()));
            this.options = injectorImpl.options;
            this.stage = this.options.stage;
            return this;
        }

        Builder privateElements(PrivateElements privateElements) {
            this.privateElements = (PrivateElementsImpl)privateElements;
            this.elements.addAll(privateElements.getElements());
            return this;
        }

        void addModules(Iterable<? extends Module> iterable) {
            for (Module module : iterable) {
                this.modules.add(module);
            }
        }

        Stage getStage() {
            return this.options.stage;
        }

        Object lock() {
            if (this.bindingData == null) {
                this.jitBindingData = new InjectorJitBindingData(Optional.empty());
                this.bindingData = new InjectorBindingData(Optional.empty());
            }
            return this.jitBindingData.lock();
        }

        List<InjectorShell> build(Initializer initializer, ProcessedBindingData processedBindingData, ContinuousStopwatch continuousStopwatch, Errors errors) {
            Preconditions.checkState((this.stage != null ? 1 : 0) != 0, (Object)"Stage not initialized");
            Preconditions.checkState((this.privateElements == null || this.parent != null ? 1 : 0) != 0, (Object)"PrivateElements with no parent");
            Preconditions.checkState((this.bindingData != null ? 1 : 0) != 0, (Object)"no binding data. Did you remember to lock() ?");
            Preconditions.checkState((this.privateElements == null && this.elements.isEmpty() || this.modules.isEmpty() ? 1 : 0) != 0, (Object)"The shell is either built from modules (root) or from PrivateElements (children).");
            if (this.parent == null) {
                this.modules.add(0, new RootModule());
            } else {
                this.modules.add(0, new InheritedScannersModule(this.parent.getBindingData()));
            }
            this.elements.addAll(Elements.getElements(this.stage, this.modules));
            if (this.privateElements == null) {
                this.elements.addAll((Collection<Element>)BindingSourceRestriction.check(GuiceInternal.GUICE_INTERNAL, this.elements));
            }
            InjectorOptionsProcessor injectorOptionsProcessor = new InjectorOptionsProcessor(errors);
            injectorOptionsProcessor.process(null, this.elements);
            this.options = injectorOptionsProcessor.getOptions(this.stage, this.options);
            InjectorImpl injectorImpl = new InjectorImpl(this.parent, this.bindingData, this.jitBindingData, this.options);
            if (this.privateElements != null) {
                this.privateElements.initInjector(injectorImpl);
            }
            if (this.parent == null) {
                TypeConverterBindingProcessor.prepareBuiltInConverters(injectorImpl);
            }
            continuousStopwatch.resetAndLog("Module execution");
            new MessageProcessor(errors).process(injectorImpl, this.elements);
            new InterceptorBindingProcessor(errors).process(injectorImpl, this.elements);
            continuousStopwatch.resetAndLog("Interceptors creation");
            new ListenerBindingProcessor(errors).process(injectorImpl, this.elements);
            ImmutableList<TypeListenerBinding> immutableList = injectorImpl.getBindingData().getTypeListenerBindings();
            injectorImpl.membersInjectorStore = new MembersInjectorStore(injectorImpl, (List<TypeListenerBinding>)immutableList);
            ImmutableList<ProvisionListenerBinding> immutableList2 = injectorImpl.getBindingData().getProvisionListenerBindings();
            injectorImpl.provisionListenerStore = new ProvisionListenerCallbackStore((List<ProvisionListenerBinding>)immutableList2);
            continuousStopwatch.resetAndLog("TypeListeners & ProvisionListener creation");
            new ScopeBindingProcessor(errors).process(injectorImpl, this.elements);
            continuousStopwatch.resetAndLog("Scopes creation");
            new TypeConverterBindingProcessor(errors).process(injectorImpl, this.elements);
            continuousStopwatch.resetAndLog("Converters creation");
            InjectorShell.bindStage(injectorImpl, this.stage);
            InjectorShell.bindInjector(injectorImpl);
            InjectorShell.bindLogger(injectorImpl);
            new BindingProcessor(errors, initializer, processedBindingData).process(injectorImpl, this.elements);
            new UntargettedBindingProcessor(errors, processedBindingData).process(injectorImpl, this.elements);
            continuousStopwatch.resetAndLog("Binding creation");
            new ModuleAnnotatedMethodScannerProcessor(errors).process(injectorImpl, this.elements);
            continuousStopwatch.resetAndLog("Module annotated method scanners creation");
            ArrayList arrayList = Lists.newArrayList();
            arrayList.add(new InjectorShell(this.elements, injectorImpl));
            PrivateElementProcessor privateElementProcessor = new PrivateElementProcessor(errors);
            privateElementProcessor.process(injectorImpl, this.elements);
            for (Builder builder : privateElementProcessor.getInjectorShellBuilders()) {
                arrayList.addAll(builder.build(initializer, processedBindingData, continuousStopwatch, errors));
            }
            continuousStopwatch.resetAndLog("Private environment creation");
            return arrayList;
        }
    }
}

