/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.collect.Lists;
import com.plotsquared.core.aopalliance.intercept.MethodInterceptor;
import com.plotsquared.core.aopalliance.intercept.MethodInvocation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;

final class InterceptorStackCallback
implements InvocationHandler {
    private static final String GUICE_INTERNAL_AOP_PACKAGE = "com.plotsquared.google.internal.aop";
    final Method method;
    final MethodInterceptor[] interceptors;
    final BiFunction<Object, Object[], Object> superInvoker;

    public InterceptorStackCallback(Method method, List<MethodInterceptor> list, BiFunction<Object, Object[], Object> biFunction) {
        this.method = method;
        this.interceptors = list.toArray(new MethodInterceptor[list.size()]);
        this.superInvoker = biFunction;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) {
        return new InterceptedMethodInvocation(object, objectArray, 0).proceed();
    }

    private void pruneStacktrace(Throwable throwable) {
        for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            StackTraceElement[] stackTraceElementArray = throwable2.getStackTrace();
            ArrayList arrayList = Lists.newArrayList();
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                String string = stackTraceElement.getClassName();
                if (string.startsWith(InterceptorStackCallback.class.getName()) || string.startsWith(GUICE_INTERNAL_AOP_PACKAGE) || string.contains("$$EnhancerByGuice$$")) continue;
                arrayList.add(stackTraceElement);
            }
            throwable2.setStackTrace(arrayList.toArray(new StackTraceElement[arrayList.size()]));
        }
    }

    private class InterceptedMethodInvocation
    implements MethodInvocation {
        final Object proxy;
        final Object[] arguments;
        final int interceptorIndex;

        public InterceptedMethodInvocation(Object object, Object[] objectArray, int n) {
            this.proxy = object;
            this.arguments = objectArray;
            this.interceptorIndex = n;
        }

        @Override
        public Object proceed() {
            try {
                return this.interceptorIndex == InterceptorStackCallback.this.interceptors.length ? InterceptorStackCallback.this.superInvoker.apply(this.proxy, this.arguments) : InterceptorStackCallback.this.interceptors[this.interceptorIndex].invoke(new InterceptedMethodInvocation(this.proxy, this.arguments, this.interceptorIndex + 1));
            }
            catch (Throwable throwable) {
                InterceptorStackCallback.this.pruneStacktrace(throwable);
                throw throwable;
            }
        }

        @Override
        public Method getMethod() {
            return InterceptorStackCallback.this.method;
        }

        @Override
        public Object[] getArguments() {
            return this.arguments;
        }

        @Override
        public Object getThis() {
            return this.proxy;
        }

        @Override
        public AccessibleObject getStaticPart() {
            return this.getMethod();
        }
    }
}

