/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.base.Preconditions;
import com.plotsquared.google.internal.ConstructionContext;
import com.plotsquared.google.internal.Initializable;
import com.plotsquared.google.internal.InternalContext;
import com.plotsquared.google.internal.InternalProvisionException;
import com.plotsquared.google.internal.ProviderInternalFactory;
import com.plotsquared.google.internal.ProvisionListenerStackCallback;
import com.plotsquared.google.spi.Dependency;
import jakarta.inject.Provider;

final class InternalFactoryToInitializableAdapter<T>
extends ProviderInternalFactory<T> {
    private final ProvisionListenerStackCallback<T> provisionCallback;
    private final Initializable<? extends Provider<? extends T>> initializable;

    public InternalFactoryToInitializableAdapter(Initializable<? extends Provider<? extends T>> initializable, Object object, ProvisionListenerStackCallback<T> provisionListenerStackCallback) {
        super(object);
        this.provisionCallback = provisionListenerStackCallback;
        this.initializable = (Initializable)Preconditions.checkNotNull(initializable, (Object)"provider");
    }

    @Override
    public T get(InternalContext internalContext, Dependency<?> dependency, boolean bl) {
        return this.circularGet(this.initializable.get(), internalContext, dependency, this.provisionCallback);
    }

    @Override
    protected T provision(Provider<? extends T> provider, Dependency<?> dependency, ConstructionContext<T> constructionContext) {
        try {
            return super.provision(provider, dependency, constructionContext);
        }
        catch (RuntimeException runtimeException) {
            throw InternalProvisionException.errorInProvider(runtimeException).addSource(this.source);
        }
    }

    public String toString() {
        return this.initializable.toString();
    }
}

