/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.plotsquared.core.annotation.Nullable;
import com.plotsquared.google.Key;
import com.plotsquared.google.MembersInjector;
import com.plotsquared.google.TypeLiteral;
import com.plotsquared.google.internal.EncounterImpl;
import com.plotsquared.google.internal.InjectorImpl;
import com.plotsquared.google.internal.InternalContext;
import com.plotsquared.google.internal.InternalFlags;
import com.plotsquared.google.internal.InternalProvisionException;
import com.plotsquared.google.internal.MethodAspect;
import com.plotsquared.google.internal.ProvisionListenerStackCallback;
import com.plotsquared.google.internal.SingleMemberInjector;
import com.plotsquared.google.spi.InjectionListener;
import com.plotsquared.google.spi.InjectionPoint;

final class MembersInjectorImpl<T>
implements MembersInjector<T> {
    private final TypeLiteral<T> typeLiteral;
    private final InjectorImpl injector;
    @Nullable
    private final ImmutableList<SingleMemberInjector> memberInjectors;
    @Nullable
    private final ImmutableList<MembersInjector<? super T>> userMembersInjectors;
    @Nullable
    private final ImmutableList<InjectionListener<? super T>> injectionListeners;
    @Nullable
    private final ImmutableList<MethodAspect> addedAspects;

    MembersInjectorImpl(InjectorImpl injectorImpl, TypeLiteral<T> typeLiteral, EncounterImpl<T> encounterImpl, ImmutableList<SingleMemberInjector> immutableList) {
        this.injector = injectorImpl;
        this.typeLiteral = typeLiteral;
        this.memberInjectors = immutableList.isEmpty() ? null : immutableList;
        this.userMembersInjectors = encounterImpl.getMembersInjectors().isEmpty() ? null : encounterImpl.getMembersInjectors().asList();
        this.injectionListeners = encounterImpl.getInjectionListeners().isEmpty() ? null : encounterImpl.getInjectionListeners().asList();
        this.addedAspects = InternalFlags.isBytecodeGenEnabled() && !encounterImpl.getAspects().isEmpty() ? encounterImpl.getAspects() : null;
    }

    public ImmutableList<SingleMemberInjector> getMemberInjectors() {
        return this.memberInjectors == null ? ImmutableList.of() : this.memberInjectors;
    }

    @Override
    public void injectMembers(T t) {
        TypeLiteral<T> typeLiteral = this.typeLiteral;
        try {
            this.injectAndNotify(t, null, null, typeLiteral, false);
        }
        catch (InternalProvisionException internalProvisionException) {
            throw internalProvisionException.addSource(typeLiteral).toProvisionException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void injectAndNotify(final T t, Key<T> key, ProvisionListenerStackCallback<T> provisionListenerStackCallback, Object object, final boolean bl) {
        if (t == null) {
            return;
        }
        try (final InternalContext internalContext = this.injector.enterContext();){
            if (provisionListenerStackCallback != null && provisionListenerStackCallback.hasListeners()) {
                provisionListenerStackCallback.provision(internalContext, new ProvisionListenerStackCallback.ProvisionCallback<T>(){

                    @Override
                    public T call() {
                        MembersInjectorImpl.this.injectMembers(t, internalContext, bl);
                        return t;
                    }
                });
            } else {
                this.injectMembers(t, internalContext, bl);
            }
        }
        if (!bl) {
            this.notifyListeners(t);
        }
    }

    void notifyListeners(T t) {
        ImmutableList<InjectionListener<? super T>> immutableList = this.injectionListeners;
        if (immutableList == null) {
            return;
        }
        for (int i = 0; i < immutableList.size(); ++i) {
            InjectionListener injectionListener = (InjectionListener)immutableList.get(i);
            try {
                injectionListener.afterInjection(t);
                continue;
            }
            catch (RuntimeException runtimeException) {
                throw InternalProvisionException.errorNotifyingInjectionListener(injectionListener, this.typeLiteral, runtimeException);
            }
        }
    }

    void injectMembers(T t, InternalContext internalContext, boolean bl) {
        ImmutableList<MembersInjector<? super T>> immutableList;
        Object object;
        int n;
        ImmutableList<SingleMemberInjector> immutableList2 = this.memberInjectors;
        if (immutableList2 != null) {
            n = immutableList2.size();
            for (int i = 0; i < n; ++i) {
                object = (SingleMemberInjector)immutableList2.get(i);
                if (bl && !object.getInjectionPoint().isToolable()) continue;
                object.inject(internalContext, t);
            }
        }
        if (!bl && (immutableList = this.userMembersInjectors) != null) {
            for (n = 0; n < immutableList.size(); ++n) {
                object = (MembersInjector)immutableList.get(n);
                try {
                    object.injectMembers(t);
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    throw InternalProvisionException.errorInUserInjector(object, this.typeLiteral, runtimeException);
                }
            }
        }
    }

    public String toString() {
        return "MembersInjector<" + this.typeLiteral + ">";
    }

    public ImmutableSet<InjectionPoint> getInjectionPoints() {
        ImmutableList<SingleMemberInjector> immutableList = this.memberInjectors;
        if (immutableList != null) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (SingleMemberInjector singleMemberInjector : immutableList) {
                builder.add((Object)singleMemberInjector.getInjectionPoint());
            }
            return builder.build();
        }
        return ImmutableSet.of();
    }

    public ImmutableList<MethodAspect> getAddedAspects() {
        return this.addedAspects == null ? ImmutableList.of() : this.addedAspects;
    }
}

