/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.plotsquared.google.Injector;
import com.plotsquared.google.Key;
import com.plotsquared.google.internal.ErrorFormatter;
import com.plotsquared.google.internal.ErrorId;
import com.plotsquared.google.internal.InternalErrorDetail;
import com.plotsquared.google.internal.Messages;
import com.plotsquared.google.internal.MissingImplementationErrorHints;
import com.plotsquared.google.spi.ErrorDetail;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

final class MissingImplementationError<T>
extends InternalErrorDetail<MissingImplementationError<T>> {
    private final Key<T> key;
    private final Supplier<ImmutableList<String>> suggestionsSupplier;

    public MissingImplementationError(Key<T> key, Injector injector, List<Object> list) {
        this(key, (Supplier<ImmutableList<String>>)Suppliers.memoize(() -> MissingImplementationErrorHints.getSuggestions(key, injector)), list);
    }

    private MissingImplementationError(Key<T> key, Supplier<ImmutableList<String>> supplier, List<Object> list) {
        super(ErrorId.MISSING_IMPLEMENTATION, String.format("No implementation for %s was bound.", Messages.convert(key)), list, null);
        this.key = key;
        this.suggestionsSupplier = supplier;
    }

    @Override
    public boolean isMergeable(ErrorDetail<?> errorDetail) {
        return errorDetail instanceof MissingImplementationError && ((MissingImplementationError)errorDetail).key.equals(this.key);
    }

    @Override
    public void formatDetail(List<ErrorDetail<?>> list2, Formatter formatter) {
        ImmutableList<String> immutableList = this.suggestionsSupplier.get();
        if (!immutableList.isEmpty()) {
            immutableList.forEach(string -> formatter.format((String)string, new Object[0]));
        }
        ArrayList<List<Object>> arrayList = new ArrayList<List<Object>>();
        arrayList.add(this.getSources());
        arrayList.addAll(list2.stream().map(ErrorDetail::getSources).collect(Collectors.toList()));
        List list3 = arrayList.stream().map(this::trimSource).filter(list -> !list.isEmpty()).collect(Collectors.toList());
        if (!list3.isEmpty()) {
            formatter.format("\n%s\n", Messages.bold("Requested by:"));
            int n = 1;
            for (List list4 : list3) {
                ErrorFormatter.formatSources(n++, Lists.reverse((List)list4), formatter);
            }
        }
    }

    @Override
    public MissingImplementationError<T> withSources(List<Object> list) {
        return new MissingImplementationError<T>(this.key, this.suggestionsSupplier, list);
    }

    private List<Object> trimSource(List<Object> list) {
        return list.stream().filter(object -> !object.equals(this.key)).collect(Collectors.toList());
    }
}

