/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Primitives;
import com.plotsquared.google.Binding;
import com.plotsquared.google.Injector;
import com.plotsquared.google.Key;
import com.plotsquared.google.TypeLiteral;
import com.plotsquared.google.internal.GuiceInternal;
import com.plotsquared.google.internal.Messages;
import com.plotsquared.google.internal.SourceFormatter;
import com.plotsquared.google.spi.BindingSourceRestriction;
import com.plotsquared.google.spi.UntargettedBinding;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Map;

final class MissingImplementationErrorHints {
    private static final int MAX_MATCHING_TYPES_REPORTED = 3;
    private static final int MAX_RELATED_TYPES_REPORTED = 3;
    private static final ImmutableSet<Class<?>> COMMON_AMBIGUOUS_TYPES = ImmutableSet.builder().add(Object.class).add(String.class).addAll((Iterable)Primitives.allWrapperTypes()).build();

    private MissingImplementationErrorHints() {
    }

    static <T> ImmutableList<String> getSuggestions(Key<T> key, Injector injector) {
        ImmutableList.Builder builder = ImmutableList.builder();
        TypeLiteral<T> typeLiteral = key.getTypeLiteral();
        BindingSourceRestriction.getMissingImplementationSuggestion(GuiceInternal.GUICE_INTERNAL, key).ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        ArrayList<String> arrayList = new ArrayList<String>();
        ImmutableList immutableList = (ImmutableList)injector.findBindingsByType(typeLiteral).stream().filter(binding -> !(binding instanceof UntargettedBinding)).collect(ImmutableList.toImmutableList());
        if (!immutableList.isEmpty()) {
            Object object;
            int n;
            builder.add((Object)"\nDid you mean?");
            int n2 = Math.min(immutableList.size(), 3);
            for (n = 0; n < n2; ++n) {
                object = ((Binding)immutableList.get(n)).getKey();
                builder.add((Object)Messages.format("\n    * %s", MissingImplementationErrorHints.formatSuggestion(object, injector.getExistingBinding(object))));
            }
            n = immutableList.size() - 3;
            if (n > 0) {
                object = n == 1 ? "" : "s";
                builder.add((Object)Messages.format("\n    * %d more binding%s with other annotations.", n, object));
            }
        } else {
            String string = typeLiteral.toString();
            Map<Key<?>, Binding<?>> map = injector.getAllBindings();
            for (Key<?> key2 : map.keySet()) {
                String string2;
                Binding<?> binding2 = map.get(key2);
                if (binding2 instanceof UntargettedBinding || !(string2 = key2.getTypeLiteral().toString()).contains(string) && !string.contains(string2)) continue;
                arrayList.add(MissingImplementationErrorHints.formatSuggestion(key2, map.get(key2)));
                if (arrayList.size() <= 3) continue;
                break;
            }
            if (!arrayList.isEmpty() && arrayList.size() <= 3) {
                builder.add((Object)"\nDid you mean?");
                for (String string3 : arrayList) {
                    builder.add((Object)Messages.format("\n    * %s", string3));
                }
            }
        }
        if (immutableList.isEmpty() && arrayList.isEmpty() && key.getAnnotationType() == null && COMMON_AMBIGUOUS_TYPES.contains(key.getTypeLiteral().getRawType())) {
            builder.add((Object)"\nThe key seems very generic, did you forget an annotation?");
        }
        return builder.build();
    }

    private static String formatSuggestion(Key<?> key, Binding<?> binding) {
        Formatter formatter = new Formatter();
        formatter.format("%s bound ", Messages.convert(key));
        new SourceFormatter(binding.getSource(), formatter, false).format();
        return formatter.toString();
    }
}

