/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.collect.Lists;
import com.plotsquared.google.internal.CreationListener;
import com.plotsquared.google.internal.Errors;
import java.util.List;

class ProcessedBindingData {
    private final List<CreationListener> creationListeners = Lists.newArrayList();
    private final List<Runnable> uninitializedBindings = Lists.newArrayList();
    private final List<Runnable> delayedUninitializedBindings = Lists.newArrayList();

    ProcessedBindingData() {
    }

    void addCreationListener(CreationListener creationListener) {
        this.creationListeners.add(creationListener);
    }

    void addUninitializedBinding(Runnable runnable) {
        this.uninitializedBindings.add(runnable);
    }

    void addDelayedUninitializedBinding(Runnable runnable) {
        this.delayedUninitializedBindings.add(runnable);
    }

    void initializeBindings() {
        for (Runnable runnable : this.uninitializedBindings) {
            runnable.run();
        }
    }

    void runCreationListeners(Errors errors) {
        for (CreationListener creationListener : this.creationListeners) {
            creationListener.notify(errors);
        }
    }

    void initializeDelayedBindings() {
        for (Runnable runnable : this.delayedUninitializedBindings) {
            runnable.run();
        }
    }
}

