/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.plotsquared.google.Binder;
import com.plotsquared.google.Binding;
import com.plotsquared.google.Injector;
import com.plotsquared.google.Key;
import com.plotsquared.google.Module;
import com.plotsquared.google.Provider;
import com.plotsquared.google.TypeLiteral;
import com.plotsquared.google.binder.LinkedBindingBuilder;
import com.plotsquared.google.internal.Element;
import com.plotsquared.google.internal.ErrorId;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.Indexer;
import com.plotsquared.google.internal.InjectorImpl;
import com.plotsquared.google.internal.InternalContext;
import com.plotsquared.google.internal.InternalProviderInstanceBindingImpl;
import com.plotsquared.google.internal.InternalProvisionException;
import com.plotsquared.google.internal.RealElement;
import com.plotsquared.google.internal.RealMultibinder;
import com.plotsquared.google.internal.SingleParameterInjector;
import com.plotsquared.google.multibindings.MapBinderBinding;
import com.plotsquared.google.multibindings.MultibindingsTargetVisitor;
import com.plotsquared.google.spi.BindingTargetVisitor;
import com.plotsquared.google.spi.Dependency;
import com.plotsquared.google.spi.Element;
import com.plotsquared.google.spi.ProviderInstanceBinding;
import com.plotsquared.google.spi.ProviderWithExtensionVisitor;
import com.plotsquared.google.util.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class RealMapBinder<K, V>
implements Module {
    private static final ImmutableSet<Dependency<?>> MODULE_DEPENDENCIES = ImmutableSet.of(Dependency.get(Key.get(Injector.class)));
    private final BindingSelection<K, V> bindingSelection;
    private final Binder binder;
    private final RealMultibinder<Map.Entry<K, Provider<V>>> entrySetBinder;

    public static <K, V> RealMapBinder<K, V> newMapRealBinder(Binder binder, TypeLiteral<K> typeLiteral, TypeLiteral<V> typeLiteral2) {
        return RealMapBinder.newRealMapBinder(binder, typeLiteral, typeLiteral2, Key.get(RealMapBinder.mapOf(typeLiteral, typeLiteral2)), RealMultibinder.newRealSetBinder(binder, Key.get(RealMapBinder.entryOfProviderOf(typeLiteral, typeLiteral2))));
    }

    public static <K, V> RealMapBinder<K, V> newRealMapBinder(Binder binder, TypeLiteral<K> typeLiteral, TypeLiteral<V> typeLiteral2, Annotation annotation) {
        return RealMapBinder.newRealMapBinder(binder, typeLiteral, typeLiteral2, Key.get(RealMapBinder.mapOf(typeLiteral, typeLiteral2), annotation), RealMultibinder.newRealSetBinder(binder, Key.get(RealMapBinder.entryOfProviderOf(typeLiteral, typeLiteral2), annotation)));
    }

    public static <K, V> RealMapBinder<K, V> newRealMapBinder(Binder binder, TypeLiteral<K> typeLiteral, TypeLiteral<V> typeLiteral2, Class<? extends Annotation> clazz) {
        return RealMapBinder.newRealMapBinder(binder, typeLiteral, typeLiteral2, Key.get(RealMapBinder.mapOf(typeLiteral, typeLiteral2), clazz), RealMultibinder.newRealSetBinder(binder, Key.get(RealMapBinder.entryOfProviderOf(typeLiteral, typeLiteral2), clazz)));
    }

    static <K, V> TypeLiteral<Map<K, V>> mapOf(TypeLiteral<K> typeLiteral, TypeLiteral<V> typeLiteral2) {
        return TypeLiteral.get(Types.mapOf(typeLiteral.getType(), typeLiteral2.getType()));
    }

    static <K, V> TypeLiteral<Map<K, Provider<V>>> mapOfProviderOf(TypeLiteral<K> typeLiteral, TypeLiteral<V> typeLiteral2) {
        return TypeLiteral.get(Types.mapOf(typeLiteral.getType(), Types.providerOf(typeLiteral2.getType())));
    }

    static <K, V> TypeLiteral<Map<K, jakarta.inject.Provider<V>>> mapOfJakartaProviderOf(TypeLiteral<K> typeLiteral, TypeLiteral<V> typeLiteral2) {
        return TypeLiteral.get(Types.mapOf(typeLiteral.getType(), Types.newParameterizedType(jakarta.inject.Provider.class, new Type[]{typeLiteral2.getType()})));
    }

    static <K, V> TypeLiteral<Map<K, Set<Provider<V>>>> mapOfSetOfProviderOf(TypeLiteral<K> typeLiteral, TypeLiteral<V> typeLiteral2) {
        return TypeLiteral.get(Types.mapOf(typeLiteral.getType(), Types.setOf(Types.providerOf(typeLiteral2.getType()))));
    }

    static <K, V> TypeLiteral<Map<K, Set<jakarta.inject.Provider<V>>>> mapOfSetOfJakartaProviderOf(TypeLiteral<K> typeLiteral, TypeLiteral<V> typeLiteral2) {
        return TypeLiteral.get(Types.mapOf(typeLiteral.getType(), Types.setOf(Types.jakartaProviderOf(typeLiteral2.getType()))));
    }

    static <K, V> TypeLiteral<Map<K, Collection<Provider<V>>>> mapOfCollectionOfProviderOf(TypeLiteral<K> typeLiteral, TypeLiteral<V> typeLiteral2) {
        return TypeLiteral.get(Types.mapOf(typeLiteral.getType(), Types.collectionOf(Types.providerOf(typeLiteral2.getType()))));
    }

    static <K, V> TypeLiteral<Map<K, Collection<jakarta.inject.Provider<V>>>> mapOfCollectionOfJakartaProviderOf(TypeLiteral<K> typeLiteral, TypeLiteral<V> typeLiteral2) {
        return TypeLiteral.get(Types.mapOf(typeLiteral.getType(), Types.collectionOf(Types.jakartaProviderOf(typeLiteral2.getType()))));
    }

    static <K, V> TypeLiteral<Map.Entry<K, Provider<V>>> entryOfProviderOf(TypeLiteral<K> typeLiteral, TypeLiteral<V> typeLiteral2) {
        return TypeLiteral.get(Types.newParameterizedTypeWithOwner(Map.class, Map.Entry.class, new Type[]{typeLiteral.getType(), Types.providerOf(typeLiteral2.getType())}));
    }

    static <K, V> TypeLiteral<Map.Entry<K, Provider<V>>> entryOfJakartaProviderOf(TypeLiteral<K> typeLiteral, TypeLiteral<V> typeLiteral2) {
        return TypeLiteral.get(Types.newParameterizedTypeWithOwner(Map.class, Map.Entry.class, new Type[]{typeLiteral.getType(), Types.jakartaProviderOf(typeLiteral2.getType())}));
    }

    static <K, V> TypeLiteral<Set<Map.Entry<K, jakarta.inject.Provider<V>>>> setOfEntryOfJakartaProviderOf(TypeLiteral<K> typeLiteral, TypeLiteral<V> typeLiteral2) {
        return TypeLiteral.get(Types.setOf(RealMapBinder.entryOfJakartaProviderOf(typeLiteral, typeLiteral2).getType()));
    }

    private static <T> Key<Provider<T>> getKeyOfProvider(Key<T> key) {
        return key.ofType(Types.providerOf(key.getTypeLiteral().getType()));
    }

    static <K, V> RealMapBinder<K, V> newRealMapBinder(Binder binder, TypeLiteral<K> typeLiteral, Key<V> key) {
        TypeLiteral<V> typeLiteral2 = key.getTypeLiteral();
        return RealMapBinder.newRealMapBinder(binder, typeLiteral, typeLiteral2, key.ofType(RealMapBinder.mapOf(typeLiteral, typeLiteral2)), RealMultibinder.newRealSetBinder(binder, key.ofType(RealMapBinder.entryOfProviderOf(typeLiteral, typeLiteral2))));
    }

    private static <K, V> RealMapBinder<K, V> newRealMapBinder(Binder binder, TypeLiteral<K> typeLiteral, TypeLiteral<V> typeLiteral2, Key<Map<K, V>> key, RealMultibinder<Map.Entry<K, Provider<V>>> realMultibinder) {
        RealMapBinder<K, V> realMapBinder = new RealMapBinder<K, V>(binder, typeLiteral, typeLiteral2, key, realMultibinder);
        binder.install(realMapBinder);
        return realMapBinder;
    }

    private RealMapBinder(Binder binder, TypeLiteral<K> typeLiteral, TypeLiteral<V> typeLiteral2, Key<Map<K, V>> key, RealMultibinder<Map.Entry<K, Provider<V>>> realMultibinder) {
        this.bindingSelection = new BindingSelection(typeLiteral, typeLiteral2, key, realMultibinder);
        this.binder = binder;
        this.entrySetBinder = realMultibinder;
    }

    public void permitDuplicates() {
        Errors.checkConfiguration(!((BindingSelection)this.bindingSelection).isInitialized(), "MapBinder was already initialized", new Object[0]);
        this.entrySetBinder.permitDuplicates();
        this.binder.install(new MultimapBinder(this.bindingSelection));
    }

    Key<V> getKeyForNewValue(K k) {
        Errors.checkNotNull(k, "key");
        Errors.checkConfiguration(!((BindingSelection)this.bindingSelection).isInitialized(), "MapBinder was already initialized", new Object[0]);
        RealMultibinder realMultibinder = ((BindingSelection)this.bindingSelection).getEntrySetBinder();
        Key key = Key.get(((BindingSelection)this.bindingSelection).getValueType(), (Annotation)new RealElement(realMultibinder.getSetName(), Element.Type.MAPBINDER, ((BindingSelection)this.bindingSelection).getKeyType().toString()));
        realMultibinder.addBinding().toProvider(new ProviderMapEntry(k, key));
        return key;
    }

    public LinkedBindingBuilder<V> addBinding(K k) {
        return this.binder.bind(this.getKeyForNewValue(k));
    }

    @Override
    public void configure(Binder binder) {
        Errors.checkConfiguration(!((BindingSelection)this.bindingSelection).isInitialized(), "MapBinder was already initialized", new Object[0]);
        binder.bind(((BindingSelection)this.bindingSelection).getProviderMapKey()).toProvider(new RealProviderMapProvider(this.bindingSelection));
        binder.bind(((BindingSelection)this.bindingSelection).getJakartaProviderMapKey()).to(((BindingSelection)this.bindingSelection).getProviderMapKey());
        binder.bind(((BindingSelection)this.bindingSelection).getMapKey()).toProvider(new ExtensionRealMapProvider<K, V>(this.bindingSelection));
        binder.bind(((BindingSelection)this.bindingSelection).getMapOfKeyExtendsValueKey()).to(((BindingSelection)this.bindingSelection).getMapKey());
        binder.bind(((BindingSelection)this.bindingSelection).getEntrySetJakartaProviderKey()).to(((BindingSelection)this.bindingSelection).getEntrySetBinder().getSetKey());
    }

    public boolean equals(Object object) {
        return object instanceof RealMapBinder && ((RealMapBinder)object).bindingSelection.equals(this.bindingSelection);
    }

    public int hashCode() {
        return this.bindingSelection.hashCode();
    }

    private static <K, V> InternalProvisionException createNullValueException(K k, Binding<V> binding) {
        return InternalProvisionException.create(ErrorId.NULL_VALUE_IN_MAP, "Map injection failed due to null value for key \"%s\", bound at: %s", k, binding.getSource());
    }

    static /* synthetic */ ImmutableSet access$1200() {
        return MODULE_DEPENDENCIES;
    }

    private static abstract class RealMultimapBinderProviderWithDependencies<K, V, P>
    extends InternalProviderInstanceBindingImpl.Factory<P> {
        final Key<Map<K, V>> mapKey;
        BindingSelection<K, V> bindingSelection;

        private RealMultimapBinderProviderWithDependencies(Key<Map<K, V>> key) {
            super(InternalProviderInstanceBindingImpl.InitializationTiming.DELAYED);
            this.mapKey = key;
        }

        @Override
        final void initialize(InjectorImpl injectorImpl, Errors errors) {
            Binding binding = injectorImpl.getExistingBinding((Key)this.mapKey);
            ProviderInstanceBinding providerInstanceBinding = (ProviderInstanceBinding)binding;
            ExtensionRealMapProvider extensionRealMapProvider = (ExtensionRealMapProvider)providerInstanceBinding.getUserSuppliedProvider();
            this.bindingSelection = extensionRealMapProvider.getBindingSelection();
            if (((BindingSelection)this.bindingSelection).tryInitialize(injectorImpl, errors)) {
                this.doInitialize(injectorImpl, errors);
            }
        }

        abstract void doInitialize(InjectorImpl var1, Errors var2);

        public boolean equals(Object object) {
            return object != null && this.getClass() == object.getClass() && this.mapKey.equals(((RealMultimapBinderProviderWithDependencies)object).mapKey);
        }

        public int hashCode() {
            return this.mapKey.hashCode();
        }
    }

    private static abstract class RealMapBinderProviderWithDependencies<K, V, P>
    extends InternalProviderInstanceBindingImpl.Factory<P> {
        final BindingSelection<K, V> bindingSelection;

        private RealMapBinderProviderWithDependencies(BindingSelection<K, V> bindingSelection) {
            super(InternalProviderInstanceBindingImpl.InitializationTiming.DELAYED);
            this.bindingSelection = bindingSelection;
        }

        @Override
        final void initialize(InjectorImpl injectorImpl, Errors errors) {
            if (((BindingSelection)this.bindingSelection).tryInitialize(injectorImpl, errors)) {
                this.doInitialize(injectorImpl, errors);
            }
        }

        protected abstract void doInitialize(InjectorImpl var1, Errors var2);

        public boolean equals(Object object) {
            return object != null && this.getClass() == object.getClass() && this.bindingSelection.equals(((RealMapBinderProviderWithDependencies)object).bindingSelection);
        }

        public int hashCode() {
            return this.bindingSelection.hashCode();
        }
    }

    static final class ProviderMapEntry<K, V>
    extends InternalProviderInstanceBindingImpl.Factory<Map.Entry<K, Provider<V>>> {
        private final K key;
        private final Key<V> valueKey;
        private Map.Entry<K, Provider<V>> entry;

        ProviderMapEntry(K k, Key<V> key) {
            super(InternalProviderInstanceBindingImpl.InitializationTiming.EAGER);
            this.key = k;
            this.valueKey = key;
        }

        @Override
        public Set<Dependency<?>> getDependencies() {
            return ImmutableSet.of(Dependency.get(RealMapBinder.getKeyOfProvider(this.valueKey)));
        }

        @Override
        void initialize(InjectorImpl injectorImpl, Errors errors) {
            Binding binding = injectorImpl.getExistingBinding((Key)this.valueKey);
            this.entry = Maps.immutableEntry(this.key, binding.getProvider());
        }

        @Override
        protected Map.Entry<K, Provider<V>> doProvision(InternalContext internalContext, Dependency<?> dependency) {
            return this.entry;
        }

        K getKey() {
            return this.key;
        }

        Key<V> getValueKey() {
            return this.valueKey;
        }

        public boolean equals(Object object) {
            if (object instanceof ProviderMapEntry) {
                ProviderMapEntry providerMapEntry = (ProviderMapEntry)object;
                return this.key.equals(providerMapEntry.key) && this.valueKey.equals(providerMapEntry.valueKey);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.key, this.valueKey});
        }

        public String toString() {
            return "ProviderMapEntry(" + this.key + ", " + this.valueKey + ")";
        }
    }

    static final class MultimapBinder<K, V>
    implements Module {
        private final BindingSelection<K, V> bindingSelection;

        private MultimapBinder(BindingSelection<K, V> bindingSelection) {
            this.bindingSelection = bindingSelection;
        }

        @Override
        public void configure(Binder binder) {
            binder.bind(((BindingSelection)this.bindingSelection).getProviderSetMultimapKey()).toProvider(new RealProviderMultimapProvider(((BindingSelection)this.bindingSelection).getMapKey()));
            binder.bind(((BindingSelection)this.bindingSelection).getJakartaProviderSetMultimapKey()).to(((BindingSelection)this.bindingSelection).getProviderSetMultimapKey());
            binder.bind(((BindingSelection)this.bindingSelection).getProviderCollectionMultimapKey()).to(((BindingSelection)this.bindingSelection).getProviderSetMultimapKey());
            binder.bind(((BindingSelection)this.bindingSelection).getJakartaProviderCollectionMultimapKey()).to(((BindingSelection)this.bindingSelection).getProviderSetMultimapKey());
            binder.bind(((BindingSelection)this.bindingSelection).getMultimapKey()).toProvider(new RealMultimapProvider(((BindingSelection)this.bindingSelection).getMapKey()));
        }

        public int hashCode() {
            return this.bindingSelection.hashCode();
        }

        public boolean equals(Object object) {
            return object instanceof MultimapBinder && ((MultimapBinder)object).bindingSelection.equals(this.bindingSelection);
        }

        private static final class RealMultimapProvider<K, V>
        extends RealMultimapBinderProviderWithDependencies<K, V, Map<K, Set<V>>> {
            private Set<Dependency<?>> dependencies = RealMapBinder.access$1200();
            private PerKeyData<K, V>[] perKeyDatas;
            private boolean initialized = false;

            private RealMultimapProvider(Key<Map<K, V>> key) {
                super(key);
            }

            @Override
            public Set<Dependency<?>> getDependencies() {
                return this.dependencies;
            }

            @Override
            protected void doInitialize(InjectorImpl injectorImpl, Errors errors) {
                if (this.initialized) {
                    return;
                }
                this.initialized = true;
                PerKeyData[] perKeyDataArray = new PerKeyData[this.bindingSelection.getMapBindings().size()];
                this.perKeyDatas = perKeyDataArray;
                ImmutableSet.Builder builder = ImmutableSet.builder();
                ArrayList arrayList = Lists.newArrayList();
                int n = 0;
                for (Map.Entry entry : this.bindingSelection.getMultimapBindings().entrySet()) {
                    Binding[] bindingArray;
                    arrayList.clear();
                    Set set = (Set)entry.getValue();
                    Binding[] bindingArray2 = bindingArray = new Binding[set.size()];
                    int n2 = 0;
                    for (Binding binding : set) {
                        Dependency dependency = Dependency.get(binding.getKey());
                        builder.add(dependency);
                        arrayList.add(dependency);
                        bindingArray2[n2] = binding;
                        ++n2;
                    }
                    SingleParameterInjector[] singleParameterInjectorArray = injectorImpl.getParametersInjectors(arrayList, errors);
                    this.perKeyDatas[n] = new PerKeyData(entry.getKey(), bindingArray2, singleParameterInjectorArray);
                    ++n;
                }
                this.dependencies = builder.build();
            }

            @Override
            protected Map<K, Set<V>> doProvision(InternalContext internalContext, Dependency<?> dependency) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (PerKeyData<K, V> perKeyData : this.perKeyDatas) {
                    ImmutableSet.Builder builder2 = ImmutableSet.builder();
                    SingleParameterInjector[] singleParameterInjectorArray = ((PerKeyData)perKeyData).injectors;
                    for (int i = 0; i < singleParameterInjectorArray.length; ++i) {
                        SingleParameterInjector singleParameterInjector = singleParameterInjectorArray[i];
                        Object t = singleParameterInjector.inject(internalContext);
                        if (t == null) {
                            throw RealMapBinder.createNullValueException(((PerKeyData)perKeyData).key, ((PerKeyData)perKeyData).bindings[i]);
                        }
                        builder2.add(t);
                    }
                    builder.put(((PerKeyData)perKeyData).key, (Object)builder2.build());
                }
                return builder.buildOrThrow();
            }

            private static final class PerKeyData<K, V> {
                private final K key;
                private final Binding<V>[] bindings;
                private final SingleParameterInjector<V>[] injectors;

                private PerKeyData(K k, Binding<V>[] bindingArray, SingleParameterInjector<V>[] singleParameterInjectorArray) {
                    Preconditions.checkArgument((bindingArray.length == singleParameterInjectorArray.length ? 1 : 0) != 0);
                    this.key = k;
                    this.bindings = bindingArray;
                    this.injectors = singleParameterInjectorArray;
                }
            }
        }

        private static final class RealProviderMultimapProvider<K, V>
        extends RealMultimapBinderProviderWithDependencies<K, V, Map<K, Set<Provider<V>>>> {
            private Map<K, Set<Provider<V>>> multimapOfProviders;
            private Set<Dependency<?>> dependencies = RealMapBinder.access$1200();
            private boolean initialized;

            private RealProviderMultimapProvider(Key<Map<K, V>> key) {
                super(key);
            }

            @Override
            public Set<Dependency<?>> getDependencies() {
                return this.dependencies;
            }

            @Override
            protected void doInitialize(InjectorImpl injectorImpl, Errors errors) {
                if (this.initialized) {
                    return;
                }
                this.initialized = true;
                ImmutableMap.Builder builder = ImmutableMap.builder();
                ImmutableSet.Builder builder2 = ImmutableSet.builder();
                for (Map.Entry entry : this.bindingSelection.getMultimapBindings().entrySet()) {
                    ImmutableSet.Builder builder3 = ImmutableSet.builder();
                    for (Binding binding : (Set)entry.getValue()) {
                        builder3.add(binding.getProvider());
                        builder2.add(Dependency.get(RealMapBinder.getKeyOfProvider(binding.getKey())));
                    }
                    builder.put(entry.getKey(), (Object)builder3.build());
                }
                this.multimapOfProviders = builder.buildOrThrow();
                this.dependencies = builder2.build();
            }

            @Override
            protected Map<K, Set<Provider<V>>> doProvision(InternalContext internalContext, Dependency<?> dependency) {
                return this.multimapOfProviders;
            }
        }
    }

    private static final class ExtensionRealMapProvider<K, V>
    extends RealMapBinderProviderWithDependencies<K, V, Map<K, V>>
    implements ProviderWithExtensionVisitor<Map<K, V>>,
    MapBinderBinding<Map<K, V>> {
        Set<Dependency<?>> dependencies = RealMapBinder.access$1200();
        SingleParameterInjector<V>[] injectors;
        K[] keys;
        private boolean initialized = false;

        ExtensionRealMapProvider(BindingSelection<K, V> bindingSelection) {
            super(bindingSelection);
        }

        @Override
        protected void doInitialize(InjectorImpl injectorImpl, Errors errors) {
            Map.Entry entry;
            if (this.initialized) {
                return;
            }
            this.initialized = true;
            Object[] objectArray = new Object[this.bindingSelection.getMapBindings().size()];
            this.keys = objectArray;
            ImmutableSet.Builder builder = ImmutableSet.builder();
            int n = 0;
            UnmodifiableIterator unmodifiableIterator = this.bindingSelection.getMapBindings().entrySet().iterator();
            while (unmodifiableIterator.hasNext()) {
                entry = (Map.Entry)unmodifiableIterator.next();
                builder.add(Dependency.get(((Binding)entry.getValue()).getKey()));
                this.keys[n] = entry.getKey();
                ++n;
            }
            this.dependencies = unmodifiableIterator = builder.build();
            entry = unmodifiableIterator.asList();
            SingleParameterInjector<?>[] singleParameterInjectorArray = injectorImpl.getParametersInjectors((List<Dependency<?>>)((Object)entry), errors);
            this.injectors = singleParameterInjectorArray;
        }

        @Override
        protected Map<K, V> doProvision(InternalContext internalContext, Dependency<?> dependency) {
            SingleParameterInjector<V>[] singleParameterInjectorArray = this.injectors;
            if (singleParameterInjectorArray == null) {
                return ImmutableMap.of();
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            K[] KArray = this.keys;
            for (int i = 0; i < singleParameterInjectorArray.length; ++i) {
                SingleParameterInjector<V> singleParameterInjector = singleParameterInjectorArray[i];
                K k = KArray[i];
                V v = singleParameterInjector.inject(internalContext);
                if (v == null) {
                    throw RealMapBinder.createNullValueException(k, (Binding)this.bindingSelection.getMapBindings().get(k));
                }
                builder.put(k, v);
            }
            return builder.buildOrThrow();
        }

        @Override
        public Set<Dependency<?>> getDependencies() {
            return this.dependencies;
        }

        BindingSelection<K, V> getBindingSelection() {
            return this.bindingSelection;
        }

        @Override
        public <B, W> W acceptExtensionVisitor(BindingTargetVisitor<B, W> bindingTargetVisitor, ProviderInstanceBinding<? extends B> providerInstanceBinding) {
            if (bindingTargetVisitor instanceof MultibindingsTargetVisitor) {
                return (W)((MultibindingsTargetVisitor)bindingTargetVisitor).visit(this);
            }
            return bindingTargetVisitor.visit(providerInstanceBinding);
        }

        @Override
        public Key<Map<K, V>> getMapKey() {
            return this.bindingSelection.getMapKey();
        }

        @Override
        public Set<Key<?>> getAlternateMapKeys() {
            return ImmutableSet.of((Object)this.bindingSelection.getJakartaProviderMapKey(), (Object)this.bindingSelection.getProviderMapKey(), (Object)this.bindingSelection.getProviderSetMultimapKey(), (Object)this.bindingSelection.getJakartaProviderSetMultimapKey(), (Object)this.bindingSelection.getProviderCollectionMultimapKey(), (Object)this.bindingSelection.getJakartaProviderCollectionMultimapKey(), (Object[])new Key[]{this.bindingSelection.getMultimapKey(), this.bindingSelection.getMapOfKeyExtendsValueKey()});
        }

        @Override
        public TypeLiteral<K> getKeyTypeLiteral() {
            return this.bindingSelection.getKeyType();
        }

        @Override
        public TypeLiteral<V> getValueTypeLiteral() {
            return this.bindingSelection.getValueType();
        }

        @Override
        public List<Map.Entry<?, Binding<?>>> getEntries() {
            if (this.bindingSelection.isInitialized()) {
                return this.bindingSelection.getEntries();
            }
            throw new UnsupportedOperationException("getEntries() not supported for module bindings");
        }

        @Override
        public List<Map.Entry<?, Binding<?>>> getEntries(Iterable<? extends Element> iterable) {
            ImmutableList.Builder builder;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            ImmutableMultimap.Builder builder2 = ImmutableMultimap.builder();
            ImmutableMap.Builder builder3 = ImmutableMap.builder();
            ImmutableMap.Builder builder4 = ImmutableMap.builder();
            ImmutableMap.Builder builder5 = ImmutableMap.builder();
            for (Element element2 : iterable) {
                if (element2 instanceof Binding && this.bindingSelection.matchesValueKey((object4 = (Binding)element2).getKey()) && object4.getKey().getTypeLiteral().equals(this.bindingSelection.valueType)) {
                    object3 = object4;
                    object2 = object3.getKey();
                    builder3.put(object2, object3);
                }
                if (!(element2 instanceof ProviderInstanceBinding) || !this.bindingSelection.getEntrySetBinder().containsElement(element2) || !((object2 = (object3 = (Provider)(object4 = (ProviderInstanceBinding)element2).getUserSuppliedProvider())) instanceof ProviderMapEntry)) continue;
                object = (ProviderMapEntry)object2;
                builder = object;
                builder2.put(builder.getKey(), builder.getValueKey());
                builder5.put(builder.getValueKey(), object4);
                builder4.put(builder.getValueKey(), builder.getKey());
            }
            ImmutableMultimap immutableMultimap = builder2.build();
            ImmutableMap immutableMap = builder4.buildOrThrow();
            object4 = builder3.buildOrThrow();
            object3 = builder5.buildOrThrow();
            object2 = Sets.newHashSet((Iterable)immutableMultimap.values());
            if (!object2.equals(object = object4.keySet())) {
                builder = Sets.difference((Set)object2, (Set)object);
                Sets.SetView setView = Sets.difference((Set)object, (Set)object2);
                StringBuilder entry = new StringBuilder("Expected a 1:1 mapping from map keys to values.");
                if (!setView.isEmpty()) {
                    entry.append(Errors.format("\nFound these Bindings that were missing an associated entry:\n", new Object[0]));
                    for (Key entry2 : setView) {
                        entry.append(Errors.format("  %s bound at: %s\n", entry2, ((Binding)object4.get((Object)entry2)).getSource()));
                    }
                }
                if (!builder.isEmpty()) {
                    entry.append(Errors.format("\nFound these map keys without a corresponding value:\n", new Object[0]));
                    for (Key entry2 : builder) {
                        entry.append(Errors.format("  '%s' bound at: %s\n", immutableMap.get((Object)entry2), ((Binding)object3.get((Object)entry2)).getSource()));
                    }
                }
                throw new IllegalArgumentException(entry.toString());
            }
            builder = ImmutableList.builder();
            for (Map.Entry entry : immutableMultimap.entries()) {
                Binding binding = (Binding)object4.get(entry.getValue());
                Map.Entry entry2 = Maps.immutableEntry(entry.getKey(), (Object)binding);
                builder.add((Object)entry2);
            }
            return builder.build();
        }

        @Override
        public boolean permitsDuplicates() {
            if (this.bindingSelection.isInitialized()) {
                return this.bindingSelection.permitsDuplicates();
            }
            throw new UnsupportedOperationException("permitsDuplicates() not supported for module bindings");
        }

        @Override
        public boolean containsElement(Element element) {
            return this.bindingSelection.containsElement(element);
        }
    }

    private static final class RealProviderMapProvider<K, V>
    extends RealMapBinderProviderWithDependencies<K, V, Map<K, Provider<V>>> {
        private Map<K, Provider<V>> mapOfProviders;
        private Set<Dependency<?>> dependencies = RealMapBinder.access$1200();
        private boolean initialized;

        private RealProviderMapProvider(BindingSelection<K, V> bindingSelection) {
            super(bindingSelection);
        }

        @Override
        public Set<Dependency<?>> getDependencies() {
            return this.dependencies;
        }

        @Override
        protected void doInitialize(InjectorImpl injectorImpl, Errors errors) {
            if (this.initialized) {
                return;
            }
            this.initialized = true;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            ImmutableSet.Builder builder2 = ImmutableSet.builder();
            for (Map.Entry entry : this.bindingSelection.getMapBindings().entrySet()) {
                builder.put(entry.getKey(), ((Binding)entry.getValue()).getProvider());
                builder2.add(Dependency.get(RealMapBinder.getKeyOfProvider(((Binding)entry.getValue()).getKey())));
            }
            this.mapOfProviders = builder.buildOrThrow();
            this.dependencies = builder2.build();
        }

        @Override
        protected Map<K, Provider<V>> doProvision(InternalContext internalContext, Dependency<?> dependency) {
            return this.mapOfProviders;
        }
    }

    private static final class BindingSelection<K, V> {
        private final TypeLiteral<K> keyType;
        private final TypeLiteral<V> valueType;
        private final Key<Map<K, V>> mapKey;
        private Key<Map<K, Provider<V>>> providerMapKey;
        private Key<Map<K, Set<V>>> multimapKey;
        private Key<Map<K, Set<Provider<V>>>> providerSetMultimapKey;
        private Key<Map<K, Collection<Provider<V>>>> providerCollectionMultimapKey;
        private Key<Map<K, ? extends V>> mapOfKeyExtendsValueKey;
        private Key<Map<K, jakarta.inject.Provider<V>>> jakartaProviderMapKey;
        private Key<Map<K, Set<jakarta.inject.Provider<V>>>> jakartaProviderSetMultimapKey;
        private Key<Map<K, Collection<jakarta.inject.Provider<V>>>> jakartaProviderCollectionMultimapKey;
        private Key<Set<Map.Entry<K, jakarta.inject.Provider<V>>>> entrySetJakartaProviderKey;
        private final RealMultibinder<Map.Entry<K, Provider<V>>> entrySetBinder;
        private InitializationState initializationState;
        private ImmutableMap<K, Binding<V>> mapBindings;
        private ImmutableMap<K, Set<Binding<V>>> multimapBindings;
        private ImmutableList<Map.Entry<K, Binding<V>>> entries;
        private boolean permitsDuplicates;

        private BindingSelection(TypeLiteral<K> typeLiteral, TypeLiteral<V> typeLiteral2, Key<Map<K, V>> key, RealMultibinder<Map.Entry<K, Provider<V>>> realMultibinder) {
            this.keyType = typeLiteral;
            this.valueType = typeLiteral2;
            this.mapKey = key;
            this.entrySetBinder = realMultibinder;
            this.initializationState = InitializationState.UNINITIALIZED;
        }

        private boolean tryInitialize(InjectorImpl injectorImpl, Errors errors) {
            if (this.initializationState != InitializationState.UNINITIALIZED) {
                return this.initializationState != InitializationState.HAS_ERRORS;
            }
            this.permitsDuplicates = this.entrySetBinder.permitsDuplicates(injectorImpl);
            LinkedHashMap<Object, ImmutableSet.Builder> linkedHashMap = new LinkedHashMap<Object, ImmutableSet.Builder>();
            LinkedHashMap linkedHashMap2 = new LinkedHashMap();
            HashMultimap hashMultimap = HashMultimap.create();
            Indexer indexer = new Indexer(injectorImpl);
            LinkedHashMultimap linkedHashMultimap = null;
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Binding<Map.Entry<K, Provider<V>>> binding : injectorImpl.findBindingsByType(this.entrySetBinder.getElementTypeLiteral())) {
                Key key;
                Binding binding2;
                ProviderInstanceBinding object2;
                ProviderMapEntry providerMapEntry;
                Object k;
                if (!this.entrySetBinder.containsElement(binding) || !hashMultimap.put(k = (providerMapEntry = (ProviderMapEntry)(object2 = (ProviderInstanceBinding)binding).getUserSuppliedProvider()).getKey(), (Object)(binding2 = injectorImpl.getExistingBinding(key = providerMapEntry.getValueKey())).acceptTargetVisitor(indexer))) continue;
                builder.add((Object)Maps.immutableEntry(k, (Object)binding2));
                Binding binding3 = linkedHashMap2.put(k, binding2);
                if (binding3 != null && !this.permitsDuplicates) {
                    if (linkedHashMultimap == null) {
                        linkedHashMultimap = LinkedHashMultimap.create();
                    }
                    linkedHashMultimap.put(k, (Object)binding3);
                    linkedHashMultimap.put(k, (Object)binding2);
                }
                if (!this.permitsDuplicates) continue;
                linkedHashMap.computeIfAbsent(k, object -> ImmutableSet.builder()).add((Object)binding2);
            }
            if (linkedHashMultimap != null) {
                this.initializationState = InitializationState.HAS_ERRORS;
                BindingSelection.reportDuplicateKeysError(this.mapKey, linkedHashMultimap, errors);
                return false;
            }
            ImmutableMap.Builder builder2 = ImmutableMap.builder();
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                builder2.put(entry.getKey(), (Object)((ImmutableSet.Builder)entry.getValue()).build());
            }
            this.mapBindings = ImmutableMap.copyOf(linkedHashMap2);
            this.multimapBindings = builder2.buildOrThrow();
            this.entries = builder.build();
            this.initializationState = InitializationState.INITIALIZED;
            return true;
        }

        private static <K, V> void reportDuplicateKeysError(Key<Map<K, V>> key, Multimap<K, Binding<V>> multimap, Errors errors) {
            errors.duplicateMapKey(key, multimap);
        }

        private boolean containsElement(Element element) {
            if (this.entrySetBinder.containsElement(element)) {
                return true;
            }
            if (!(element instanceof Binding)) {
                return false;
            }
            Key key = ((Binding)element).getKey();
            return key.equals(this.getMapKey()) || key.equals(this.getProviderMapKey()) || key.equals(this.getJakartaProviderMapKey()) || key.equals(this.getMultimapKey()) || key.equals(this.getProviderSetMultimapKey()) || key.equals(this.getJakartaProviderSetMultimapKey()) || key.equals(this.getProviderCollectionMultimapKey()) || key.equals(this.getJakartaProviderCollectionMultimapKey()) || key.equals(this.entrySetBinder.getSetKey()) || key.equals(this.getEntrySetJakartaProviderKey()) || key.equals(this.getMapOfKeyExtendsValueKey()) || this.matchesValueKey(key);
        }

        private boolean matchesValueKey(Key<?> key) {
            return key.getAnnotation() instanceof RealElement && ((RealElement)key.getAnnotation()).setName().equals(this.entrySetBinder.getSetName()) && ((RealElement)key.getAnnotation()).type() == Element.Type.MAPBINDER && ((RealElement)key.getAnnotation()).keyType().equals(this.keyType.toString()) && key.getTypeLiteral().equals(this.valueType);
        }

        private Key<Map<K, Provider<V>>> getProviderMapKey() {
            Key<Map<K, Provider<V>>> key = this.providerMapKey;
            if (key == null) {
                key = this.providerMapKey = this.mapKey.ofType(RealMapBinder.mapOfProviderOf(this.keyType, this.valueType));
            }
            return key;
        }

        private Key<Map<K, jakarta.inject.Provider<V>>> getJakartaProviderMapKey() {
            Key<Map<K, jakarta.inject.Provider<V>>> key = this.jakartaProviderMapKey;
            if (key == null) {
                key = this.jakartaProviderMapKey = this.mapKey.ofType(RealMapBinder.mapOfJakartaProviderOf(this.keyType, this.valueType));
            }
            return key;
        }

        private Key<Map<K, Set<V>>> getMultimapKey() {
            Key<Map<K, Set<V>>> key = this.multimapKey;
            if (key == null) {
                key = this.multimapKey = this.mapKey.ofType(RealMapBinder.mapOf(this.keyType, RealMultibinder.setOf(this.valueType)));
            }
            return key;
        }

        private Key<Map<K, Set<Provider<V>>>> getProviderSetMultimapKey() {
            Key<Map<K, Set<Provider<V>>>> key = this.providerSetMultimapKey;
            if (key == null) {
                key = this.providerSetMultimapKey = this.mapKey.ofType(RealMapBinder.mapOfSetOfProviderOf(this.keyType, this.valueType));
            }
            return key;
        }

        private Key<Map<K, Set<jakarta.inject.Provider<V>>>> getJakartaProviderSetMultimapKey() {
            Key<Map<K, Set<jakarta.inject.Provider<V>>>> key = this.jakartaProviderSetMultimapKey;
            if (key == null) {
                key = this.jakartaProviderSetMultimapKey = this.mapKey.ofType(RealMapBinder.mapOfSetOfJakartaProviderOf(this.keyType, this.valueType));
            }
            return key;
        }

        private Key<Map<K, Collection<Provider<V>>>> getProviderCollectionMultimapKey() {
            Key<Map<K, Collection<Provider<V>>>> key = this.providerCollectionMultimapKey;
            if (key == null) {
                key = this.providerCollectionMultimapKey = this.mapKey.ofType(RealMapBinder.mapOfCollectionOfProviderOf(this.keyType, this.valueType));
            }
            return key;
        }

        private Key<Map<K, Collection<jakarta.inject.Provider<V>>>> getJakartaProviderCollectionMultimapKey() {
            Key<Map<K, Collection<jakarta.inject.Provider<V>>>> key = this.jakartaProviderCollectionMultimapKey;
            if (key == null) {
                key = this.jakartaProviderCollectionMultimapKey = this.mapKey.ofType(RealMapBinder.mapOfCollectionOfJakartaProviderOf(this.keyType, this.valueType));
            }
            return key;
        }

        private Key<Set<Map.Entry<K, jakarta.inject.Provider<V>>>> getEntrySetJakartaProviderKey() {
            Key<Set<Map.Entry<K, jakarta.inject.Provider<V>>>> key = this.entrySetJakartaProviderKey;
            if (key == null) {
                key = this.entrySetJakartaProviderKey = this.mapKey.ofType(RealMapBinder.setOfEntryOfJakartaProviderOf(this.keyType, this.valueType));
            }
            return key;
        }

        private Key<Map<K, ? extends V>> getMapOfKeyExtendsValueKey() {
            Key<Map<K, Object>> key = this.mapOfKeyExtendsValueKey;
            if (key == null) {
                WildcardType wildcardType = Types.subtypeOf(this.valueType.getType());
                ParameterizedType parameterizedType = Types.mapOf(this.keyType.getType(), wildcardType);
                key = this.mapOfKeyExtendsValueKey = this.mapKey.ofType(parameterizedType);
            }
            return key;
        }

        private ImmutableMap<K, Binding<V>> getMapBindings() {
            Errors.checkConfiguration(this.isInitialized(), "MapBinder has not yet been initialized", new Object[0]);
            return this.mapBindings;
        }

        private ImmutableMap<K, Set<Binding<V>>> getMultimapBindings() {
            Errors.checkConfiguration(this.isInitialized(), "MapBinder has not yet been initialized", new Object[0]);
            return this.multimapBindings;
        }

        private ImmutableList<Map.Entry<K, Binding<V>>> getEntries() {
            Errors.checkConfiguration(this.isInitialized(), "MapBinder has not yet been initialized", new Object[0]);
            return this.entries;
        }

        private boolean isInitialized() {
            return this.initializationState == InitializationState.INITIALIZED;
        }

        private TypeLiteral<K> getKeyType() {
            return this.keyType;
        }

        private TypeLiteral<V> getValueType() {
            return this.valueType;
        }

        private Key<Map<K, V>> getMapKey() {
            return this.mapKey;
        }

        private RealMultibinder<Map.Entry<K, Provider<V>>> getEntrySetBinder() {
            return this.entrySetBinder;
        }

        private boolean permitsDuplicates() {
            if (this.isInitialized()) {
                return this.permitsDuplicates;
            }
            throw new UnsupportedOperationException("permitsDuplicates() not supported for module bindings");
        }

        public boolean equals(Object object) {
            return object instanceof BindingSelection && ((BindingSelection)object).mapKey.equals(this.mapKey);
        }

        public int hashCode() {
            return this.mapKey.hashCode();
        }

        private static enum InitializationState {
            UNINITIALIZED,
            INITIALIZED,
            HAS_ERRORS;

        }
    }
}

