/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.plotsquared.google.AbstractModule;
import com.plotsquared.google.Binder;
import com.plotsquared.google.Binding;
import com.plotsquared.google.Injector;
import com.plotsquared.google.Key;
import com.plotsquared.google.Module;
import com.plotsquared.google.Provider;
import com.plotsquared.google.TypeLiteral;
import com.plotsquared.google.binder.LinkedBindingBuilder;
import com.plotsquared.google.internal.Annotations;
import com.plotsquared.google.internal.DuplicateElementError;
import com.plotsquared.google.internal.Element;
import com.plotsquared.google.internal.ErrorId;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.GuiceInternal;
import com.plotsquared.google.internal.Indexer;
import com.plotsquared.google.internal.InjectorImpl;
import com.plotsquared.google.internal.InternalContext;
import com.plotsquared.google.internal.InternalProviderInstanceBindingImpl;
import com.plotsquared.google.internal.InternalProvisionException;
import com.plotsquared.google.internal.RealElement;
import com.plotsquared.google.internal.SingleParameterInjector;
import com.plotsquared.google.multibindings.MultibinderBinding;
import com.plotsquared.google.multibindings.MultibindingsTargetVisitor;
import com.plotsquared.google.name.Names;
import com.plotsquared.google.spi.BindingTargetVisitor;
import com.plotsquared.google.spi.Dependency;
import com.plotsquared.google.spi.Message;
import com.plotsquared.google.spi.ProviderInstanceBinding;
import com.plotsquared.google.spi.ProviderWithExtensionVisitor;
import com.plotsquared.google.util.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

public final class RealMultibinder<T>
implements Module {
    private final BindingSelection<T> bindingSelection;
    private final Binder binder;

    public static <T> RealMultibinder<T> newRealSetBinder(Binder binder, Key<T> key) {
        RealMultibinder<T> realMultibinder = new RealMultibinder<T>(binder, key);
        binder.install(realMultibinder);
        return realMultibinder;
    }

    static <T> TypeLiteral<Set<T>> setOf(TypeLiteral<T> typeLiteral) {
        ParameterizedType parameterizedType = Types.setOf(typeLiteral.getType());
        return TypeLiteral.get(parameterizedType);
    }

    static <T> TypeLiteral<Collection<Provider<T>>> collectionOfProvidersOf(TypeLiteral<T> typeLiteral) {
        ParameterizedType parameterizedType = Types.providerOf(typeLiteral.getType());
        ParameterizedType parameterizedType2 = Types.collectionOf(parameterizedType);
        return TypeLiteral.get(parameterizedType2);
    }

    static <T> TypeLiteral<Collection<jakarta.inject.Provider<T>>> collectionOfJakartaProvidersOf(TypeLiteral<T> typeLiteral) {
        ParameterizedType parameterizedType = Types.newParameterizedType(jakarta.inject.Provider.class, new Type[]{typeLiteral.getType()});
        ParameterizedType parameterizedType2 = Types.collectionOf(parameterizedType);
        return TypeLiteral.get(parameterizedType2);
    }

    static <T> TypeLiteral<Set<? extends T>> setOfExtendsOf(TypeLiteral<T> typeLiteral) {
        WildcardType wildcardType = Types.subtypeOf(typeLiteral.getType());
        ParameterizedType parameterizedType = Types.setOf(wildcardType);
        return TypeLiteral.get(parameterizedType);
    }

    RealMultibinder(Binder binder, Key<T> key) {
        this.binder = Errors.checkNotNull(binder, "binder");
        this.bindingSelection = new BindingSelection<T>(key);
    }

    @Override
    public void configure(Binder binder) {
        Errors.checkConfiguration(!this.bindingSelection.isInitialized(), "Multibinder was already initialized", new Object[0]);
        binder.bind(this.bindingSelection.getSetKey()).toProvider(new RealMultibinderProvider<T>(this.bindingSelection));
        binder.bind(this.bindingSelection.getSetOfExtendsKey()).to(this.bindingSelection.getSetKey());
        binder.bind(this.bindingSelection.getCollectionOfProvidersKey()).toProvider(new RealMultibinderCollectionOfProvidersProvider<T>(this.bindingSelection));
        binder.bind(this.bindingSelection.getCollectionOfJakartaProvidersKey()).to(this.bindingSelection.getCollectionOfProvidersKey());
    }

    public void permitDuplicates() {
        this.binder.install(new PermitDuplicatesModule(this.bindingSelection.getPermitDuplicatesKey()));
    }

    Key<T> getKeyForNewItem() {
        Errors.checkConfiguration(!this.bindingSelection.isInitialized(), "Multibinder was already initialized", new Object[0]);
        return Key.get(this.bindingSelection.getElementTypeLiteral(), (Annotation)new RealElement(this.bindingSelection.getSetName(), Element.Type.MULTIBINDER, ""));
    }

    public LinkedBindingBuilder<T> addBinding() {
        return this.binder.bind(this.getKeyForNewItem());
    }

    Key<Set<T>> getSetKey() {
        return this.bindingSelection.getSetKey();
    }

    TypeLiteral<T> getElementTypeLiteral() {
        return this.bindingSelection.getElementTypeLiteral();
    }

    String getSetName() {
        return this.bindingSelection.getSetName();
    }

    boolean permitsDuplicates(Injector injector) {
        return this.bindingSelection.permitsDuplicates(injector);
    }

    boolean containsElement(com.plotsquared.google.spi.Element element) {
        return this.bindingSelection.containsElement(element);
    }

    public boolean equals(Object object) {
        return object instanceof RealMultibinder && ((RealMultibinder)object).bindingSelection.equals(this.bindingSelection);
    }

    public int hashCode() {
        return this.bindingSelection.hashCode();
    }

    private static class PermitDuplicatesModule
    extends AbstractModule {
        private final Key<Boolean> key;

        PermitDuplicatesModule(Key<Boolean> key) {
            this.key = key;
        }

        @Override
        protected void configure() {
            this.bind(this.key).toInstance(true);
        }

        public boolean equals(Object object) {
            return object instanceof PermitDuplicatesModule && ((PermitDuplicatesModule)object).key.equals(this.key);
        }

        public int hashCode() {
            return this.getClass().hashCode() ^ this.key.hashCode();
        }
    }

    private static final class BindingSelection<T> {
        private static final ImmutableSet<Dependency<?>> MODULE_DEPENDENCIES = ImmutableSet.of(Dependency.get(Key.get(Injector.class)));
        private final TypeLiteral<T> elementType;
        private final Key<Set<T>> setKey;
        private String setName;
        private Key<Collection<Provider<T>>> collectionOfProvidersKey;
        private Key<Collection<jakarta.inject.Provider<T>>> collectionOfJakartaProvidersKey;
        private Key<Set<? extends T>> setOfExtendsKey;
        private Key<Boolean> permitDuplicatesKey;
        private boolean isInitialized;
        private ImmutableList<Binding<T>> bindings;
        private ImmutableSet<Dependency<?>> dependencies = MODULE_DEPENDENCIES;
        private ImmutableSet<Dependency<?>> providerDependencies = MODULE_DEPENDENCIES;
        private boolean permitDuplicates;
        private SingleParameterInjector<T>[] parameterinjectors;

        BindingSelection(Key<T> key) {
            this.setKey = key.ofType(RealMultibinder.setOf(key.getTypeLiteral()));
            this.elementType = key.getTypeLiteral();
        }

        void initialize(InjectorImpl injectorImpl, Errors errors) {
            if (this.isInitialized) {
                return;
            }
            ArrayList arrayList = Lists.newArrayList();
            HashSet hashSet = Sets.newHashSet();
            Indexer indexer = new Indexer(injectorImpl);
            ArrayList arrayList2 = Lists.newArrayList();
            ArrayList arrayList3 = Lists.newArrayList();
            for (Binding<Object> binding : injectorImpl.findBindingsByType(this.elementType)) {
                Binding<Object> binding2;
                if (!this.keyMatches(binding.getKey()) || !hashSet.add((binding2 = binding).acceptTargetVisitor(indexer))) continue;
                arrayList.add(binding2);
                Key<T> key = binding2.getKey();
                arrayList2.add(Dependency.get(key));
                arrayList3.add(Dependency.get(key.ofType(Types.providerOf(key.getTypeLiteral().getType()))));
            }
            this.bindings = ImmutableList.copyOf((Collection)arrayList);
            this.dependencies = ImmutableSet.copyOf((Collection)arrayList2);
            this.providerDependencies = ImmutableSet.copyOf((Collection)arrayList3);
            this.permitDuplicates = this.permitsDuplicates(injectorImpl);
            SingleParameterInjector<?>[] singleParameterInjectorArray = injectorImpl.getParametersInjectors(arrayList2, errors);
            this.parameterinjectors = singleParameterInjectorArray;
            this.isInitialized = true;
        }

        boolean permitsDuplicates(Injector injector) {
            return injector.getBindings().containsKey(this.getPermitDuplicatesKey());
        }

        ImmutableList<Binding<T>> getBindings() {
            Errors.checkConfiguration(this.isInitialized, "not initialized", new Object[0]);
            return this.bindings;
        }

        SingleParameterInjector<T>[] getParameterInjectors() {
            Errors.checkConfiguration(this.isInitialized, "not initialized", new Object[0]);
            return this.parameterinjectors;
        }

        ImmutableSet<Dependency<?>> getDependencies() {
            return this.dependencies;
        }

        ImmutableSet<Dependency<?>> getProviderDependencies() {
            return this.providerDependencies;
        }

        String getSetName() {
            if (this.setName == null) {
                this.setName = Annotations.nameOf(this.setKey);
            }
            return this.setName;
        }

        Key<Boolean> getPermitDuplicatesKey() {
            Key<Boolean> key = this.permitDuplicatesKey;
            if (key == null) {
                key = this.permitDuplicatesKey = Key.get(Boolean.class, (Annotation)Names.named(this.toString() + " permits duplicates"));
            }
            return key;
        }

        Key<Collection<Provider<T>>> getCollectionOfProvidersKey() {
            Key<Collection<Provider<Object>>> key = this.collectionOfProvidersKey;
            if (key == null) {
                key = this.collectionOfProvidersKey = this.setKey.ofType(RealMultibinder.collectionOfProvidersOf(this.elementType));
            }
            return key;
        }

        Key<Collection<jakarta.inject.Provider<T>>> getCollectionOfJakartaProvidersKey() {
            Key<Collection<jakarta.inject.Provider<Object>>> key = this.collectionOfJakartaProvidersKey;
            if (key == null) {
                key = this.collectionOfJakartaProvidersKey = this.setKey.ofType(RealMultibinder.collectionOfJakartaProvidersOf(this.elementType));
            }
            return key;
        }

        Key<Set<? extends T>> getSetOfExtendsKey() {
            Key<Set<Object>> key = this.setOfExtendsKey;
            if (key == null) {
                key = this.setOfExtendsKey = this.setKey.ofType(RealMultibinder.setOfExtendsOf(this.elementType));
            }
            return key;
        }

        boolean isInitialized() {
            return this.isInitialized;
        }

        TypeLiteral<T> getElementTypeLiteral() {
            return this.elementType;
        }

        Key<Set<T>> getSetKey() {
            return this.setKey;
        }

        List<Binding<?>> getElements() {
            if (this.isInitialized()) {
                return this.bindings;
            }
            throw new UnsupportedOperationException("getElements() not supported for module bindings");
        }

        boolean permitsDuplicates() {
            if (this.isInitialized()) {
                return this.permitDuplicates;
            }
            throw new UnsupportedOperationException("permitsDuplicates() not supported for module bindings");
        }

        boolean containsElement(com.plotsquared.google.spi.Element element) {
            if (element instanceof Binding) {
                Binding binding = (Binding)element;
                return this.keyMatches(binding.getKey()) || binding.getKey().equals(this.getPermitDuplicatesKey()) || binding.getKey().equals(this.setKey) || binding.getKey().equals(this.collectionOfProvidersKey) || binding.getKey().equals(this.collectionOfJakartaProvidersKey) || binding.getKey().equals(this.setOfExtendsKey);
            }
            return false;
        }

        private boolean keyMatches(Key<?> key) {
            return key.getTypeLiteral().equals(this.elementType) && key.getAnnotation() instanceof Element && ((Element)key.getAnnotation()).setName().equals(this.getSetName()) && ((Element)key.getAnnotation()).type() == Element.Type.MULTIBINDER;
        }

        public boolean equals(Object object) {
            if (object instanceof BindingSelection) {
                return this.setKey.equals(((BindingSelection)object).setKey);
            }
            return false;
        }

        public int hashCode() {
            return this.setKey.hashCode();
        }

        public String toString() {
            return (this.getSetName().isEmpty() ? "" : this.getSetName() + " ") + "Multibinder<" + this.elementType + ">";
        }
    }

    private static final class RealMultibinderCollectionOfProvidersProvider<T>
    extends BaseFactory<T, Collection<Provider<T>>> {
        ImmutableList<Provider<T>> providers;

        RealMultibinderCollectionOfProvidersProvider(BindingSelection<T> bindingSelection2) {
            super(bindingSelection2, bindingSelection -> bindingSelection.getProviderDependencies());
        }

        @Override
        protected void doInitialize() {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Binding binding : this.bindingSelection.getBindings()) {
                builder.add(binding.getProvider());
            }
            this.providers = builder.build();
        }

        @Override
        protected ImmutableList<Provider<T>> doProvision(InternalContext internalContext, Dependency<?> dependency) {
            return this.providers;
        }
    }

    private static final class RealMultibinderProvider<T>
    extends BaseFactory<T, Set<T>>
    implements ProviderWithExtensionVisitor<Set<T>>,
    MultibinderBinding<Set<T>> {
        List<Binding<T>> bindings;
        SingleParameterInjector<T>[] injectors;
        boolean permitDuplicates;

        RealMultibinderProvider(BindingSelection<T> bindingSelection2) {
            super(bindingSelection2, bindingSelection -> bindingSelection.getDependencies());
        }

        @Override
        protected void doInitialize() {
            this.bindings = this.bindingSelection.getBindings();
            this.injectors = this.bindingSelection.getParameterInjectors();
            this.permitDuplicates = this.bindingSelection.permitsDuplicates();
        }

        @Override
        protected ImmutableSet<T> doProvision(InternalContext internalContext, Dependency<?> dependency) {
            SingleParameterInjector<T>[] singleParameterInjectorArray = this.injectors;
            if (singleParameterInjectorArray == null) {
                return ImmutableSet.of();
            }
            Object[] objectArray = new Object[singleParameterInjectorArray.length];
            for (int i = 0; i < singleParameterInjectorArray.length; ++i) {
                SingleParameterInjector<T> singleParameterInjector = singleParameterInjectorArray[i];
                T t = singleParameterInjector.inject(internalContext);
                if (t == null) {
                    throw this.newNullEntryException(i);
                }
                objectArray[i] = t;
            }
            ImmutableSet immutableSet = ImmutableSet.copyOf((Object[])objectArray);
            if (!this.permitDuplicates && immutableSet.size() < objectArray.length) {
                throw this.newDuplicateValuesException(objectArray);
            }
            return immutableSet;
        }

        private InternalProvisionException newNullEntryException(int n) {
            return InternalProvisionException.create(ErrorId.NULL_ELEMENT_IN_SET, "Set injection failed due to null element bound at: %s", this.bindings.get(n).getSource());
        }

        private InternalProvisionException newDuplicateValuesException(T[] TArray) {
            Message message = new Message(GuiceInternal.GUICE_INTERNAL, ErrorId.DUPLICATE_ELEMENT, new DuplicateElementError(this.bindingSelection.getSetKey(), this.bindings, TArray, (List<Object>)ImmutableList.of((Object)this.getSource())));
            return new InternalProvisionException(message);
        }

        @Override
        public <B, V> V acceptExtensionVisitor(BindingTargetVisitor<B, V> bindingTargetVisitor, ProviderInstanceBinding<? extends B> providerInstanceBinding) {
            if (bindingTargetVisitor instanceof MultibindingsTargetVisitor) {
                return ((MultibindingsTargetVisitor)bindingTargetVisitor).visit(this);
            }
            return bindingTargetVisitor.visit(providerInstanceBinding);
        }

        @Override
        public Key<Set<T>> getSetKey() {
            return this.bindingSelection.getSetKey();
        }

        @Override
        public ImmutableSet<Key<?>> getAlternateSetKeys() {
            return ImmutableSet.of(this.bindingSelection.getCollectionOfProvidersKey(), this.bindingSelection.getCollectionOfJakartaProvidersKey(), this.bindingSelection.getSetOfExtendsKey());
        }

        @Override
        public TypeLiteral<?> getElementTypeLiteral() {
            return this.bindingSelection.getElementTypeLiteral();
        }

        @Override
        public List<Binding<?>> getElements() {
            return this.bindingSelection.getElements();
        }

        @Override
        public boolean permitsDuplicates() {
            return this.bindingSelection.permitsDuplicates();
        }

        @Override
        public boolean containsElement(com.plotsquared.google.spi.Element element) {
            return this.bindingSelection.containsElement(element);
        }
    }

    private static abstract class BaseFactory<ValueT, ProvidedT>
    extends InternalProviderInstanceBindingImpl.Factory<ProvidedT> {
        final Function<BindingSelection<ValueT>, ImmutableSet<Dependency<?>>> dependenciesFn;
        final BindingSelection<ValueT> bindingSelection;

        BaseFactory(BindingSelection<ValueT> bindingSelection, Function<BindingSelection<ValueT>, ImmutableSet<Dependency<?>>> function) {
            super(InternalProviderInstanceBindingImpl.InitializationTiming.DELAYED);
            this.bindingSelection = bindingSelection;
            this.dependenciesFn = function;
        }

        @Override
        void initialize(InjectorImpl injectorImpl, Errors errors) {
            this.bindingSelection.initialize(injectorImpl, errors);
            this.doInitialize();
        }

        abstract void doInitialize();

        @Override
        public Set<Dependency<?>> getDependencies() {
            return (Set)this.dependenciesFn.apply(this.bindingSelection);
        }

        public boolean equals(Object object) {
            return this.getClass().isInstance(object) && this.bindingSelection.equals(((BaseFactory)object).bindingSelection);
        }

        public int hashCode() {
            return this.bindingSelection.hashCode();
        }
    }
}

