/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.plotsquared.google.Binder;
import com.plotsquared.google.Binding;
import com.plotsquared.google.Injector;
import com.plotsquared.google.Key;
import com.plotsquared.google.Module;
import com.plotsquared.google.Provider;
import com.plotsquared.google.TypeLiteral;
import com.plotsquared.google.binder.LinkedBindingBuilder;
import com.plotsquared.google.internal.Annotations;
import com.plotsquared.google.internal.BindingImpl;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.InjectorImpl;
import com.plotsquared.google.internal.InternalContext;
import com.plotsquared.google.internal.InternalFactory;
import com.plotsquared.google.internal.InternalProviderInstanceBindingImpl;
import com.plotsquared.google.internal.InternalProvisionException;
import com.plotsquared.google.internal.LinkedBindingImpl;
import com.plotsquared.google.multibindings.MultibindingsTargetVisitor;
import com.plotsquared.google.multibindings.OptionalBinderBinding;
import com.plotsquared.google.spi.BindingTargetVisitor;
import com.plotsquared.google.spi.Dependency;
import com.plotsquared.google.spi.Element;
import com.plotsquared.google.spi.ProviderInstanceBinding;
import com.plotsquared.google.spi.ProviderWithExtensionVisitor;
import com.plotsquared.google.util.Types;
import jakarta.inject.Qualifier;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.Set;

public final class RealOptionalBinder<T>
implements Module {
    private final BindingSelection<T> bindingSelection;
    private final Binder binder;

    public static <T> RealOptionalBinder<T> newRealOptionalBinder(Binder binder, Key<T> key) {
        binder = binder.skipSources(RealOptionalBinder.class);
        RealOptionalBinder<T> realOptionalBinder = new RealOptionalBinder<T>(binder, key);
        binder.install(realOptionalBinder);
        return realOptionalBinder;
    }

    static <T> TypeLiteral<com.google.common.base.Optional<T>> optionalOf(TypeLiteral<T> typeLiteral) {
        return TypeLiteral.get(Types.newParameterizedType(com.google.common.base.Optional.class, new Type[]{typeLiteral.getType()}));
    }

    static <T> TypeLiteral<Optional<T>> javaOptionalOf(TypeLiteral<T> typeLiteral) {
        return TypeLiteral.get(Types.newParameterizedType(Optional.class, new Type[]{typeLiteral.getType()}));
    }

    static <T> TypeLiteral<com.google.common.base.Optional<jakarta.inject.Provider<T>>> optionalOfJakartaProvider(TypeLiteral<T> typeLiteral) {
        return TypeLiteral.get(Types.newParameterizedType(com.google.common.base.Optional.class, new Type[]{Types.newParameterizedType(jakarta.inject.Provider.class, new Type[]{typeLiteral.getType()})}));
    }

    static <T> TypeLiteral<Optional<jakarta.inject.Provider<T>>> javaOptionalOfJakartaProvider(TypeLiteral<T> typeLiteral) {
        return TypeLiteral.get(Types.newParameterizedType(Optional.class, new Type[]{Types.newParameterizedType(jakarta.inject.Provider.class, new Type[]{typeLiteral.getType()})}));
    }

    static <T> TypeLiteral<com.google.common.base.Optional<Provider<T>>> optionalOfProvider(TypeLiteral<T> typeLiteral) {
        return TypeLiteral.get(Types.newParameterizedType(com.google.common.base.Optional.class, new Type[]{Types.newParameterizedType(Provider.class, new Type[]{typeLiteral.getType()})}));
    }

    static <T> TypeLiteral<Optional<Provider<T>>> javaOptionalOfProvider(TypeLiteral<T> typeLiteral) {
        return TypeLiteral.get(Types.newParameterizedType(Optional.class, new Type[]{Types.newParameterizedType(Provider.class, new Type[]{typeLiteral.getType()})}));
    }

    static <T> Key<Provider<T>> providerOf(Key<T> key) {
        ParameterizedType parameterizedType = Types.providerOf(key.getTypeLiteral().getType());
        return key.ofType(parameterizedType);
    }

    private RealOptionalBinder(Binder binder, Key<T> key) {
        this.bindingSelection = new BindingSelection<T>(key);
        this.binder = binder;
    }

    private void addDirectTypeBinding(Binder binder) {
        binder.bind(this.bindingSelection.getDirectKey()).toProvider(new RealDirectTypeProvider<T>(this.bindingSelection));
    }

    Key<T> getKeyForDefaultBinding() {
        this.bindingSelection.checkNotInitialized();
        this.addDirectTypeBinding(this.binder);
        return this.bindingSelection.getKeyForDefaultBinding();
    }

    public LinkedBindingBuilder<T> setDefault() {
        return this.binder.bind(this.getKeyForDefaultBinding());
    }

    Key<T> getKeyForActualBinding() {
        this.bindingSelection.checkNotInitialized();
        this.addDirectTypeBinding(this.binder);
        return this.bindingSelection.getKeyForActualBinding();
    }

    public LinkedBindingBuilder<T> setBinding() {
        return this.binder.bind(this.getKeyForActualBinding());
    }

    @Override
    public void configure(Binder binder) {
        this.bindingSelection.checkNotInitialized();
        Key<T> key = this.bindingSelection.getDirectKey();
        TypeLiteral<T> typeLiteral = key.getTypeLiteral();
        Key<com.google.common.base.Optional<Provider<T>>> key2 = key.ofType(RealOptionalBinder.optionalOfProvider(typeLiteral));
        binder.bind(key2).toProvider(new RealOptionalProviderProvider<T>(this.bindingSelection));
        Key<Optional<Provider<T>>> key3 = key.ofType(RealOptionalBinder.javaOptionalOfProvider(typeLiteral));
        binder.bind(key3).toProvider(new JavaOptionalProviderProvider<T>(this.bindingSelection));
        binder.bind(key.ofType(RealOptionalBinder.optionalOfJakartaProvider(typeLiteral))).to(key2);
        binder.bind(key.ofType(RealOptionalBinder.javaOptionalOfJakartaProvider(typeLiteral))).to(key3);
        Key<com.google.common.base.Optional<T>> key4 = key.ofType(RealOptionalBinder.optionalOf(typeLiteral));
        binder.bind(key4).toProvider(new RealOptionalKeyProvider<T>(this.bindingSelection, key4));
        Key<Optional<T>> key5 = key.ofType(RealOptionalBinder.javaOptionalOf(typeLiteral));
        binder.bind(key5).toProvider(new JavaOptionalProvider<T>(this.bindingSelection, key5));
    }

    public boolean equals(Object object) {
        return object instanceof RealOptionalBinder && ((RealOptionalBinder)object).bindingSelection.equals(this.bindingSelection);
    }

    public int hashCode() {
        return this.bindingSelection.hashCode();
    }

    static abstract class BaseAnnotation
    implements Serializable,
    Annotation {
        private final String value;
        private final Class<? extends Annotation> clazz;
        private static final long serialVersionUID = 0L;

        BaseAnnotation(Class<? extends Annotation> clazz, String string) {
            this.clazz = (Class)Preconditions.checkNotNull(clazz, (Object)"clazz");
            this.value = (String)Preconditions.checkNotNull((Object)string, (Object)"value");
        }

        public String value() {
            return this.value;
        }

        @Override
        public int hashCode() {
            return 127 * "value".hashCode() ^ this.value.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof Actual && this.clazz == Actual.class) {
                Actual actual = (Actual)object;
                return this.value.equals(actual.value());
            }
            if (object instanceof Default && this.clazz == Default.class) {
                Default default_ = (Default)object;
                return this.value.equals(default_.value());
            }
            return false;
        }

        @Override
        public String toString() {
            return "@" + this.clazz.getName() + (this.value.isEmpty() ? "" : "(value=" + this.value + ")");
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return this.clazz;
        }
    }

    static class ActualImpl
    extends BaseAnnotation
    implements Actual {
        public ActualImpl(String string) {
            super(Actual.class, string);
        }
    }

    static class DefaultImpl
    extends BaseAnnotation
    implements Default {
        public DefaultImpl(String string) {
            super(Default.class, string);
        }
    }

    private static abstract class RealOptionalBinderProviderWithDependencies<T, P>
    extends InternalProviderInstanceBindingImpl.Factory<P> {
        protected final BindingSelection<T> bindingSelection;
        private boolean initialized = false;

        RealOptionalBinderProviderWithDependencies(BindingSelection<T> bindingSelection) {
            super(InternalProviderInstanceBindingImpl.InitializationTiming.DELAYED);
            this.bindingSelection = bindingSelection;
        }

        @Override
        final void initialize(InjectorImpl injectorImpl, Errors errors) {
            if (!this.initialized) {
                this.initialized = true;
                this.bindingSelection.initialize(injectorImpl, errors);
                this.doInitialize();
            }
        }

        abstract void doInitialize();

        public boolean equals(Object object) {
            return object != null && this.getClass() == object.getClass() && this.bindingSelection.equals(((RealOptionalBinderProviderWithDependencies)object).bindingSelection);
        }

        public int hashCode() {
            return this.bindingSelection.hashCode();
        }
    }

    private static final class BindingSelection<T> {
        private static final ImmutableSet<Dependency<?>> MODULE_DEPENDENCIES = ImmutableSet.of(Dependency.get(Key.get(Injector.class)));
        BindingImpl<T> actualBinding;
        BindingImpl<T> defaultBinding;
        BindingImpl<T> binding;
        private boolean initialized;
        private final Key<T> key;
        private ImmutableSet<Dependency<?>> dependencies = MODULE_DEPENDENCIES;
        private ImmutableSet<Dependency<?>> providerDependencies = MODULE_DEPENDENCIES;
        private String bindingName;
        private Key<T> defaultBindingKey;
        private Key<T> actualBindingKey;

        BindingSelection(Key<T> key) {
            this.key = key;
        }

        void checkNotInitialized() {
            Errors.checkConfiguration(!this.initialized, "already initialized", new Object[0]);
        }

        void initialize(InjectorImpl injectorImpl, Errors errors) {
            if (this.initialized) {
                return;
            }
            this.actualBinding = injectorImpl.getExistingBinding((Key)this.getKeyForActualBinding());
            this.defaultBinding = injectorImpl.getExistingBinding((Key)this.getKeyForDefaultBinding());
            Binding binding = injectorImpl.getExistingBinding((Key)this.key);
            if (this.actualBinding != null) {
                this.binding = this.actualBinding;
            } else if (this.defaultBinding != null) {
                this.binding = this.defaultBinding;
            } else if (binding != null) {
                this.binding = binding;
                this.actualBinding = binding;
            }
            if (this.binding != null) {
                this.dependencies = ImmutableSet.of(Dependency.get(this.binding.getKey()));
                this.providerDependencies = ImmutableSet.of(Dependency.get(RealOptionalBinder.providerOf(this.binding.getKey())));
            } else {
                this.dependencies = ImmutableSet.of();
                this.providerDependencies = ImmutableSet.of();
            }
            this.checkBindingIsNotRecursive(errors);
            this.initialized = true;
        }

        private void checkBindingIsNotRecursive(Errors errors) {
            LinkedBindingImpl linkedBindingImpl;
            if (this.binding instanceof LinkedBindingImpl && (linkedBindingImpl = (LinkedBindingImpl)this.binding).getLinkedKey().equals(this.key)) {
                errors.recursiveBinding(this.key, linkedBindingImpl.getLinkedKey());
            }
        }

        Key<T> getKeyForDefaultBinding() {
            if (this.defaultBindingKey == null) {
                this.defaultBindingKey = this.key.withAnnotation(new DefaultImpl(this.getBindingName()));
            }
            return this.defaultBindingKey;
        }

        Key<T> getKeyForActualBinding() {
            if (this.actualBindingKey == null) {
                this.actualBindingKey = this.key.withAnnotation(new ActualImpl(this.getBindingName()));
            }
            return this.actualBindingKey;
        }

        Key<T> getDirectKey() {
            return this.key;
        }

        private String getBindingName() {
            if (this.bindingName == null) {
                this.bindingName = Annotations.nameOf(this.key);
            }
            return this.bindingName;
        }

        BindingImpl<T> getBinding() {
            return this.binding;
        }

        BindingImpl<T> getDefaultBinding() {
            return this.defaultBinding;
        }

        BindingImpl<T> getActualBinding() {
            return this.actualBinding;
        }

        ImmutableSet<Dependency<?>> providerDependencies() {
            return this.providerDependencies;
        }

        ImmutableSet<Dependency<?>> dependencies() {
            return this.dependencies;
        }

        Dependency<?> getDependency() {
            return (Dependency)Iterables.getOnlyElement(this.dependencies);
        }

        boolean containsElement(Element element) {
            Object object;
            if (element instanceof ProviderInstanceBinding && (object = ((ProviderInstanceBinding)element).getUserSuppliedProvider()) instanceof RealOptionalBinderProviderWithDependencies) {
                return ((RealOptionalBinderProviderWithDependencies)object).bindingSelection.equals(this);
            }
            if (element instanceof Binding) {
                object = this.key.getTypeLiteral();
                Key key = ((Binding)element).getKey();
                return key.equals(this.getKeyForActualBinding()) || key.equals(this.getKeyForDefaultBinding()) || key.equals(this.key.ofType(RealOptionalBinder.javaOptionalOfJakartaProvider(object))) || key.equals(this.key.ofType(RealOptionalBinder.optionalOfJakartaProvider(object)));
            }
            return false;
        }

        public boolean equals(Object object) {
            return object instanceof BindingSelection && ((BindingSelection)object).key.equals(this.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }

    private static final class RealOptionalKeyProvider<T>
    extends RealOptionalBinderProviderWithDependencies<T, com.google.common.base.Optional<T>>
    implements ProviderWithExtensionVisitor<com.google.common.base.Optional<T>>,
    OptionalBinderBinding<com.google.common.base.Optional<T>> {
        private final Key<com.google.common.base.Optional<T>> optionalKey;
        private Dependency<?> targetDependency;
        private InternalFactory<? extends T> delegate;

        RealOptionalKeyProvider(BindingSelection<T> bindingSelection, Key<com.google.common.base.Optional<T>> key) {
            super(bindingSelection);
            this.optionalKey = key;
        }

        @Override
        void doInitialize() {
            if (this.bindingSelection.getBinding() != null) {
                this.delegate = this.bindingSelection.getBinding().getInternalFactory();
                this.targetDependency = this.bindingSelection.getDependency();
            }
        }

        @Override
        protected com.google.common.base.Optional<T> doProvision(InternalContext internalContext, Dependency<?> dependency) {
            T t;
            InternalFactory<T> internalFactory = this.delegate;
            if (internalFactory == null) {
                return com.google.common.base.Optional.absent();
            }
            Dependency<?> dependency2 = this.targetDependency;
            try {
                t = internalFactory.get(internalContext, dependency2, false);
            }
            catch (InternalProvisionException internalProvisionException) {
                throw internalProvisionException.addSource(dependency2);
            }
            return com.google.common.base.Optional.fromNullable(t);
        }

        @Override
        public Set<Dependency<?>> getDependencies() {
            return this.bindingSelection.dependencies();
        }

        @Override
        public <B, R> R acceptExtensionVisitor(BindingTargetVisitor<B, R> bindingTargetVisitor, ProviderInstanceBinding<? extends B> providerInstanceBinding) {
            if (bindingTargetVisitor instanceof MultibindingsTargetVisitor) {
                return (R)((MultibindingsTargetVisitor)bindingTargetVisitor).visit(this);
            }
            return bindingTargetVisitor.visit(providerInstanceBinding);
        }

        @Override
        public Key<com.google.common.base.Optional<T>> getKey() {
            return this.optionalKey;
        }

        @Override
        public Set<Key<?>> getAlternateKeys() {
            Key key = this.bindingSelection.getDirectKey();
            TypeLiteral typeLiteral = key.getTypeLiteral();
            return ImmutableSet.of(key.ofType(RealOptionalBinder.optionalOfProvider(typeLiteral)), key.ofType(RealOptionalBinder.optionalOfJakartaProvider(typeLiteral)));
        }

        @Override
        public Binding<?> getActualBinding() {
            return this.bindingSelection.getActualBinding();
        }

        @Override
        public Binding<?> getDefaultBinding() {
            return this.bindingSelection.getDefaultBinding();
        }

        @Override
        public boolean containsElement(Element element) {
            return this.bindingSelection.containsElement(element);
        }
    }

    private static final class RealOptionalProviderProvider<T>
    extends RealOptionalBinderProviderWithDependencies<T, com.google.common.base.Optional<Provider<T>>> {
        private com.google.common.base.Optional<Provider<T>> value;

        RealOptionalProviderProvider(BindingSelection<T> bindingSelection) {
            super(bindingSelection);
        }

        @Override
        void doInitialize() {
            this.value = this.bindingSelection.getBinding() == null ? com.google.common.base.Optional.absent() : com.google.common.base.Optional.of(this.bindingSelection.getBinding().getProvider());
        }

        @Override
        protected com.google.common.base.Optional<Provider<T>> doProvision(InternalContext internalContext, Dependency<?> dependency) {
            return this.value;
        }

        @Override
        public Set<Dependency<?>> getDependencies() {
            return this.bindingSelection.providerDependencies();
        }
    }

    private static final class RealDirectTypeProvider<T>
    extends RealOptionalBinderProviderWithDependencies<T, T> {
        private Key<? extends T> targetKey;
        private InternalFactory<? extends T> targetFactory;

        RealDirectTypeProvider(BindingSelection<T> bindingSelection) {
            super(bindingSelection);
        }

        @Override
        void doInitialize() {
            BindingImpl bindingImpl = this.bindingSelection.getBinding();
            this.targetKey = bindingImpl.getKey();
            this.targetFactory = bindingImpl.getInternalFactory();
        }

        @Override
        protected T doProvision(InternalContext internalContext, Dependency<?> dependency) {
            try {
                return this.targetFactory.get(internalContext, dependency, true);
            }
            catch (InternalProvisionException internalProvisionException) {
                throw internalProvisionException.addSource(this.targetKey);
            }
        }

        @Override
        public Set<Dependency<?>> getDependencies() {
            return this.bindingSelection.dependencies;
        }
    }

    private static final class JavaOptionalProviderProvider<T>
    extends RealOptionalBinderProviderWithDependencies<T, Optional<Provider<T>>> {
        private Optional<Provider<T>> value;

        JavaOptionalProviderProvider(BindingSelection<T> bindingSelection) {
            super(bindingSelection);
        }

        @Override
        void doInitialize() {
            this.value = this.bindingSelection.getBinding() == null ? Optional.empty() : Optional.of(this.bindingSelection.getBinding().getProvider());
        }

        @Override
        protected Optional<Provider<T>> doProvision(InternalContext internalContext, Dependency<?> dependency) {
            return this.value;
        }

        @Override
        public Set<Dependency<?>> getDependencies() {
            return this.bindingSelection.providerDependencies();
        }
    }

    private static final class JavaOptionalProvider<T>
    extends RealOptionalBinderProviderWithDependencies<T, Optional<T>>
    implements ProviderWithExtensionVisitor<Optional<T>>,
    OptionalBinderBinding<Optional<T>> {
        private final Key<Optional<T>> optionalKey;
        private Dependency<?> targetDependency;
        private InternalFactory<? extends T> target;

        JavaOptionalProvider(BindingSelection<T> bindingSelection, Key<Optional<T>> key) {
            super(bindingSelection);
            this.optionalKey = key;
        }

        @Override
        void doInitialize() {
            if (this.bindingSelection.getBinding() != null) {
                this.target = this.bindingSelection.getBinding().getInternalFactory();
                this.targetDependency = this.bindingSelection.getDependency();
            }
        }

        @Override
        protected Optional<T> doProvision(InternalContext internalContext, Dependency<?> dependency) {
            T t;
            InternalFactory<T> internalFactory = this.target;
            if (internalFactory == null) {
                return Optional.empty();
            }
            Dependency<?> dependency2 = this.targetDependency;
            try {
                t = internalFactory.get(internalContext, dependency2, false);
            }
            catch (InternalProvisionException internalProvisionException) {
                throw internalProvisionException.addSource(dependency2);
            }
            return Optional.ofNullable(t);
        }

        @Override
        public Set<Dependency<?>> getDependencies() {
            return this.bindingSelection.dependencies;
        }

        @Override
        public <B, R> R acceptExtensionVisitor(BindingTargetVisitor<B, R> bindingTargetVisitor, ProviderInstanceBinding<? extends B> providerInstanceBinding) {
            if (bindingTargetVisitor instanceof MultibindingsTargetVisitor) {
                return (R)((MultibindingsTargetVisitor)bindingTargetVisitor).visit(this);
            }
            return bindingTargetVisitor.visit(providerInstanceBinding);
        }

        @Override
        public boolean containsElement(Element element) {
            return this.bindingSelection.containsElement(element);
        }

        @Override
        public Binding<?> getActualBinding() {
            return this.bindingSelection.getActualBinding();
        }

        @Override
        public Binding<?> getDefaultBinding() {
            return this.bindingSelection.getDefaultBinding();
        }

        @Override
        public Key<Optional<T>> getKey() {
            return this.optionalKey;
        }

        @Override
        public Set<Key<?>> getAlternateKeys() {
            Key key = this.bindingSelection.getDirectKey();
            TypeLiteral typeLiteral = key.getTypeLiteral();
            return ImmutableSet.of(key.ofType(RealOptionalBinder.javaOptionalOfProvider(typeLiteral)), key.ofType(RealOptionalBinder.javaOptionalOfJakartaProvider(typeLiteral)));
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Qualifier
    static @interface Actual {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Qualifier
    static @interface Default {
        public String value();
    }

    static enum Source {
        DEFAULT,
        ACTUAL;

    }
}

