/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.plotsquared.google.BindingAnnotation;
import com.plotsquared.google.internal.Annotations;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.atomic.AtomicInteger;

public class UniqueAnnotations {
    private static final AtomicInteger nextUniqueValue = new AtomicInteger(1);
    private static final String INTERNAL_INSTANCE_STRING = Annotations.annotationInstanceClassString(Internal.class, true);

    private UniqueAnnotations() {
    }

    public static Annotation create() {
        return UniqueAnnotations.create(nextUniqueValue.getAndIncrement());
    }

    static Annotation create(final int n) {
        return new Internal(){

            @Override
            public int value() {
                return n;
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return Internal.class;
            }

            @Override
            public String toString() {
                return INTERNAL_INSTANCE_STRING + '(' + Annotations.memberValueString("value", n) + ')';
            }

            @Override
            public boolean equals(Object object) {
                return object instanceof Internal && ((Internal)object).value() == this.value();
            }

            @Override
            public int hashCode() {
                return 127 * "value".hashCode() ^ n;
            }
        };
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @BindingAnnotation
    static @interface Internal {
        public int value();
    }
}

