/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.plotsquared.google.Key;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.InjectorBindingData;
import com.plotsquared.google.internal.util.SourceProvider;
import java.util.Map;
import java.util.Set;

final class WeakKeySet {
    private Map<Key<?>, Multiset<Object>> backingMap;
    private final Object lock;
    private final Cache<InjectorBindingData, Set<KeyAndSource>> evictionCache = CacheBuilder.newBuilder().weakKeys().removalListener(this::cleanupOnRemoval).build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupOnRemoval(RemovalNotification<InjectorBindingData, Set<KeyAndSource>> removalNotification) {
        Preconditions.checkState((boolean)RemovalCause.COLLECTED.equals((Object)removalNotification.getCause()));
        Object object = this.lock;
        synchronized (object) {
            for (KeyAndSource keyAndSource : (Set)removalNotification.getValue()) {
                Multiset<Object> multiset = this.backingMap.get(keyAndSource.key);
                if (multiset == null) continue;
                multiset.remove(keyAndSource.source);
                if (!multiset.isEmpty()) continue;
                this.backingMap.remove(keyAndSource.key);
            }
        }
    }

    WeakKeySet(Object object) {
        this.lock = object;
    }

    public void add(Key<?> key2, InjectorBindingData injectorBindingData, Object object) {
        if (this.backingMap == null) {
            this.backingMap = Maps.newHashMap();
        }
        if (object instanceof Class || object == SourceProvider.UNKNOWN_SOURCE) {
            object = null;
        }
        Object object2 = Errors.convert(object);
        this.backingMap.computeIfAbsent(key2, key -> LinkedHashMultiset.create()).add(object2);
        if (injectorBindingData.parent().isPresent()) {
            Set set = (Set)this.evictionCache.getIfPresent((Object)injectorBindingData);
            if (set == null) {
                set = Sets.newHashSet();
                this.evictionCache.put((Object)injectorBindingData, (Object)set);
            }
            set.add(new KeyAndSource(key2, object2));
        }
    }

    public boolean contains(Key<?> key) {
        this.evictionCache.cleanUp();
        return this.backingMap != null && this.backingMap.containsKey(key);
    }

    public Set<Object> getSources(Key<?> key) {
        this.evictionCache.cleanUp();
        Multiset<Object> multiset = this.backingMap == null ? null : this.backingMap.get(key);
        return multiset == null ? null : multiset.elementSet();
    }

    private static final class KeyAndSource {
        final Key<?> key;
        final Object source;

        KeyAndSource(Key<?> key, Object object) {
            this.key = key;
            this.source = object;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.key, this.source});
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof KeyAndSource)) {
                return false;
            }
            KeyAndSource keyAndSource = (KeyAndSource)object;
            return Objects.equal(this.key, keyAndSource.key) && Objects.equal((Object)this.source, (Object)keyAndSource.source);
        }
    }
}

