/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal.aop;

import com.plotsquared.google.internal.asm.$MethodVisitor;
import com.plotsquared.google.internal.asm.$Type;

final class BytecodeTasks {
    private BytecodeTasks() {
    }

    public static void pushInteger($MethodVisitor $MethodVisitor, int n) {
        if (n < -1) {
            $MethodVisitor.visitLdcInsn(n);
        } else if (n <= 5) {
            $MethodVisitor.visitInsn(3 + n);
        } else if (n <= 127) {
            $MethodVisitor.visitIntInsn(16, n);
        } else if (n <= Short.MAX_VALUE) {
            $MethodVisitor.visitIntInsn(17, n);
        } else {
            $MethodVisitor.visitLdcInsn(n);
        }
    }

    public static void packArguments($MethodVisitor $MethodVisitor, Class<?>[] classArray) {
        BytecodeTasks.pushInteger($MethodVisitor, classArray.length);
        $MethodVisitor.visitTypeInsn(189, "java/lang/Object");
        int n = 0;
        int n2 = 1;
        for (Class<?> clazz : classArray) {
            $MethodVisitor.visitInsn(89);
            BytecodeTasks.pushInteger($MethodVisitor, n++);
            n2 += BytecodeTasks.loadArgument($MethodVisitor, clazz, n2);
            if (clazz.isPrimitive()) {
                BytecodeTasks.box($MethodVisitor, $Type.getType(clazz));
            }
            $MethodVisitor.visitInsn(83);
        }
    }

    public static void unpackArguments($MethodVisitor $MethodVisitor, Class<?>[] classArray) {
        int n = 0;
        for (Class<?> clazz : classArray) {
            $MethodVisitor.visitVarInsn(25, 2);
            BytecodeTasks.pushInteger($MethodVisitor, n++);
            $MethodVisitor.visitInsn(50);
            if (clazz.isPrimitive()) {
                BytecodeTasks.unbox($MethodVisitor, $Type.getType(clazz));
                continue;
            }
            $MethodVisitor.visitTypeInsn(192, $Type.getInternalName(clazz));
        }
    }

    public static int loadArgument($MethodVisitor $MethodVisitor, Class<?> clazz, int n) {
        if (!clazz.isPrimitive()) {
            $MethodVisitor.visitVarInsn(25, n);
            return 1;
        }
        $Type $Type = $Type.getType(clazz);
        $MethodVisitor.visitVarInsn($Type.getOpcode(21), n);
        return $Type.getSize();
    }

    public static void box($MethodVisitor $MethodVisitor, $Type $Type) {
        String string;
        String string2;
        switch ($Type.getSort()) {
            case 1: {
                string2 = "java/lang/Boolean";
                string = "(Z)Ljava/lang/Boolean;";
                break;
            }
            case 2: {
                string2 = "java/lang/Character";
                string = "(C)Ljava/lang/Character;";
                break;
            }
            case 3: {
                string2 = "java/lang/Byte";
                string = "(B)Ljava/lang/Byte;";
                break;
            }
            case 4: {
                string2 = "java/lang/Short";
                string = "(S)Ljava/lang/Short;";
                break;
            }
            case 5: {
                string2 = "java/lang/Integer";
                string = "(I)Ljava/lang/Integer;";
                break;
            }
            case 6: {
                string2 = "java/lang/Float";
                string = "(F)Ljava/lang/Float;";
                break;
            }
            case 7: {
                string2 = "java/lang/Long";
                string = "(J)Ljava/lang/Long;";
                break;
            }
            case 8: {
                string2 = "java/lang/Double";
                string = "(D)Ljava/lang/Double;";
                break;
            }
            default: {
                return;
            }
        }
        $MethodVisitor.visitMethodInsn(184, string2, "valueOf", string, false);
    }

    public static void unbox($MethodVisitor $MethodVisitor, $Type $Type) {
        String string;
        String string2;
        String string3;
        switch ($Type.getSort()) {
            case 1: {
                string3 = "java/lang/Boolean";
                string2 = "booleanValue";
                string = "()Z";
                break;
            }
            case 2: {
                string3 = "java/lang/Character";
                string2 = "charValue";
                string = "()C";
                break;
            }
            case 3: {
                string3 = "java/lang/Byte";
                string2 = "byteValue";
                string = "()B";
                break;
            }
            case 4: {
                string3 = "java/lang/Short";
                string2 = "shortValue";
                string = "()S";
                break;
            }
            case 5: {
                string3 = "java/lang/Integer";
                string2 = "intValue";
                string = "()I";
                break;
            }
            case 6: {
                string3 = "java/lang/Float";
                string2 = "floatValue";
                string = "()F";
                break;
            }
            case 7: {
                string3 = "java/lang/Long";
                string2 = "longValue";
                string = "()J";
                break;
            }
            case 8: {
                string3 = "java/lang/Double";
                string2 = "doubleValue";
                string = "()D";
                break;
            }
            default: {
                return;
            }
        }
        $MethodVisitor.visitTypeInsn(192, string3);
        $MethodVisitor.visitMethodInsn(182, string3, string2, string, false);
    }
}

