/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal.aop;

import com.plotsquared.google.internal.aop.AbstractGlueGenerator;
import com.plotsquared.google.internal.aop.BytecodeTasks;
import com.plotsquared.google.internal.aop.ClassDefining;
import com.plotsquared.google.internal.asm.$ClassWriter;
import com.plotsquared.google.internal.asm.$Handle;
import com.plotsquared.google.internal.asm.$MethodVisitor;
import com.plotsquared.google.internal.asm.$Type;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

final class Enhancer
extends AbstractGlueGenerator {
    private static final String HANDLERS_NAME = "GUICE$HANDLERS";
    private static final String HANDLERS_DESCRIPTOR = "[Ljava/lang/reflect/InvocationHandler;";
    private static final String HANDLER_TYPE = $Type.getInternalName(InvocationHandler.class);
    private static final String HANDLER_ARRAY_TYPE = $Type.getInternalName(InvocationHandler[].class);
    private static final String INVOKERS_NAME = "GUICE$INVOKERS";
    private static final String INVOKERS_DESCRIPTOR = "Ljava/lang/invoke/MethodHandle;";
    private static final String CALLBACK_DESCRIPTOR = "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;";
    private static final String METAFACTORY_DESCRIPTOR = "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;";
    private static final $Type INDEX_TO_INVOKER_METHOD_TYPE = $Type.getMethodType("(I)Ljava/util/function/BiFunction;");
    private static final $Type RAW_INVOKER_METHOD_TYPE = $Type.getMethodType("(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
    private static final $Type INVOKER_METHOD_TYPE = $Type.getMethodType("(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;");
    private final Map<Method, Method> bridgeDelegates;
    private final String checkcastToProxy;

    Enhancer(Class<?> clazz, Map<Method, Method> map) {
        super(clazz, "$$EnhancerByGuice$$");
        this.bridgeDelegates = map;
        this.checkcastToProxy = ClassDefining.canDowncastToProxy(clazz) ? this.proxyName : this.hostName;
    }

    @Override
    protected byte[] generateGlue(Collection<Executable> collection) {
        $ClassWriter $ClassWriter = new $ClassWriter(1);
        $ClassWriter.visit(52, 33, this.proxyName, null, this.hostName, null);
        $ClassWriter.visitSource("<generated>", null);
        $ClassWriter.visitField(25, INVOKERS_NAME, INVOKERS_DESCRIPTOR, null, null).visitEnd();
        this.setupInvokerTable($ClassWriter);
        this.generateTrampoline($ClassWriter, collection);
        $ClassWriter.visitField(18, HANDLERS_NAME, HANDLERS_DESCRIPTOR, null, null).visitEnd();
        HashSet<Method> hashSet = new HashSet<Method>(this.bridgeDelegates.keySet());
        int n = 0;
        for (Executable executable : collection) {
            if (executable instanceof Constructor) {
                this.enhanceConstructor($ClassWriter, (Constructor)executable);
                continue;
            }
            this.enhanceMethod($ClassWriter, (Method)executable, n++);
            hashSet.remove(executable);
        }
        for (Method method : hashSet) {
            Method method2 = this.bridgeDelegates.get(method);
            if (method2 == null) continue;
            this.generateVirtualBridge($ClassWriter, method, method2);
        }
        $ClassWriter.visitEnd();
        return $ClassWriter.toByteArray();
    }

    private void setupInvokerTable($ClassWriter $ClassWriter) {
        $MethodVisitor $MethodVisitor = $ClassWriter.visitMethod(10, "<clinit>", "()V", null, null);
        $MethodVisitor.visitCode();
        $Handle $Handle = new $Handle(6, this.proxyName, "GUICE$TRAMPOLINE", "(ILjava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;", false);
        if (ClassDefining.canLoadProxyByName(this.hostClass)) {
            $MethodVisitor.visitMethodInsn(184, "java/lang/invoke/MethodHandles", "lookup", "()Ljava/lang/invoke/MethodHandles$Lookup;", false);
            $MethodVisitor.visitLdcInsn("apply");
            $MethodVisitor.visitLdcInsn(INDEX_TO_INVOKER_METHOD_TYPE);
            $MethodVisitor.visitLdcInsn(RAW_INVOKER_METHOD_TYPE);
            $MethodVisitor.visitLdcInsn($Handle);
            $MethodVisitor.visitLdcInsn(INVOKER_METHOD_TYPE);
            $MethodVisitor.visitMethodInsn(184, "java/lang/invoke/LambdaMetafactory", "metafactory", METAFACTORY_DESCRIPTOR, false);
            $MethodVisitor.visitMethodInsn(182, "java/lang/invoke/CallSite", "getTarget", "()Ljava/lang/invoke/MethodHandle;", false);
        } else {
            $MethodVisitor.visitLdcInsn($Handle);
        }
        $MethodVisitor.visitFieldInsn(179, this.proxyName, INVOKERS_NAME, INVOKERS_DESCRIPTOR);
        $MethodVisitor.visitInsn(177);
        $MethodVisitor.visitMaxs(0, 0);
        $MethodVisitor.visitEnd();
    }

    private void enhanceConstructor($ClassWriter $ClassWriter, Constructor<?> constructor) {
        String string = $Type.getConstructorDescriptor(constructor);
        String string2 = "([Ljava/lang/reflect/InvocationHandler;" + string.substring(1);
        $MethodVisitor $MethodVisitor = $ClassWriter.visitMethod(1, "<init>", string2, null, Enhancer.exceptionNames(constructor));
        $MethodVisitor.visitCode();
        $MethodVisitor.visitVarInsn(25, 0);
        $MethodVisitor.visitInsn(89);
        $MethodVisitor.visitVarInsn(25, 1);
        $MethodVisitor.visitFieldInsn(181, this.proxyName, HANDLERS_NAME, HANDLERS_DESCRIPTOR);
        int n = 2;
        for (Class<?> clazz : constructor.getParameterTypes()) {
            n += BytecodeTasks.loadArgument($MethodVisitor, clazz, n);
        }
        $MethodVisitor.visitMethodInsn(183, this.hostName, "<init>", string, false);
        $MethodVisitor.visitInsn(177);
        $MethodVisitor.visitMaxs(0, 0);
        $MethodVisitor.visitEnd();
    }

    private void enhanceMethod($ClassWriter $ClassWriter, Method method, int n) {
        $MethodVisitor $MethodVisitor = $ClassWriter.visitMethod(0x10 | method.getModifiers() & 0xFFFFFADF, method.getName(), $Type.getMethodDescriptor(method), null, Enhancer.exceptionNames(method));
        $MethodVisitor.visitVarInsn(25, 0);
        $MethodVisitor.visitInsn(89);
        $MethodVisitor.visitFieldInsn(180, this.proxyName, HANDLERS_NAME, HANDLERS_DESCRIPTOR);
        BytecodeTasks.pushInteger($MethodVisitor, n);
        $MethodVisitor.visitInsn(50);
        $MethodVisitor.visitInsn(95);
        $MethodVisitor.visitInsn(1);
        BytecodeTasks.packArguments($MethodVisitor, method.getParameterTypes());
        $MethodVisitor.visitMethodInsn(185, HANDLER_TYPE, "invoke", CALLBACK_DESCRIPTOR, true);
        Class<?> clazz = method.getReturnType();
        if (clazz == Void.TYPE) {
            $MethodVisitor.visitInsn(177);
        } else if (clazz.isPrimitive()) {
            $Type $Type = $Type.getType(clazz);
            BytecodeTasks.unbox($MethodVisitor, $Type);
            $MethodVisitor.visitInsn($Type.getOpcode(172));
        } else {
            $MethodVisitor.visitTypeInsn(192, $Type.getInternalName(clazz));
            $MethodVisitor.visitInsn(176);
        }
        $MethodVisitor.visitMaxs(0, 0);
        $MethodVisitor.visitEnd();
    }

    @Override
    protected void generateConstructorInvoker($MethodVisitor $MethodVisitor, Constructor<?> constructor) {
        String string = $Type.getConstructorDescriptor(constructor);
        String string2 = "([Ljava/lang/reflect/InvocationHandler;" + string.substring(1);
        $MethodVisitor.visitTypeInsn(187, this.proxyName);
        $MethodVisitor.visitInsn(89);
        $MethodVisitor.visitVarInsn(25, 1);
        $MethodVisitor.visitTypeInsn(192, HANDLER_ARRAY_TYPE);
        BytecodeTasks.unpackArguments($MethodVisitor, constructor.getParameterTypes());
        $MethodVisitor.visitMethodInsn(183, this.proxyName, "<init>", string2, false);
    }

    @Override
    protected void generateMethodInvoker($MethodVisitor $MethodVisitor, Method method) {
        Method method2 = this.bridgeDelegates.getOrDefault(method, method);
        int n = method2 != method ? 182 : 183;
        $MethodVisitor.visitVarInsn(25, 1);
        $MethodVisitor.visitTypeInsn(192, this.checkcastToProxy);
        BytecodeTasks.unpackArguments($MethodVisitor, method2.getParameterTypes());
        $MethodVisitor.visitMethodInsn(n, this.hostName, method2.getName(), $Type.getMethodDescriptor(method2), false);
        Class<?> clazz = method2.getReturnType();
        if (clazz == Void.TYPE) {
            $MethodVisitor.visitInsn(1);
        } else if (clazz.isPrimitive()) {
            BytecodeTasks.box($MethodVisitor, $Type.getType(clazz));
        }
    }

    private void generateVirtualBridge($ClassWriter $ClassWriter, Method method, Method method2) {
        $MethodVisitor $MethodVisitor = $ClassWriter.visitMethod(0x10 | method.getModifiers() & 0xFFFFFADF, method.getName(), $Type.getMethodDescriptor(method), null, Enhancer.exceptionNames(method));
        $MethodVisitor.visitVarInsn(25, 0);
        $MethodVisitor.visitTypeInsn(192, this.checkcastToProxy);
        Class<?>[] classArray = method.getParameterTypes();
        Class<?>[] classArray2 = method2.getParameterTypes();
        int n = 1;
        int n2 = classArray2.length;
        for (int i = 0; i < n2; ++i) {
            Class<?> clazz = classArray2[i];
            n += BytecodeTasks.loadArgument($MethodVisitor, clazz, n);
            if (clazz == classArray[i]) continue;
            $MethodVisitor.visitTypeInsn(192, $Type.getInternalName(clazz));
        }
        $MethodVisitor.visitMethodInsn(182, this.hostName, method2.getName(), $Type.getMethodDescriptor(method2), false);
        $Type $Type = $Type.getType(method.getReturnType());
        if (method2.getReturnType() != method.getReturnType()) {
            $MethodVisitor.visitTypeInsn(192, $Type.getInternalName());
        }
        $MethodVisitor.visitInsn($Type.getOpcode(172));
        $MethodVisitor.visitMaxs(0, 0);
        $MethodVisitor.visitEnd();
    }

    @Override
    protected MethodHandle lookupInvokerTable(Class<?> clazz) {
        return (MethodHandle)clazz.getField(INVOKERS_NAME).get(null);
    }

    private static String[] exceptionNames(Executable executable) {
        Class[] classArray = executable.getExceptionTypes();
        String[] stringArray = new String[classArray.length];
        Arrays.setAll(stringArray, n -> $Type.getInternalName(classArray[n]));
        return stringArray;
    }
}

