/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal.aop;

import com.google.common.collect.ImmutableMap;
import com.plotsquared.google.internal.BytecodeGen;
import com.plotsquared.google.internal.aop.ClassBuilding;
import com.plotsquared.google.internal.aop.ClassDefining;
import com.plotsquared.google.internal.aop.Enhancer;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Function;

final class EnhancerBuilderImpl
implements BytecodeGen.EnhancerBuilder {
    private static final ClassValue<Map<BitSet, Function<String, BiFunction<Object, Object[], Object>>>> ENHANCERS = new ClassValue<Map<BitSet, Function<String, BiFunction<Object, Object[], Object>>>>(){

        @Override
        protected Map<BitSet, Function<String, BiFunction<Object, Object[], Object>>> computeValue(Class<?> clazz) {
            return new HashMap<BitSet, Function<String, BiFunction<Object, Object[], Object>>>();
        }
    };
    private final Class<?> hostClass;
    private final Method[] enhanceableMethods;
    private final Map<Method, Method> bridgeDelegates;

    EnhancerBuilderImpl(Class<?> clazz, Collection<Method> collection, Map<Method, Method> map) {
        this.hostClass = clazz;
        this.enhanceableMethods = collection.toArray(new Method[0]);
        this.bridgeDelegates = ImmutableMap.copyOf(map);
    }

    @Override
    public Method[] getEnhanceableMethods() {
        return this.enhanceableMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Function<String, BiFunction<Object, Object[], Object>> buildEnhancer(BitSet bitSet) {
        Map<BitSet, Function<String, BiFunction<Object, Object[], Object>>> map;
        if ((this.hostClass.getModifiers() & 0x10) != 0) {
            throw new IllegalArgumentException("Cannot subclass final " + this.hostClass);
        }
        Map<BitSet, Function<String, BiFunction<Object, Object[], Object>>> map2 = map = ENHANCERS.get(this.hostClass);
        synchronized (map2) {
            return map.computeIfAbsent(bitSet, this::doBuildEnhancer);
        }
    }

    private Function<String, BiFunction<Object, Object[], Object>> doBuildEnhancer(BitSet bitSet) {
        TreeMap<String, Executable> treeMap = new TreeMap<String, Executable>();
        ClassBuilding.visitMembers((Executable[])this.hostClass.getDeclaredConstructors(), (boolean)ClassDefining.hasPackageAccess(), constructor -> treeMap.put(ClassBuilding.signature(constructor), (Executable)constructor));
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            Method method = this.enhanceableMethods[n];
            treeMap.put(ClassBuilding.signature(method), method);
            n = bitSet.nextSetBit(n + 1);
        }
        return new Enhancer(this.hostClass, this.bridgeDelegates).glue(treeMap);
    }
}

