/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal.aop;

import com.plotsquared.google.internal.aop.ClassDefiner;
import com.plotsquared.google.internal.aop.UnsafeGetter;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import sun.misc.Unsafe;

final class HiddenClassDefiner
implements ClassDefiner {
    private static final Unsafe THE_UNSAFE;
    private static final Object TRUSTED_LOOKUP_BASE;
    private static final long TRUSTED_LOOKUP_OFFSET;
    private static final Object HIDDEN_CLASS_OPTIONS;
    private static final Method HIDDEN_DEFINE_METHOD;

    HiddenClassDefiner() {
    }

    @Override
    public Class<?> define(Class<?> clazz, byte[] byArray) {
        MethodHandles.Lookup lookup = (MethodHandles.Lookup)THE_UNSAFE.getObject(TRUSTED_LOOKUP_BASE, TRUSTED_LOOKUP_OFFSET);
        MethodHandles.Lookup lookup2 = (MethodHandles.Lookup)HIDDEN_DEFINE_METHOD.invoke((Object)lookup.in(clazz), byArray, false, HIDDEN_CLASS_OPTIONS);
        return lookup2.lookupClass();
    }

    private static Object classOptions(String ... stringArray) {
        Class<?> clazz = Class.forName(MethodHandles.Lookup.class.getName() + "$ClassOption");
        Object object = Array.newInstance(clazz, stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            Array.set(object, i, Enum.valueOf(clazz, stringArray[i]));
        }
        return object;
    }

    static {
        try {
            THE_UNSAFE = UnsafeGetter.getUnsafe();
            Field field = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            TRUSTED_LOOKUP_BASE = THE_UNSAFE.staticFieldBase(field);
            TRUSTED_LOOKUP_OFFSET = THE_UNSAFE.staticFieldOffset(field);
            HIDDEN_CLASS_OPTIONS = HiddenClassDefiner.classOptions("NESTMATE");
            HIDDEN_DEFINE_METHOD = MethodHandles.Lookup.class.getMethod("defineHiddenClass", byte[].class, Boolean.TYPE, HIDDEN_CLASS_OPTIONS.getClass());
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new ExceptionInInitializerError(reflectiveOperationException);
        }
    }
}

