/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal.asm;

import com.plotsquared.google.internal.asm.$ByteVector;

public final class $TypePath {
    public static final int ARRAY_ELEMENT = 0;
    public static final int INNER_TYPE = 1;
    public static final int WILDCARD_BOUND = 2;
    public static final int TYPE_ARGUMENT = 3;
    private final byte[] typePathContainer;
    private final int typePathOffset;

    $TypePath(byte[] byArray, int n) {
        this.typePathContainer = byArray;
        this.typePathOffset = n;
    }

    public int getLength() {
        return this.typePathContainer[this.typePathOffset];
    }

    public int getStep(int n) {
        return this.typePathContainer[this.typePathOffset + 2 * n + 1];
    }

    public int getStepArgument(int n) {
        return this.typePathContainer[this.typePathOffset + 2 * n + 2];
    }

    public static $TypePath fromString(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        int n = string.length();
        $ByteVector $ByteVector = new $ByteVector(n);
        $ByteVector.putByte(0);
        int n2 = 0;
        while (n2 < n) {
            char c;
            if ((c = string.charAt(n2++)) == '[') {
                $ByteVector.put11(0, 0);
                continue;
            }
            if (c == '.') {
                $ByteVector.put11(1, 0);
                continue;
            }
            if (c == '*') {
                $ByteVector.put11(2, 0);
                continue;
            }
            if (c >= '0' && c <= '9') {
                int n3 = c - 48;
                while (n2 < n) {
                    if ((c = string.charAt(n2++)) >= '0' && c <= '9') {
                        n3 = n3 * 10 + c - 48;
                        continue;
                    }
                    if (c == ';') break;
                    throw new IllegalArgumentException();
                }
                $ByteVector.put11(3, n3);
                continue;
            }
            throw new IllegalArgumentException();
        }
        $ByteVector.data[0] = (byte)($ByteVector.length / 2);
        return new $TypePath($ByteVector.data, 0);
    }

    public String toString() {
        int n = this.getLength();
        StringBuilder stringBuilder = new StringBuilder(n * 2);
        block6: for (int i = 0; i < n; ++i) {
            switch (this.getStep(i)) {
                case 0: {
                    stringBuilder.append('[');
                    continue block6;
                }
                case 1: {
                    stringBuilder.append('.');
                    continue block6;
                }
                case 2: {
                    stringBuilder.append('*');
                    continue block6;
                }
                case 3: {
                    stringBuilder.append(this.getStepArgument(i)).append(';');
                    continue block6;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        return stringBuilder.toString();
    }

    static void put($TypePath $TypePath, $ByteVector $ByteVector) {
        if ($TypePath == null) {
            $ByteVector.putByte(0);
        } else {
            int n = $TypePath.typePathContainer[$TypePath.typePathOffset] * 2 + 1;
            $ByteVector.putByteArray($TypePath.typePathContainer, $TypePath.typePathOffset, n);
        }
    }
}

