/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.spi;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import com.plotsquared.google.ConfigurationException;
import com.plotsquared.google.Inject;
import com.plotsquared.google.Key;
import com.plotsquared.google.TypeLiteral;
import com.plotsquared.google.internal.Annotations;
import com.plotsquared.google.internal.DeclaredMembers;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.ErrorsException;
import com.plotsquared.google.internal.KotlinSupport;
import com.plotsquared.google.internal.MoreTypes;
import com.plotsquared.google.internal.Nullability;
import com.plotsquared.google.internal.util.Classes;
import com.plotsquared.google.spi.Dependency;
import com.plotsquared.google.spi.Toolable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public final class InjectionPoint {
    private static final Logger logger = Logger.getLogger(InjectionPoint.class.getName());
    private final boolean optional;
    private final Member member;
    private final TypeLiteral<?> declaringType;
    private final ImmutableList<Dependency<?>> dependencies;

    InjectionPoint(TypeLiteral<?> typeLiteral, Method method, boolean bl) {
        this.member = method;
        this.declaringType = typeLiteral;
        this.optional = bl;
        this.dependencies = this.forMember(new Errors(method), method, typeLiteral, method.getAnnotatedParameterTypes(), method.getParameterAnnotations(), KotlinSupport.getInstance().getIsParameterKotlinNullablePredicate(method));
    }

    InjectionPoint(TypeLiteral<?> typeLiteral, Constructor<?> constructor) {
        this.member = constructor;
        this.declaringType = typeLiteral;
        this.optional = false;
        Errors errors = new Errors(constructor);
        KotlinSupport.getInstance().checkConstructorParameterAnnotations(constructor, errors);
        this.dependencies = this.forMember(errors, constructor, typeLiteral, constructor.getAnnotatedParameterTypes(), constructor.getParameterAnnotations(), KotlinSupport.getInstance().getIsParameterKotlinNullablePredicate(constructor));
    }

    InjectionPoint(TypeLiteral<?> typeLiteral, Field field, boolean bl) {
        this.member = field;
        this.declaringType = typeLiteral;
        this.optional = bl;
        Annotation[] annotationArray = InjectionPoint.getAnnotations(field);
        Annotation[] annotationArray2 = field.getAnnotatedType().getAnnotations();
        Errors errors = new Errors(field);
        Key<?> key = null;
        try {
            key = Annotations.getKey(typeLiteral.getFieldType(field), field, annotationArray, errors);
        }
        catch (ConfigurationException configurationException) {
            errors.merge(configurationException.getErrorMessages());
        }
        catch (ErrorsException errorsException) {
            errors.merge(errorsException.getErrors());
        }
        errors.throwConfigurationExceptionIfErrorsExist();
        boolean bl2 = Nullability.hasNullableAnnotation(annotationArray) || Nullability.hasNullableAnnotation(annotationArray2) || KotlinSupport.getInstance().isNullable(field);
        this.dependencies = ImmutableList.of(this.newDependency(key, bl2, -1));
    }

    private ImmutableList<Dependency<?>> forMember(Errors errors, Member member, TypeLiteral<?> typeLiteral, AnnotatedType[] annotatedTypeArray, Annotation[][] annotationArray, Predicate<Integer> predicate) {
        ArrayList arrayList = Lists.newArrayList();
        int n = 0;
        for (TypeLiteral<?> typeLiteral2 : typeLiteral.getParameterTypes(member)) {
            try {
                Annotation[] annotationArray2 = annotatedTypeArray[n].getAnnotations();
                Annotation[] annotationArray3 = annotationArray[n];
                Key<?> key = Annotations.getKey(typeLiteral2, member, annotationArray3, errors);
                boolean bl = Nullability.hasNullableAnnotation(annotationArray3) || Nullability.hasNullableAnnotation(annotationArray2) || predicate.test(n);
                arrayList.add(this.newDependency(key, bl, n));
                ++n;
            }
            catch (ConfigurationException configurationException) {
                errors.merge(configurationException.getErrorMessages());
            }
            catch (ErrorsException errorsException) {
                errors.merge(errorsException.getErrors());
            }
        }
        errors.throwConfigurationExceptionIfErrorsExist();
        return ImmutableList.copyOf((Collection)arrayList);
    }

    private <T> Dependency<T> newDependency(Key<T> key, boolean bl, int n) {
        return new Dependency<T>(this, key, bl, n);
    }

    public Member getMember() {
        return this.member;
    }

    public List<Dependency<?>> getDependencies() {
        return this.dependencies;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean isToolable() {
        return ((AnnotatedElement)((Object)this.member)).isAnnotationPresent(Toolable.class);
    }

    public TypeLiteral<?> getDeclaringType() {
        return this.declaringType;
    }

    public boolean equals(Object object) {
        return object instanceof InjectionPoint && this.member.equals(((InjectionPoint)object).member) && this.declaringType.equals(((InjectionPoint)object).declaringType);
    }

    public int hashCode() {
        return this.member.hashCode() ^ this.declaringType.hashCode();
    }

    public String toString() {
        return Classes.toString(this.member);
    }

    public static <T> InjectionPoint forConstructor(Constructor<T> constructor) {
        return new InjectionPoint(TypeLiteral.get(constructor.getDeclaringClass()), constructor);
    }

    public static <T> InjectionPoint forConstructor(Constructor<T> constructor, TypeLiteral<? extends T> typeLiteral) {
        if (typeLiteral.getRawType() != constructor.getDeclaringClass()) {
            new Errors(typeLiteral).constructorNotDefinedByType(constructor, typeLiteral).throwConfigurationExceptionIfErrorsExist();
        }
        return new InjectionPoint(typeLiteral, constructor);
    }

    public static InjectionPoint forConstructorOf(TypeLiteral<?> typeLiteral) {
        return InjectionPoint.forConstructorOf(typeLiteral, false);
    }

    public static InjectionPoint forConstructorOf(TypeLiteral<?> typeLiteral, boolean bl) {
        Class<?> clazz = MoreTypes.getRawType(typeLiteral.getType());
        Errors errors = new Errors(clazz);
        List list = Arrays.stream(clazz.getDeclaredConstructors()).filter(InjectionPoint::isInjectableConstructor).collect(Collectors.toList());
        Constructor constructor2 = null;
        list.stream().filter(constructor -> constructor.isAnnotationPresent(Inject.class)).filter(constructor -> constructor.getAnnotation(Inject.class).optional()).forEach(errors::optionalConstructor);
        if (list.size() > 1) {
            errors.tooManyConstructors(clazz);
        } else {
            constructor2 = (Constructor)Iterables.getOnlyElement(list, null);
            if (constructor2 != null) {
                InjectionPoint.checkForMisplacedBindingAnnotations(constructor2, errors);
            }
        }
        if (bl && constructor2 == null) {
            errors.atInjectRequired(typeLiteral);
        }
        errors.throwConfigurationExceptionIfErrorsExist();
        if (constructor2 != null) {
            return new InjectionPoint(typeLiteral, constructor2);
        }
        try {
            Constructor<?> constructor3 = clazz.getDeclaredConstructor(new Class[0]);
            if (Modifier.isPrivate(constructor3.getModifiers()) && !Modifier.isPrivate(clazz.getModifiers())) {
                errors.missingConstructor(typeLiteral);
                throw new ConfigurationException(errors.getMessages());
            }
            InjectionPoint.checkForMisplacedBindingAnnotations(constructor3, errors);
            return new InjectionPoint(typeLiteral, constructor3);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            errors.missingConstructor(typeLiteral);
            throw new ConfigurationException(errors.getMessages());
        }
    }

    private static boolean isInjectableConstructor(Constructor<?> constructor) {
        return constructor.isAnnotationPresent(Inject.class) || constructor.isAnnotationPresent(jakarta.inject.Inject.class);
    }

    public static InjectionPoint forConstructorOf(Class<?> clazz) {
        return InjectionPoint.forConstructorOf(TypeLiteral.get(clazz));
    }

    public static <T> InjectionPoint forMethod(Method method, TypeLiteral<T> typeLiteral) {
        return new InjectionPoint(typeLiteral, method, false);
    }

    public static Set<InjectionPoint> forStaticMethodsAndFields(TypeLiteral<?> typeLiteral) {
        Set<InjectionPoint> set;
        Errors errors = new Errors();
        if (typeLiteral.getRawType().isInterface()) {
            errors.staticInjectionOnInterface(typeLiteral.getRawType());
            set = null;
        } else {
            set = InjectionPoint.getInjectionPoints(typeLiteral, true, errors);
        }
        if (errors.hasErrors()) {
            throw new ConfigurationException(errors.getMessages()).withPartialValue(set);
        }
        return set;
    }

    public static Set<InjectionPoint> forStaticMethodsAndFields(Class<?> clazz) {
        return InjectionPoint.forStaticMethodsAndFields(TypeLiteral.get(clazz));
    }

    public static Set<InjectionPoint> forInstanceMethodsAndFields(TypeLiteral<?> typeLiteral) {
        Errors errors = new Errors();
        Set<InjectionPoint> set = InjectionPoint.getInjectionPoints(typeLiteral, false, errors);
        if (errors.hasErrors()) {
            throw new ConfigurationException(errors.getMessages()).withPartialValue(set);
        }
        return set;
    }

    public static Set<InjectionPoint> forInstanceMethodsAndFields(Class<?> clazz) {
        return InjectionPoint.forInstanceMethodsAndFields(TypeLiteral.get(clazz));
    }

    private static boolean checkForMisplacedBindingAnnotations(Member member, Errors errors) {
        Annotation annotation = Annotations.findBindingAnnotation(errors, member, ((AnnotatedElement)((Object)member)).getAnnotations());
        if (annotation == null) {
            return false;
        }
        if (member instanceof Method) {
            try {
                if (member.getDeclaringClass().getDeclaredField(member.getName()) != null) {
                    return false;
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        errors.misplacedBindingAnnotation(member, annotation);
        return true;
    }

    static Annotation getAtInject(AnnotatedElement annotatedElement) {
        jakarta.inject.Inject inject = annotatedElement.getAnnotation(jakarta.inject.Inject.class);
        return inject == null ? annotatedElement.getAnnotation(Inject.class) : inject;
    }

    private static Set<InjectionPoint> getInjectionPoints(TypeLiteral<?> typeLiteral, boolean bl, Errors errors) {
        Object object;
        int n;
        InjectableMembers injectableMembers = new InjectableMembers();
        OverrideIndex overrideIndex = null;
        List<TypeLiteral<?>> list = InjectionPoint.hierarchyFor(typeLiteral);
        for (int i = n = list.size() - 1; i >= 0; --i) {
            Annotation annotation;
            if (overrideIndex != null && i < n) {
                overrideIndex.position = i == 0 ? Position.BOTTOM : Position.MIDDLE;
            }
            object = list.get(i);
            for (Field field : InjectionPoint.getDeclaredFields(object)) {
                if (Modifier.isStatic(field.getModifiers()) != bl || (annotation = InjectionPoint.getAtInject(field)) == null) continue;
                InjectableField bl2 = new InjectableField((TypeLiteral<?>)object, field, annotation);
                if (bl2.specInject && Modifier.isFinal(field.getModifiers())) {
                    errors.cannotInjectFinalField(field);
                }
                injectableMembers.add(bl2);
            }
            for (AccessibleObject accessibleObject : InjectionPoint.getDeclaredMethods(object)) {
                boolean bl2;
                if (!InjectionPoint.isEligibleForInjection((Method)accessibleObject, bl)) continue;
                annotation = InjectionPoint.getAtInject(accessibleObject);
                if (annotation != null) {
                    InjectableMethod injectableMethod = new InjectableMethod((TypeLiteral<?>)object, (Method)accessibleObject, annotation);
                    if (InjectionPoint.checkForMisplacedBindingAnnotations((Member)((Object)accessibleObject), errors) || !InjectionPoint.isValidMethod(injectableMethod, errors)) {
                        boolean bl3;
                        if (overrideIndex == null || !(bl3 = overrideIndex.removeIfOverriddenBy((Method)accessibleObject, false, injectableMethod))) continue;
                        logger.log(Level.WARNING, "Method: {0} is not a valid injectable method (because it either has misplaced binding annotations or specifies type parameters) but is overriding a method that is valid. Because it is not valid, the method will not be injected. To fix this, make the method a valid injectable method.", accessibleObject);
                        continue;
                    }
                    if (bl) {
                        injectableMembers.add(injectableMethod);
                        continue;
                    }
                    if (overrideIndex == null) {
                        overrideIndex = new OverrideIndex(injectableMembers);
                    } else {
                        overrideIndex.removeIfOverriddenBy((Method)accessibleObject, true, injectableMethod);
                    }
                    overrideIndex.add(injectableMethod);
                    continue;
                }
                if (overrideIndex == null || !(bl2 = overrideIndex.removeIfOverriddenBy((Method)accessibleObject, false, null))) continue;
                logger.log(Level.WARNING, "Method: {0} is not annotated with @Inject but is overriding a method that is annotated with @jakarta.inject.Inject.Because it is not annotated with @Inject, the method will not be injected. To fix this, annotate the method with @Inject.", accessibleObject);
            }
        }
        if (injectableMembers.isEmpty()) {
            return Collections.emptySet();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        object = injectableMembers.head;
        while (object != null) {
            block14: {
                try {
                    builder.add((Object)((InjectableMember)object).toInjectionPoint());
                }
                catch (ConfigurationException configurationException) {
                    if (((InjectableMember)object).optional) break block14;
                    errors.merge(configurationException.getErrorMessages());
                }
            }
            object = ((InjectableMember)object).next;
        }
        return builder.build();
    }

    private static Field[] getDeclaredFields(TypeLiteral<?> typeLiteral) {
        return DeclaredMembers.getDeclaredFields(typeLiteral.getRawType());
    }

    private static Method[] getDeclaredMethods(TypeLiteral<?> typeLiteral) {
        return DeclaredMembers.getDeclaredMethods(typeLiteral.getRawType());
    }

    private static boolean isEligibleForInjection(Method method, boolean bl) {
        return Modifier.isStatic(method.getModifiers()) == bl && !method.isBridge() && !method.isSynthetic();
    }

    private static boolean isValidMethod(InjectableMethod injectableMethod, Errors errors) {
        boolean bl = true;
        if (injectableMethod.specInject) {
            Method method = injectableMethod.method;
            if (Modifier.isAbstract(method.getModifiers())) {
                errors.cannotInjectAbstractMethod(method);
                bl = false;
            }
            if (method.getTypeParameters().length > 0) {
                errors.cannotInjectMethodWithTypeParameters(method);
                bl = false;
            }
        }
        return bl;
    }

    private static List<TypeLiteral<?>> hierarchyFor(TypeLiteral<?> typeLiteral) {
        ArrayList arrayList = new ArrayList();
        TypeLiteral<?> typeLiteral2 = typeLiteral;
        while (typeLiteral2.getRawType() != Object.class) {
            arrayList.add(typeLiteral2);
            typeLiteral2 = typeLiteral2.getSupertype(typeLiteral2.getRawType().getSuperclass());
        }
        return arrayList;
    }

    private static boolean overrides(Method method, Method method2) {
        int n = method2.getModifiers();
        if (Modifier.isPublic(n) || Modifier.isProtected(n)) {
            return true;
        }
        if (Modifier.isPrivate(n)) {
            return false;
        }
        return method.getDeclaringClass().getPackage().equals(method2.getDeclaringClass().getPackage());
    }

    public static Annotation[] getAnnotations(Field field) {
        Object[] objectArray = field.getAnnotations();
        Object[] objectArray2 = KotlinSupport.getInstance().getAnnotations(field);
        if (objectArray2.length == 0) {
            return objectArray;
        }
        return (Annotation[])ObjectArrays.concat((Object[])objectArray, (Object[])objectArray2, Annotation.class);
    }

    static class Signature {
        final String name;
        final Class<?>[] parameterTypes;
        final int hash;

        Signature(Method method) {
            this.name = method.getName();
            this.parameterTypes = method.getParameterTypes();
            int n = this.name.hashCode();
            n = n * 31 + this.parameterTypes.length;
            for (Class<?> clazz : this.parameterTypes) {
                n = n * 31 + clazz.hashCode();
            }
            this.hash = n;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Signature)) {
                return false;
            }
            Signature signature = (Signature)object;
            if (!this.name.equals(signature.name)) {
                return false;
            }
            if (this.parameterTypes.length != signature.parameterTypes.length) {
                return false;
            }
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                if (this.parameterTypes[i] == signature.parameterTypes[i]) continue;
                return false;
            }
            return true;
        }
    }

    static class OverrideIndex {
        final InjectableMembers injectableMembers;
        Map<Signature, List<InjectableMethod>> bySignature;
        Position position = Position.TOP;
        Method lastMethod;
        Signature lastSignature;

        OverrideIndex(InjectableMembers injectableMembers) {
            this.injectableMembers = injectableMembers;
        }

        boolean removeIfOverriddenBy(Method method, boolean bl, InjectableMethod injectableMethod) {
            Object object;
            Object object2;
            if (this.position == Position.TOP) {
                return false;
            }
            if (this.bySignature == null) {
                this.bySignature = new HashMap<Signature, List<InjectableMethod>>();
                object2 = this.injectableMembers.head;
                while (object2 != null) {
                    if (object2 instanceof InjectableMethod && !((InjectableMethod)(object = (InjectableMethod)object2)).isFinal()) {
                        ArrayList<Object> arrayList = new ArrayList<Object>();
                        arrayList.add(object);
                        this.bySignature.put(new Signature(((InjectableMethod)object).method), arrayList);
                    }
                    object2 = ((InjectableMember)object2).next;
                }
            }
            this.lastMethod = method;
            this.lastSignature = new Signature(method);
            object2 = this.lastSignature;
            object = this.bySignature.get(object2);
            boolean bl2 = false;
            if (object != null) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    boolean bl3;
                    InjectableMethod injectableMethod2 = (InjectableMethod)iterator.next();
                    if (!InjectionPoint.overrides(method, injectableMethod2.method)) continue;
                    boolean bl4 = bl3 = !injectableMethod2.specInject || injectableMethod2.overrodeGuiceInject;
                    if (injectableMethod != null) {
                        injectableMethod.overrodeGuiceInject = bl3;
                    }
                    if (!bl && bl3) continue;
                    bl2 = true;
                    iterator.remove();
                    this.injectableMembers.remove(injectableMethod2);
                }
            }
            return bl2;
        }

        void add(InjectableMethod injectableMethod) {
            this.injectableMembers.add(injectableMethod);
            if (this.position == Position.BOTTOM || injectableMethod.isFinal()) {
                return;
            }
            if (this.bySignature != null) {
                Signature signature2 = injectableMethod.method == this.lastMethod ? this.lastSignature : new Signature(injectableMethod.method);
                this.bySignature.computeIfAbsent(signature2, signature -> new ArrayList()).add(injectableMethod);
            }
        }
    }

    static enum Position {
        TOP,
        MIDDLE,
        BOTTOM;

    }

    static class InjectableMembers {
        InjectableMember head;
        InjectableMember tail;

        InjectableMembers() {
        }

        void add(InjectableMember injectableMember) {
            if (this.head == null) {
                this.head = this.tail = injectableMember;
            } else {
                injectableMember.previous = this.tail;
                this.tail.next = injectableMember;
                this.tail = injectableMember;
            }
        }

        void remove(InjectableMember injectableMember) {
            if (injectableMember.previous != null) {
                injectableMember.previous.next = injectableMember.next;
            }
            if (injectableMember.next != null) {
                injectableMember.next.previous = injectableMember.previous;
            }
            if (this.head == injectableMember) {
                this.head = injectableMember.next;
            }
            if (this.tail == injectableMember) {
                this.tail = injectableMember.previous;
            }
        }

        boolean isEmpty() {
            return this.head == null;
        }
    }

    static class InjectableMethod
    extends InjectableMember {
        final Method method;
        boolean overrodeGuiceInject;

        InjectableMethod(TypeLiteral<?> typeLiteral, Method method, Annotation annotation) {
            super(typeLiteral, annotation);
            this.method = method;
        }

        @Override
        InjectionPoint toInjectionPoint() {
            return new InjectionPoint(this.declaringType, this.method, this.optional);
        }

        public boolean isFinal() {
            return Modifier.isFinal(this.method.getModifiers());
        }
    }

    static class InjectableField
    extends InjectableMember {
        final Field field;

        InjectableField(TypeLiteral<?> typeLiteral, Field field, Annotation annotation) {
            super(typeLiteral, annotation);
            this.field = field;
        }

        @Override
        InjectionPoint toInjectionPoint() {
            return new InjectionPoint(this.declaringType, this.field, this.optional);
        }
    }

    static abstract class InjectableMember {
        final TypeLiteral<?> declaringType;
        final boolean optional;
        final boolean specInject;
        InjectableMember previous;
        InjectableMember next;

        InjectableMember(TypeLiteral<?> typeLiteral, Annotation annotation) {
            this.declaringType = typeLiteral;
            if (annotation.annotationType() == jakarta.inject.Inject.class) {
                this.optional = false;
                this.specInject = true;
                return;
            }
            this.specInject = false;
            this.optional = ((Inject)annotation).optional();
        }

        abstract InjectionPoint toInjectionPoint();
    }
}

