/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.spi;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.plotsquared.google.Binder;
import com.plotsquared.google.MembersInjector;
import com.plotsquared.google.TypeLiteral;
import com.plotsquared.google.spi.Element;
import com.plotsquared.google.spi.ElementVisitor;
import com.plotsquared.google.spi.InjectionPoint;
import java.util.Set;

public final class MembersInjectorLookup<T>
implements Element {
    private final Object source;
    private final TypeLiteral<T> type;
    private MembersInjector<T> delegate;

    public MembersInjectorLookup(Object object, TypeLiteral<T> typeLiteral) {
        this.source = Preconditions.checkNotNull((Object)object, (Object)"source");
        this.type = (TypeLiteral)Preconditions.checkNotNull(typeLiteral, (Object)"type");
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public TypeLiteral<T> getType() {
        return this.type;
    }

    @Override
    public <T> T acceptVisitor(ElementVisitor<T> elementVisitor) {
        return elementVisitor.visit(this);
    }

    public void initializeDelegate(MembersInjector<T> membersInjector) {
        Preconditions.checkState((this.delegate == null ? 1 : 0) != 0, (Object)"delegate already initialized");
        this.delegate = (MembersInjector)Preconditions.checkNotNull(membersInjector, (Object)"delegate");
    }

    @Override
    public void applyTo(Binder binder) {
        this.initializeDelegate(binder.withSource(this.getSource()).getMembersInjector(this.type));
    }

    public MembersInjector<T> getDelegate() {
        return this.delegate;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return InjectionPoint.forInstanceMethodsAndFields(this.type);
    }

    public MembersInjector<T> getMembersInjector() {
        return new MembersInjector<T>(){

            @Override
            public void injectMembers(T t) {
                MembersInjector membersInjector = MembersInjectorLookup.this.delegate;
                if (membersInjector == null) {
                    throw new IllegalStateException("This MembersInjector cannot be used until the Injector has been created.");
                }
                membersInjector.injectMembers(t);
            }

            public String toString() {
                return "MembersInjector<" + MembersInjectorLookup.this.type + ">";
            }
        };
    }

    public boolean equals(Object object) {
        return object instanceof MembersInjectorLookup && ((MembersInjectorLookup)object).type.equals(this.type) && ((MembersInjectorLookup)object).source.equals(this.source);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.source});
    }
}

