/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.spi;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.plotsquared.google.Binder;
import com.plotsquared.google.internal.ErrorId;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.GenericErrorDetail;
import com.plotsquared.google.internal.GuiceInternal;
import com.plotsquared.google.internal.util.SourceProvider;
import com.plotsquared.google.spi.Element;
import com.plotsquared.google.spi.ElementVisitor;
import com.plotsquared.google.spi.ErrorDetail;
import java.io.Serializable;
import java.util.List;

public final class Message
implements Serializable,
Element {
    private final ErrorId errorId;
    private final ErrorDetail<?> errorDetail;
    private static final long serialVersionUID = 0L;

    public Message(GuiceInternal guiceInternal, ErrorId errorId, ErrorDetail<?> errorDetail) {
        Preconditions.checkNotNull((Object)guiceInternal);
        this.errorId = errorId;
        this.errorDetail = errorDetail;
    }

    private Message(ErrorId errorId, ErrorDetail<?> errorDetail) {
        this.errorId = errorId;
        this.errorDetail = errorDetail;
    }

    public Message(ErrorId errorId, List<Object> list, String string, Throwable throwable) {
        this.errorId = errorId;
        this.errorDetail = new GenericErrorDetail(errorId, string, list, throwable);
    }

    public Message(List<Object> list, String string, Throwable throwable) {
        this(ErrorId.OTHER, list, string, throwable);
    }

    public Message(String string, Throwable throwable) {
        this((List<Object>)ImmutableList.of(), string, throwable);
    }

    public Message(Object object, String string) {
        this((List<Object>)ImmutableList.of((Object)object), string, null);
    }

    public Message(String string) {
        this((List<Object>)ImmutableList.of(), string, null);
    }

    public ErrorDetail<?> getErrorDetail() {
        return this.errorDetail;
    }

    @Override
    public String getSource() {
        List<Object> list = this.errorDetail.getSources();
        return list.isEmpty() ? SourceProvider.UNKNOWN_SOURCE.toString() : Errors.convert(Iterables.getLast(list)).toString();
    }

    public List<Object> getSources() {
        return this.errorDetail.getSources();
    }

    public String getMessage() {
        return this.errorDetail.getMessage();
    }

    @Override
    public <T> T acceptVisitor(ElementVisitor<T> elementVisitor) {
        return elementVisitor.visit(this);
    }

    public Throwable getCause() {
        return this.errorDetail.getCause();
    }

    public String toString() {
        return this.errorDetail.getMessage();
    }

    public int hashCode() {
        return this.errorDetail.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Message)) {
            return false;
        }
        Message message = (Message)object;
        return this.errorDetail.equals(message.errorDetail);
    }

    @Override
    public void applyTo(Binder binder) {
        binder.withSource(this.getSource()).addError(this);
    }

    public Message withSource(List<Object> list) {
        return new Message(this.errorId, (ErrorDetail<?>)this.errorDetail.withSources(list));
    }

    private Object writeReplace() {
        Object[] objectArray = this.getSources().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = Errors.convert(objectArray[i]).toString();
        }
        return new Message(this.errorId, new GenericErrorDetail(this.errorId, this.getMessage(), (List<Object>)ImmutableList.copyOf((Object[])objectArray), this.getCause()));
    }
}

