/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.spi;

import com.google.common.base.Preconditions;
import com.plotsquared.google.Binder;
import com.plotsquared.google.TypeLiteral;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.matcher.Matcher;
import com.plotsquared.google.spi.Element;
import com.plotsquared.google.spi.ElementVisitor;
import com.plotsquared.google.spi.TypeConverter;

public final class TypeConverterBinding
implements Element {
    private final Object source;
    private final Matcher<? super TypeLiteral<?>> typeMatcher;
    private final TypeConverter typeConverter;

    public TypeConverterBinding(Object object, Matcher<? super TypeLiteral<?>> matcher, TypeConverter typeConverter) {
        this.source = Preconditions.checkNotNull((Object)object, (Object)"source");
        this.typeMatcher = (Matcher)Preconditions.checkNotNull(matcher, (Object)"typeMatcher");
        this.typeConverter = (TypeConverter)Preconditions.checkNotNull((Object)typeConverter, (Object)"typeConverter");
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public Matcher<? super TypeLiteral<?>> getTypeMatcher() {
        return this.typeMatcher;
    }

    public TypeConverter getTypeConverter() {
        return this.typeConverter;
    }

    @Override
    public <T> T acceptVisitor(ElementVisitor<T> elementVisitor) {
        return elementVisitor.visit(this);
    }

    @Override
    public void applyTo(Binder binder) {
        binder.withSource(this.getSource()).convertToTypes(this.typeMatcher, this.typeConverter);
    }

    public String toString() {
        return this.typeConverter + " which matches " + this.typeMatcher + " (bound at " + Errors.convert(this.source) + ")";
    }
}

