/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.prtree;

import com.plotsquared.prtree.DistanceCalculator;
import com.plotsquared.prtree.DistanceResult;
import com.plotsquared.prtree.MBR;
import com.plotsquared.prtree.MBRConverter;
import com.plotsquared.prtree.MinDistComparator;
import com.plotsquared.prtree.Node;
import com.plotsquared.prtree.NodeBase;
import com.plotsquared.prtree.NodeFilter;
import com.plotsquared.prtree.SimpleMBR;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;

class LeafNode<T>
extends NodeBase<T, T> {
    private static final Comparator<DistanceResult<?>> comp = new Comparator<DistanceResult<?>>(){

        @Override
        public int compare(DistanceResult<?> distanceResult, DistanceResult<?> distanceResult2) {
            return Double.compare(distanceResult.getDistance(), distanceResult2.getDistance());
        }
    };

    public LeafNode(Object[] objectArray) {
        super(objectArray);
    }

    public MBR getMBR(T t, MBRConverter<T> mBRConverter) {
        return new SimpleMBR(t, mBRConverter);
    }

    @Override
    public MBR computeMBR(MBRConverter<T> mBRConverter) {
        MBR mBR = null;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            mBR = this.getUnion(mBR, this.getMBR(this.get(i), mBRConverter));
        }
        return mBR;
    }

    @Override
    public void expand(MBR mBR, MBRConverter<T> mBRConverter, List<T> list, List<Node<T>> list2) {
        this.find(mBR, mBRConverter, list);
    }

    @Override
    public void find(MBR mBR, MBRConverter<T> mBRConverter, List<T> list) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            Object n2 = this.get(i);
            if (!mBR.intersects(n2, mBRConverter)) continue;
            list.add(n2);
        }
    }

    @Override
    public void nnExpand(DistanceCalculator<T> distanceCalculator, NodeFilter<T> nodeFilter, List<DistanceResult<T>> list, int n, PriorityQueue<Node<T>> priorityQueue, MinDistComparator<T, Node<T>> minDistComparator) {
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            Object n3 = this.get(i);
            if (!nodeFilter.accept(n3)) continue;
            double d = distanceCalculator.distanceTo(n3, minDistComparator.p);
            int n4 = list.size();
            if (n4 >= n && !(d < list.get(n4 - 1).getDistance())) continue;
            this.add(list, new DistanceResult(n3, d), n);
        }
    }

    private void add(List<DistanceResult<T>> list, DistanceResult<T> distanceResult, int n) {
        int n2;
        int n3 = list.size();
        if (n3 == n) {
            list.remove(n3 - 1);
        }
        if ((n2 = Collections.binarySearch(list, distanceResult, comp)) < 0) {
            n2 = -(n2 + 1);
        }
        list.add(n2, distanceResult);
    }
}

