/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.prtree;

import com.plotsquared.prtree.DataComparators;
import com.plotsquared.prtree.DistanceCalculator;
import com.plotsquared.prtree.DistanceResult;
import com.plotsquared.prtree.InternalNode;
import com.plotsquared.prtree.InternalNodeComparators;
import com.plotsquared.prtree.LeafBuilder;
import com.plotsquared.prtree.LeafNode;
import com.plotsquared.prtree.MBR;
import com.plotsquared.prtree.MBR2D;
import com.plotsquared.prtree.MBRConverter;
import com.plotsquared.prtree.NearestNeighbour;
import com.plotsquared.prtree.Node;
import com.plotsquared.prtree.NodeFactory;
import com.plotsquared.prtree.NodeFilter;
import com.plotsquared.prtree.PointND;
import com.plotsquared.prtree.SimpleMBR;
import com.plotsquared.prtree.SimpleMBR2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PRTree<T> {
    private MBRConverter<T> converter;
    private int branchFactor;
    private Node<T> root;
    private int numLeafs;
    private int height;

    public PRTree(MBRConverter<T> mBRConverter, int n) {
        this.converter = mBRConverter;
        this.branchFactor = n;
    }

    public void load(Collection<? extends T> collection) {
        if (this.root != null) {
            throw new IllegalStateException("Tree is already loaded");
        }
        this.numLeafs = collection.size();
        LeafBuilder leafBuilder = new LeafBuilder(this.converter.getDimensions(), this.branchFactor);
        ArrayList arrayList = new ArrayList(this.estimateSize(this.numLeafs));
        leafBuilder.buildLeafs(collection, new DataComparators<T>(this.converter), new LeafNodeFactory(), arrayList);
        this.height = 1;
        ArrayList arrayList2 = arrayList;
        while (arrayList2.size() > this.branchFactor) {
            ++this.height;
            ArrayList arrayList3 = new ArrayList(this.estimateSize(arrayList2.size()));
            leafBuilder.buildLeafs(arrayList2, new InternalNodeComparators<T>(this.converter), new InternalNodeFactory(), arrayList3);
            arrayList2 = arrayList3;
        }
        this.setRoot(arrayList2);
    }

    private int estimateSize(int n) {
        return (int)(1.0 / (double)(this.branchFactor - 1) * (double)n);
    }

    private <N extends Node<T>> void setRoot(List<N> list) {
        if (list.size() == 0) {
            this.root = new InternalNode(new Object[0]);
        } else if (list.size() == 1) {
            this.root = (Node)list.get(0);
        } else {
            ++this.height;
            this.root = new InternalNode(list.toArray());
        }
    }

    public MBR2D getMBR2D() {
        MBR mBR = this.getMBR();
        if (mBR == null) {
            return null;
        }
        return new SimpleMBR2D(mBR.getMin(0), mBR.getMin(1), mBR.getMax(0), mBR.getMax(1));
    }

    public MBR getMBR() {
        return this.root.getMBR(this.converter);
    }

    public int getNumberOfLeaves() {
        return this.numLeafs;
    }

    public boolean isEmpty() {
        return this.numLeafs == 0;
    }

    public int getHeight() {
        return this.height;
    }

    public void find(double d, double d2, double d3, double d4, List<T> list) {
        this.find(new SimpleMBR(d, d3, d2, d4), list);
    }

    public void find(MBR mBR, List<T> list) {
        this.validateRect(mBR);
        this.root.find(mBR, this.converter, list);
    }

    public Iterable<T> find(double d, double d2, double d3, double d4) {
        return this.find(new SimpleMBR(d, d3, d2, d4));
    }

    public Iterable<T> find(final MBR mBR) {
        this.validateRect(mBR);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Finder(mBR);
            }
        };
    }

    private void validateRect(MBR mBR) {
        for (int i = 0; i < this.converter.getDimensions(); ++i) {
            double d;
            double d2 = mBR.getMax(i);
            if (!(d2 < (d = mBR.getMin(i)))) continue;
            throw new IllegalArgumentException("max: " + d2 + " < min: " + d + ", axis: " + i + ", query: " + mBR);
        }
    }

    public List<DistanceResult<T>> nearestNeighbour(DistanceCalculator<T> distanceCalculator, NodeFilter<T> nodeFilter, int n, PointND pointND) {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        NearestNeighbour<T> nearestNeighbour = new NearestNeighbour<T>(this.converter, nodeFilter, n, this.root, distanceCalculator, pointND);
        return nearestNeighbour.find();
    }

    private class Finder
    implements Iterator<T> {
        private MBR mbr;
        private List<T> ts = new ArrayList();
        private List<Node<T>> toVisit = new ArrayList();
        private T next;
        private int visitedNodes = 0;
        private int dataNodesVisited = 0;

        public Finder(MBR mBR) {
            this.mbr = mBR;
            this.toVisit.add(PRTree.this.root);
            this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            Object t = this.next;
            this.findNext();
            return t;
        }

        private void findNext() {
            while (this.ts.isEmpty() && !this.toVisit.isEmpty()) {
                Node node = this.toVisit.remove(this.toVisit.size() - 1);
                ++this.visitedNodes;
                node.expand(this.mbr, PRTree.this.converter, this.ts, this.toVisit);
            }
            if (this.ts.isEmpty()) {
                this.next = null;
            } else {
                this.next = this.ts.remove(this.ts.size() - 1);
                ++this.dataNodesVisited;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not implemented");
        }
    }

    private class InternalNodeFactory
    implements NodeFactory<InternalNode<T>> {
        private InternalNodeFactory() {
        }

        @Override
        public InternalNode<T> create(Object[] objectArray) {
            return new InternalNode(objectArray);
        }
    }

    private class LeafNodeFactory
    implements NodeFactory<LeafNode<T>> {
        private LeafNodeFactory() {
        }

        @Override
        public LeafNode<T> create(Object[] objectArray) {
            return new LeafNode(objectArray);
        }
    }
}

