/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.prtree;

import com.plotsquared.prtree.MBR2D;

public class SimpleMBR2D
implements MBR2D {
    private final double xmin;
    private final double ymin;
    private final double xmax;
    private final double ymax;

    public SimpleMBR2D(double d, double d2, double d3, double d4) {
        this.xmin = d;
        this.ymin = d2;
        this.xmax = d3;
        this.ymax = d4;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{xmin: " + this.xmin + ", ymin: " + this.ymin + ", xmax: " + this.xmax + ", ymax: " + this.ymax + "}";
    }

    @Override
    public double getMinX() {
        return this.xmin;
    }

    @Override
    public double getMinY() {
        return this.ymin;
    }

    @Override
    public double getMaxX() {
        return this.xmax;
    }

    @Override
    public double getMaxY() {
        return this.ymax;
    }

    @Override
    public MBR2D union(MBR2D mBR2D) {
        double d = Math.min(this.xmin, mBR2D.getMinX());
        double d2 = Math.min(this.ymin, mBR2D.getMinY());
        double d3 = Math.max(this.xmax, mBR2D.getMaxX());
        double d4 = Math.max(this.ymax, mBR2D.getMaxY());
        return new SimpleMBR2D(d, d2, d3, d4);
    }

    @Override
    public boolean intersects(MBR2D mBR2D) {
        return !(mBR2D.getMaxX() < this.xmin || mBR2D.getMinX() > this.xmax || mBR2D.getMaxY() < this.ymin || mBR2D.getMinY() > this.ymax);
    }
}

