/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.squirrelid.squirrelid.resolver;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.plotsquared.core.annotation.Nullable;
import com.plotsquared.squirrelid.squirrelid.Profile;
import com.plotsquared.squirrelid.squirrelid.resolver.ProfileService;
import com.plotsquared.squirrelid.squirrelid.util.HttpRequest;
import com.plotsquared.squirrelid.squirrelid.util.UUIDs;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpRepositoryService
implements ProfileService {
    public static final String MINECRAFT_AGENT = "minecraft";
    private static final Logger log = Logger.getLogger(HttpRepositoryService.class.getCanonicalName());
    private static final int MAX_NAMES_PER_REQUEST = 100;
    private final URL profilesURL;
    private final Function<UUID, URL> nameHistoryUrlCreator;
    private int maxRetries = 5;
    private long retryDelay = 50L;

    public HttpRepositoryService(String string) {
        Preconditions.checkNotNull((Object)string);
        this.profilesURL = HttpRequest.url("https://api.mojang.com/profiles/" + string);
        this.nameHistoryUrlCreator = uUID -> HttpRequest.url("https://sessionserver.mojang.com/session/minecraft/profile/" + UUIDs.stripDashes(uUID.toString()));
    }

    @Nullable
    private static Profile decodeProfileResult(Object object) {
        try {
            if (object instanceof Map) {
                Map map = (Map)object;
                Object v = map.get("id");
                Object v2 = map.get("name");
                if (v != null && v2 != null) {
                    UUID uUID = UUID.fromString(UUIDs.addDashes(String.valueOf(v)));
                    String string = String.valueOf(v2);
                    return new Profile(uUID, string);
                }
            }
        }
        catch (ClassCastException | IllegalArgumentException runtimeException) {
            log.log(Level.WARNING, "Got invalid value from UUID lookup service", runtimeException);
        }
        return null;
    }

    public static ProfileService forMinecraft() {
        return new HttpRepositoryService(MINECRAFT_AGENT);
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int n) {
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0, (Object)"maxRetries must be >= 0");
        this.maxRetries = n;
    }

    public long getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(long l) {
        this.retryDelay = l;
    }

    @Override
    public int getIdealRequestLimit() {
        return 100;
    }

    @Override
    @Nullable
    public Profile findByName(String string) {
        ImmutableList<Profile> immutableList = this.findAllByName((Iterable<String>)ImmutableList.of((Object)string));
        if (!immutableList.isEmpty()) {
            return (Profile)immutableList.get(0);
        }
        return null;
    }

    @Override
    public ImmutableList<Profile> findAllByName(Iterable<String> iterable) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (List list : Iterables.partition(iterable, (int)100)) {
            builder.addAll(this.queryByName(list));
        }
        return builder.build();
    }

    @Override
    public void findAllByName(Iterable<String> iterable, Predicate<Profile> predicate) {
        for (List list : Iterables.partition(iterable, (int)100)) {
            for (Profile profile : this.queryByName(list)) {
                predicate.test(profile);
            }
        }
    }

    @Override
    @Nullable
    public Profile findByUuid(UUID uUID) {
        ImmutableList<Profile> immutableList = this.findAllByUuid((Iterable<UUID>)ImmutableList.of((Object)uUID));
        if (!immutableList.isEmpty()) {
            return (Profile)immutableList.get(0);
        }
        return null;
    }

    @Override
    public ImmutableList<Profile> findAllByUuid(Iterable<UUID> iterable) {
        return ImmutableList.copyOf(this.queryByUuid(iterable));
    }

    @Override
    public void findAllByUuid(Iterable<UUID> iterable, Predicate<Profile> predicate) {
        for (Profile profile : this.queryByUuid(iterable)) {
            predicate.test(profile);
        }
    }

    protected ImmutableList<Profile> queryByName(Iterable<String> iterable) {
        Object object;
        ArrayList<Profile> arrayList = new ArrayList<Profile>();
        int n = this.maxRetries;
        long l = this.retryDelay;
        while (true) {
            try {
                object = HttpRequest.post(this.profilesURL).bodyJson(iterable).execute().returnContent().asJson();
            }
            catch (IOException iOException) {
                if (n == 0) {
                    throw iOException;
                }
                log.log(Level.WARNING, "Failed to query profile service -- retrying...", iOException);
                Thread.sleep(l);
                l *= 2L;
                --n;
                continue;
            }
            break;
        }
        if (object instanceof Iterable) {
            for (Object t : (Iterable)object) {
                Profile profile = HttpRepositoryService.decodeProfileResult(t);
                if (profile == null) continue;
                arrayList.add(profile);
            }
        }
        return ImmutableList.copyOf(arrayList);
    }

    protected ImmutableList<Profile> queryByUuid(Iterable<UUID> iterable) {
        ArrayList<Profile> arrayList = new ArrayList<Profile>();
        int n = this.maxRetries;
        long l = this.retryDelay;
        block2: for (UUID uUID : iterable) {
            while (true) {
                try {
                    Map map;
                    Object v;
                    Object object = HttpRequest.get(this.nameHistoryUrlCreator.apply(uUID)).execute().returnContent().asJson();
                    if (!(object instanceof Map) || (v = (map = (Map)object).get("name")) == null) continue block2;
                    arrayList.add(new Profile(uUID, String.valueOf(v)));
                    continue block2;
                }
                catch (IOException iOException) {
                    if (n == 0) {
                        throw iOException;
                    }
                    log.log(Level.WARNING, "Failed to query name history service -- retrying...", iOException);
                    Thread.sleep(l);
                    l *= 2L;
                    --n;
                    continue;
                }
                break;
            }
        }
        return ImmutableList.copyOf(arrayList);
    }
}

