/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.easysql.action;

import cc.carm.lib.easysql.api.SQLAction;
import cc.carm.lib.easysql.api.function.SQLExceptionHandler;
import cc.carm.lib.easysql.api.function.SQLHandler;
import cc.carm.lib.easysql.manager.SQLManagerImpl;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractSQLAction<T>
implements SQLAction<T> {
    @NotNull
    protected final String sqlContent;
    @NotNull
    private final SQLManagerImpl sqlManager;
    @NotNull
    private final UUID uuid;
    private final long createNanoTime;

    public AbstractSQLAction(@NotNull SQLManagerImpl sQLManagerImpl, @NotNull String string) {
        this(sQLManagerImpl, string, System.nanoTime());
    }

    public AbstractSQLAction(@NotNull SQLManagerImpl sQLManagerImpl, @NotNull String string, @NotNull UUID uUID) {
        this(sQLManagerImpl, string, uUID, System.nanoTime());
    }

    public AbstractSQLAction(@NotNull SQLManagerImpl sQLManagerImpl, @NotNull String string, long l) {
        this(sQLManagerImpl, string, UUID.randomUUID(), l);
    }

    public AbstractSQLAction(@NotNull SQLManagerImpl sQLManagerImpl, @NotNull String string, @NotNull UUID uUID, long l) {
        Objects.requireNonNull(sQLManagerImpl);
        Objects.requireNonNull(string);
        Objects.requireNonNull(uUID);
        this.sqlManager = sQLManagerImpl;
        this.sqlContent = string;
        this.uuid = uUID;
        this.createNanoTime = l;
    }

    @Override
    @NotNull
    public UUID getActionUUID() {
        return this.uuid;
    }

    @Override
    @NotNull
    public String getShortID() {
        return this.getActionUUID().toString().substring(0, 8);
    }

    @Override
    public long getCreateTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.createNanoTime, TimeUnit.NANOSECONDS);
    }

    @Override
    @NotNull
    public String getSQLContent() {
        return this.sqlContent.trim();
    }

    @Override
    @NotNull
    public SQLManagerImpl getManager() {
        return this.sqlManager;
    }

    protected void debugMessage(List<Object[]> list) {
        if (this.getManager().isDebugMode()) {
            try {
                this.getManager().getDebugHandler().beforeExecute(this, list);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void executeAsync(SQLHandler<T> sQLHandler, SQLExceptionHandler sQLExceptionHandler) {
        this.getManager().getExecutorPool().submit(() -> {
            try {
                Object t = this.execute();
                if (sQLHandler != null) {
                    sQLHandler.accept(t);
                }
            }
            catch (SQLException sQLException) {
                this.handleException(sQLExceptionHandler, sQLException);
            }
        });
    }
}

