/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.easysql.api.function;

import cc.carm.lib.easysql.api.SQLAction;
import cc.carm.lib.easysql.api.SQLQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public interface SQLDebugHandler {
    public void beforeExecute(@NotNull SQLAction<?> var1, @NotNull List<@Nullable Object[]> var2);

    public void afterQuery(@NotNull SQLQuery var1, long var2, long var4);

    default public String parseParams(@Nullable Object[] params) {
        if (params == null) {
            return "<#NULL>";
        }
        if (params.length == 0) {
            return "<#EMPTY>";
        }
        ArrayList<String> paramsString = new ArrayList<String>();
        for (Object param : params) {
            if (param == null) {
                paramsString.add("NULL");
                continue;
            }
            paramsString.add(param.toString());
        }
        return String.join((CharSequence)", ", paramsString);
    }

    public static SQLDebugHandler defaultHandler(final Logger logger) {
        return new SQLDebugHandler(){

            @Override
            public void beforeExecute(@NotNull SQLAction<?> sQLAction, @NotNull List<@Nullable Object[]> list) {
                int n;
                logger.info("\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
                logger.info("\u2523# ActionUUID: {}", (Object)sQLAction.getActionUUID());
                logger.info("\u2523# ActionType: {}", (Object)sQLAction.getClass().getSimpleName());
                if (sQLAction.getSQLContents().size() == 1) {
                    logger.info("\u2523# SQLContent: {}", (Object)sQLAction.getSQLContents().get(0));
                } else {
                    logger.info("\u2523# SQLContents: ");
                    n = 0;
                    for (String objectArray : sQLAction.getSQLContents()) {
                        logger.info("\u2503 - [{}] {}", (Object)(++n), (Object)objectArray);
                    }
                }
                if (list.size() == 1) {
                    Object[] objectArray = list.get(0);
                    if (objectArray != null) {
                        logger.info("\u2523# SQLParam: {}", (Object)this.parseParams(objectArray));
                    }
                } else if (list.size() > 1) {
                    logger.info("\u2523# SQLParams: ");
                    n = 0;
                    for (Object[] objectArray : list) {
                        logger.info("\u2503 - [{}] {}", (Object)(++n), (Object)this.parseParams(objectArray));
                    }
                }
                logger.info("\u2523# CreateTime: {}", (Object)sQLAction.getCreateTime(TimeUnit.MILLISECONDS));
                logger.info("\u2517\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
            }

            @Override
            public void afterQuery(@NotNull SQLQuery sQLQuery, long l, long l2) {
                logger.info("\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
                logger.info("\u2523# ActionUUID: {}", (Object)sQLQuery.getAction().getActionUUID());
                logger.info("\u2523# SQLContent: {}", (Object)sQLQuery.getSQLContent());
                logger.info("\u2523# CloseTime: {}  (cost {} ms)", (Object)TimeUnit.NANOSECONDS.toMillis(l2), (Object)((double)(l2 - l) / 1000000.0));
                logger.info("\u2517\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
            }
        };
    }
}

