/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.easysql.api.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimeDateUtils {
    public static final DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static String getCurrentTime() {
        return TimeDateUtils.getTimeString(System.currentTimeMillis());
    }

    public static String getTimeString(long l) {
        return TimeDateUtils.getFormat().format(new Date(l));
    }

    public static String getTimeString(Date date) {
        return TimeDateUtils.getFormat().format(date);
    }

    public static long parseTimeMillis(String string) {
        if (string == null) {
            return -1L;
        }
        try {
            return format.parse(string).getTime();
        }
        catch (ParseException parseException) {
            return -1L;
        }
    }

    public static Date getTimeDate(String string) {
        if (string == null) {
            return null;
        }
        try {
            return format.parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static String toDHMSStyle(long l) {
        long l2 = l / 86400L;
        long l3 = l % 86400L / 3600L;
        long l4 = l % 3600L / 60L;
        long l5 = l % 60L;
        String string = l2 > 0L ? l2 + "\u5929" + (l3 > 0L ? l3 + "\u5c0f\u65f6" : "") + (l4 > 0L ? l4 + "\u5206\u949f" : "") + (l5 > 0L ? l5 + "\u79d2" : "") : (l3 > 0L ? l3 + "\u5c0f\u65f6" + (l4 > 0L ? l4 + "\u5206\u949f" : "") + (l5 > 0L ? l5 + "\u79d2" : "") : (l4 > 0L ? l4 + "\u5206\u949f" + (l5 > 0L ? l5 + "\u79d2" : "") : l5 + "\u79d2"));
        return string;
    }

    public static DateFormat getFormat() {
        return format;
    }
}

