/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.easysql.builder.impl;

import cc.carm.lib.easysql.api.SQLAction;
import cc.carm.lib.easysql.api.SQLBuilder;
import cc.carm.lib.easysql.api.builder.ConditionalBuilder;
import cc.carm.lib.easysql.builder.AbstractSQLBuilder;
import cc.carm.lib.easysql.manager.SQLManagerImpl;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConditionalBuilder<B extends ConditionalBuilder<B, T>, T extends SQLAction<?>>
extends AbstractSQLBuilder
implements ConditionalBuilder<B, T> {
    ArrayList<String> conditionSQLs = new ArrayList();
    ArrayList<Object> conditionParams = new ArrayList();
    int limit = -1;

    public AbstractConditionalBuilder(@NotNull SQLManagerImpl sQLManagerImpl) {
        super(sQLManagerImpl);
    }

    protected abstract B getThis();

    @Override
    public B setConditions(@Nullable String string) {
        this.conditionSQLs = new ArrayList();
        this.conditionParams = new ArrayList();
        if (string != null) {
            this.conditionSQLs.add(string);
        }
        return this.getThis();
    }

    @Override
    public B setConditions(LinkedHashMap<@NotNull String, @Nullable Object> linkedHashMap) {
        linkedHashMap.forEach(this::addCondition);
        return this.getThis();
    }

    @Override
    public B addCondition(@Nullable String string) {
        this.conditionSQLs.add(string);
        return this.getThis();
    }

    @Override
    public B addCondition(@NotNull String string, @Nullable Object object) {
        Objects.requireNonNull(string, "columnName could not be null");
        if (object == null) {
            return this.addCondition(SQLBuilder.withBackQuote(string) + " IS NULL");
        }
        return this.addCondition(string, "=", object);
    }

    @Override
    public B addCondition(@NotNull String string, @NotNull String string2, @Nullable Object object) {
        Objects.requireNonNull(string, "columnName could not be null");
        Objects.requireNonNull(string2, "operator could not be null (e.g. > or = or <) ");
        this.addCondition(SQLBuilder.withBackQuote(string) + " " + string2 + " ?");
        this.conditionParams.add(object);
        return this.getThis();
    }

    @Override
    public B addCondition(@NotNull String[] stringArray, @Nullable Object[] objectArray) {
        Objects.requireNonNull(stringArray, "columnName could not be null");
        if (objectArray == null || stringArray.length != objectArray.length) {
            throw new RuntimeException("queryNames are not match with queryValues");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.addCondition(stringArray[i], objectArray[i]);
        }
        return this.getThis();
    }

    @Override
    public B addNotNullCondition(@NotNull String string) {
        Objects.requireNonNull(string, "columnName could not be null");
        return this.addCondition(SQLBuilder.withBackQuote(string) + " IS NOT NULL");
    }

    @Override
    public B addTimeCondition(@NotNull String string, @Nullable Date date, @Nullable Date date2) {
        Objects.requireNonNull(string, "columnName could not be null");
        if (date == null && date2 == null) {
            return this.getThis();
        }
        if (date != null) {
            this.addCondition(SQLBuilder.withBackQuote(string) + " BETWEEN ? AND ?");
            this.conditionParams.add(date);
            if (date2 != null) {
                this.conditionParams.add(date2);
            } else if (date instanceof java.sql.Date) {
                this.conditionParams.add(new java.sql.Date(System.currentTimeMillis()));
            } else if (date instanceof Time) {
                this.conditionParams.add(new Time(System.currentTimeMillis()));
            } else {
                this.conditionParams.add(new Timestamp(System.currentTimeMillis()));
            }
        } else {
            this.addCondition(string, "<=", date2);
        }
        return this.getThis();
    }

    @Override
    public B setLimit(int n) {
        this.limit = n;
        return this.getThis();
    }

    protected String buildConditionSQL() {
        if (!this.conditionSQLs.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("WHERE").append(" ");
            Iterator<String> iterator = this.conditionSQLs.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(iterator.next());
                if (!iterator.hasNext()) continue;
                stringBuilder.append(" AND ");
            }
            return stringBuilder.toString().trim();
        }
        return null;
    }

    protected String buildLimitSQL() {
        return this.limit > 0 ? "LIMIT " + this.limit : "";
    }

    protected ArrayList<Object> getConditionParams() {
        return this.conditionParams;
    }

    protected boolean hasConditions() {
        return this.conditionSQLs != null && !this.conditionSQLs.isEmpty();
    }

    protected boolean hasConditionParams() {
        return this.hasConditions() && this.getConditionParams() != null && !this.getConditionParams().isEmpty();
    }
}

