/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.easysql.builder.impl;

import cc.carm.lib.easysql.action.SQLUpdateActionImpl;
import cc.carm.lib.easysql.api.SQLBuilder;
import cc.carm.lib.easysql.api.action.SQLUpdateAction;
import cc.carm.lib.easysql.api.builder.TableCreateBuilder;
import cc.carm.lib.easysql.api.enums.ForeignKeyRule;
import cc.carm.lib.easysql.api.enums.IndexType;
import cc.carm.lib.easysql.api.enums.NumberType;
import cc.carm.lib.easysql.builder.AbstractSQLBuilder;
import cc.carm.lib.easysql.manager.SQLManagerImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableCreateBuilderImpl
extends AbstractSQLBuilder
implements TableCreateBuilder {
    @NotNull
    protected final String tableName;
    @NotNull
    final List<String> indexes = new ArrayList<String>();
    @NotNull
    final List<String> foreignKeys = new ArrayList<String>();
    @NotNull
    List<String> columns = new ArrayList<String>();
    @NotNull
    String tableSettings = this.defaultTablesSettings();
    @Nullable
    String tableComment;

    public TableCreateBuilderImpl(SQLManagerImpl sQLManagerImpl, @NotNull String string) {
        super(sQLManagerImpl);
        this.tableName = string;
    }

    protected static String buildIndexSettings(@NotNull IndexType indexType, @Nullable String string, @NotNull String string2, String ... stringArray) {
        Objects.requireNonNull(indexType, "indexType could not be null");
        Objects.requireNonNull(string2, "column names could not be null");
        Objects.requireNonNull(stringArray, "column names could not be null");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(indexType.getName()).append(" ");
        if (string != null) {
            stringBuilder.append(SQLBuilder.withBackQuote(string));
        }
        stringBuilder.append("(");
        stringBuilder.append(SQLBuilder.withBackQuote(string2));
        if (stringArray.length > 0) {
            stringBuilder.append(", ");
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuilder.append(SQLBuilder.withBackQuote(stringArray[i]));
                if (i == stringArray.length - 1) continue;
                stringBuilder.append(", ");
            }
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    @NotNull
    public String getTableName() {
        return this.tableName;
    }

    @Override
    @NotNull
    public String getTableSettings() {
        return this.tableSettings;
    }

    @Override
    public SQLUpdateAction<Integer> build() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CREATE TABLE IF NOT EXISTS ").append(SQLBuilder.withBackQuote(this.tableName));
        stringBuilder.append("(");
        stringBuilder.append(String.join((CharSequence)", ", this.columns));
        if (this.indexes.size() > 0) {
            stringBuilder.append(", ");
            stringBuilder.append(String.join((CharSequence)", ", this.indexes));
        }
        if (this.foreignKeys.size() > 0) {
            stringBuilder.append(", ");
            stringBuilder.append(String.join((CharSequence)", ", this.foreignKeys));
        }
        stringBuilder.append(") ").append(this.getTableSettings());
        if (this.tableComment != null) {
            stringBuilder.append(" COMMENT ").append(SQLBuilder.withQuote(this.tableComment));
        }
        return new SQLUpdateActionImpl<Integer>(this.getManager(), Integer.class, stringBuilder.toString());
    }

    @Override
    public TableCreateBuilder addColumn(@NotNull String string) {
        Objects.requireNonNull(string, "column could not be null");
        this.columns.add(string);
        return this;
    }

    @Override
    public TableCreateBuilder addAutoIncrementColumn(@NotNull String string, @Nullable NumberType numberType, boolean bl, boolean bl2) {
        return this.addColumn(string, (numberType == null ? NumberType.INT : numberType).name() + (bl2 ? " UNSIGNED " : " ") + "NOT NULL AUTO_INCREMENT " + (bl ? "PRIMARY KEY" : "UNIQUE KEY"));
    }

    @Override
    public TableCreateBuilder setIndex(@NotNull IndexType indexType, @Nullable String string, @NotNull String string2, String ... stringArray) {
        Objects.requireNonNull(string2, "columnName could not be null");
        this.indexes.add(TableCreateBuilderImpl.buildIndexSettings(indexType, string, string2, stringArray));
        return this;
    }

    @Override
    public TableCreateBuilder addForeignKey(@NotNull String string, @Nullable String string2, @NotNull String string3, @NotNull String string4, @Nullable ForeignKeyRule foreignKeyRule, @Nullable ForeignKeyRule foreignKeyRule2) {
        Objects.requireNonNull(string, "tableColumn could not be null");
        Objects.requireNonNull(string3, "foreignTable could not be null");
        Objects.requireNonNull(string4, "foreignColumn could not be null");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CONSTRAINT ");
        if (string2 == null) {
            stringBuilder.append(SQLBuilder.withBackQuote("fk_" + string + "_" + string3));
        } else {
            stringBuilder.append(SQLBuilder.withBackQuote(string2));
        }
        stringBuilder.append(" ");
        stringBuilder.append("FOREIGN KEY (").append(SQLBuilder.withBackQuote(string)).append(") ");
        stringBuilder.append("REFERENCES ").append(SQLBuilder.withBackQuote(string3)).append("(").append(SQLBuilder.withBackQuote(string4)).append(")");
        if (foreignKeyRule != null) {
            stringBuilder.append(" ON UPDATE ").append(foreignKeyRule.getRuleName());
        }
        if (foreignKeyRule2 != null) {
            stringBuilder.append(" ON DELETE ").append(foreignKeyRule2.getRuleName());
        }
        this.foreignKeys.add(stringBuilder.toString());
        return this;
    }

    @Override
    public TableCreateBuilder setColumns(String ... stringArray) {
        Objects.requireNonNull(stringArray, "columns could not be null");
        this.columns = Arrays.asList(stringArray);
        return this;
    }

    @Override
    public TableCreateBuilder setTableSettings(@NotNull String string) {
        Objects.requireNonNull(string, "settings could not be null");
        this.tableSettings = string;
        return this;
    }

    @Override
    public TableCreateBuilder setTableComment(@Nullable String string) {
        this.tableComment = string;
        return this;
    }
}

