/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.easysql.builder.impl;

import cc.carm.lib.easysql.action.query.PreparedQueryActionImpl;
import cc.carm.lib.easysql.api.SQLBuilder;
import cc.carm.lib.easysql.api.action.query.PreparedQueryAction;
import cc.carm.lib.easysql.api.builder.TableQueryBuilder;
import cc.carm.lib.easysql.builder.impl.AbstractConditionalBuilder;
import cc.carm.lib.easysql.manager.SQLManagerImpl;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableQueryBuilderImpl
extends AbstractConditionalBuilder<TableQueryBuilder, PreparedQueryAction>
implements TableQueryBuilder {
    @NotNull
    protected final String tableName;
    String[] columns;
    @Nullable
    String orderBy;
    int[] pageLimit;

    public TableQueryBuilderImpl(@NotNull SQLManagerImpl sQLManagerImpl, @NotNull String string) {
        super(sQLManagerImpl);
        this.tableName = string;
    }

    @Override
    public PreparedQueryActionImpl build() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT").append(" ");
        if (this.columns == null || this.columns.length < 1) {
            stringBuilder.append("*");
        } else {
            for (int i = 0; i < this.columns.length; ++i) {
                String string = this.columns[i];
                stringBuilder.append(SQLBuilder.withBackQuote(string));
                if (i == this.columns.length - 1) continue;
                stringBuilder.append(",");
            }
        }
        stringBuilder.append(" ").append("FROM").append(" ").append(SQLBuilder.withBackQuote(this.tableName));
        if (this.hasConditions()) {
            stringBuilder.append(" ").append(this.buildConditionSQL());
        }
        if (this.orderBy != null) {
            stringBuilder.append(" ").append(this.orderBy);
        }
        if (this.pageLimit != null && this.pageLimit.length == 2) {
            stringBuilder.append(" LIMIT ").append(this.pageLimit[0]).append(",").append(this.pageLimit[1]);
        } else if (this.limit > 0) {
            stringBuilder.append(" ").append(this.buildLimitSQL());
        }
        return new PreparedQueryActionImpl(this.getManager(), stringBuilder.toString()).setParams(this.hasConditionParams() ? this.getConditionParams() : null);
    }

    @Override
    @NotNull
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public TableQueryBuilderImpl selectColumns(String ... stringArray) {
        Objects.requireNonNull(stringArray, "columnNames could not be null");
        this.columns = stringArray;
        return this;
    }

    @Override
    public TableQueryBuilder orderBy(@NotNull String string, boolean bl) {
        Objects.requireNonNull(string, "columnName could not be null");
        this.orderBy = "ORDER BY " + SQLBuilder.withBackQuote(string) + " " + (bl ? "ASC" : "DESC");
        return this;
    }

    @Override
    public TableQueryBuilder setPageLimit(int n, int n2) {
        this.pageLimit = new int[]{n, n2};
        return this;
    }

    @Override
    protected TableQueryBuilderImpl getThis() {
        return this;
    }
}

