/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.easysql.hikari.metrics.prometheus;

import cc.carm.lib.easysql.hikari.metrics.IMetricsTracker;
import cc.carm.lib.easysql.hikari.metrics.MetricsTrackerFactory;
import cc.carm.lib.easysql.hikari.metrics.PoolStats;
import cc.carm.lib.easysql.hikari.metrics.prometheus.HikariCPCollector;
import cc.carm.lib.easysql.hikari.metrics.prometheus.PrometheusMetricsTracker;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PrometheusMetricsTrackerFactory
implements MetricsTrackerFactory {
    private static final Map<CollectorRegistry, RegistrationStatus> registrationStatuses = new ConcurrentHashMap<CollectorRegistry, RegistrationStatus>();
    private final HikariCPCollector collector = new HikariCPCollector();
    private final CollectorRegistry collectorRegistry;

    public PrometheusMetricsTrackerFactory() {
        this(CollectorRegistry.defaultRegistry);
    }

    public PrometheusMetricsTrackerFactory(CollectorRegistry collectorRegistry) {
        this.collectorRegistry = collectorRegistry;
    }

    @Override
    public IMetricsTracker create(String string, PoolStats poolStats) {
        this.registerCollector(this.collector, this.collectorRegistry);
        this.collector.add(string, poolStats);
        return new PrometheusMetricsTracker(string, this.collectorRegistry, this.collector);
    }

    private void registerCollector(Collector collector, CollectorRegistry collectorRegistry) {
        if (registrationStatuses.putIfAbsent(collectorRegistry, RegistrationStatus.REGISTERED) == null) {
            collector.register(collectorRegistry);
        }
    }

    static enum RegistrationStatus {
        REGISTERED;

    }
}

