/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.easysql.query;

import cc.carm.lib.easysql.action.query.QueryActionImpl;
import cc.carm.lib.easysql.api.SQLQuery;
import cc.carm.lib.easysql.manager.SQLManagerImpl;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.TimeUnit;

public class SQLQueryImpl
implements SQLQuery {
    protected final long executeTime;
    protected final SQLManagerImpl sqlManager;
    protected final Connection connection;
    protected final Statement statement;
    protected final ResultSet resultSet;
    protected QueryActionImpl queryAction;

    public SQLQueryImpl(SQLManagerImpl sQLManagerImpl, QueryActionImpl queryActionImpl, Connection connection, Statement statement, ResultSet resultSet) {
        this(sQLManagerImpl, queryActionImpl, connection, statement, resultSet, System.nanoTime());
    }

    public SQLQueryImpl(SQLManagerImpl sQLManagerImpl, QueryActionImpl queryActionImpl, Connection connection, Statement statement, ResultSet resultSet, long l) {
        this.executeTime = l;
        this.sqlManager = sQLManagerImpl;
        this.queryAction = queryActionImpl;
        this.connection = connection;
        this.statement = statement;
        this.resultSet = resultSet;
    }

    @Override
    public long getExecuteTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.executeTime, TimeUnit.NANOSECONDS);
    }

    @Override
    public SQLManagerImpl getManager() {
        return this.sqlManager;
    }

    @Override
    public QueryActionImpl getAction() {
        return this.queryAction;
    }

    @Override
    public ResultSet getResultSet() {
        return this.resultSet;
    }

    @Override
    public String getSQLContent() {
        return this.getAction().getSQLContent();
    }

    @Override
    public void close() {
        try {
            if (this.getResultSet() != null && !this.getResultSet().isClosed()) {
                this.getResultSet().close();
            }
            if (this.getStatement() != null && !this.getStatement().isClosed()) {
                this.getStatement().close();
            }
            if (this.getConnection() != null && !this.getConnection().isClosed()) {
                this.getConnection().close();
            }
            if (this.getManager().isDebugMode()) {
                try {
                    this.getManager().getDebugHandler().afterQuery(this, this.getExecuteTime(TimeUnit.NANOSECONDS), System.nanoTime());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.getManager().getActiveQuery().remove(this.getAction().getActionUUID());
        }
        catch (SQLException sQLException) {
            this.getAction().handleException(this.getAction().defaultExceptionHandler(), sQLException);
        }
        this.queryAction = null;
    }

    @Override
    public Statement getStatement() {
        return this.statement;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }
}

