/*
 * Decompiled with CFR 0.152.
 */
package cn.myrealm.flipcard.gui;

import cn.myrealm.flipcard.FlipCard;
import cn.myrealm.flipcard.gui.InvGui;
import cn.myrealm.flipcard.gui.MainGui;
import cn.myrealm.flipcard.gui.TimerGui;
import cn.myrealm.flipcard.listener.GuiListener;
import cn.myrealm.flipcard.manager.AnimateManager;
import cn.myrealm.flipcard.manager.ConfigManager;
import cn.myrealm.flipcard.manager.LanguageManager;
import cn.myrealm.flipcard.util.Card;
import cn.myrealm.flipcard.util.Reward;
import cn.myrealm.flipcard.util.Timer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DisplayGui
implements InvGui,
TimerGui {
    private MainGui mainGui;
    private Inventory inv;
    private List<Integer> usedSlotList;
    private Map<Integer, Reward> slotAwardMap;
    private List<Timer> timers = new ArrayList<Timer>();
    private boolean causeToTimer = false;

    public DisplayGui(MainGui mainGui) {
        this.mainGui = mainGui;
        this.inv = this.guiConstruct();
        this.slotAwardMapRebuild();
    }

    private Inventory guiConstruct() {
        this.usedSlotList = this.mainGui.getUsedSlotList();
        Inventory inventory = Bukkit.createInventory(null, (int)54, (String)FlipCard.parseColor(ConfigManager.getGui() + this.mainGui.getOption().getTitle(this.getPlayer())));
        for (int n : this.usedSlotList) {
            Card card = this.mainGui.getCardBySlot(n);
            inventory.setItem(n, card.getItemStack());
        }
        return inventory;
    }

    private void slotAwardMapRebuild() {
        this.slotAwardMap = new HashMap<Integer, Reward>(this.mainGui.getSlotAwardMap());
        for (int i = 0; i < this.slotAwardMap.size() * this.slotAwardMap.size() / 2; ++i) {
            int n = (int)(Math.random() * (double)this.usedSlotList.size());
            int n2 = (int)(Math.random() * (double)this.usedSlotList.size());
            int n3 = this.usedSlotList.get(n);
            int n4 = this.usedSlotList.get(n2);
            if (!this.mainGui.getCardBySlot(n3).equals(this.mainGui.getCardBySlot(n4))) continue;
            Reward reward = this.slotAwardMap.get(n3);
            this.slotAwardMap.put(n3, this.slotAwardMap.get(n4));
            this.slotAwardMap.put(n4, reward);
        }
    }

    @Override
    public void clickEventHandle(int n) {
    }

    private void timerRegister() {
        int n;
        for (n = 0; n <= ConfigManager.getDisplayTime(); ++n) {
            this.timers.add(new Timer(this, n));
            this.timers.get(this.timers.size() - 1).guiTitleRefreshTaskRegister();
        }
        this.timers.get(this.timers.size() - 1).displayAnimate2TaskRegister();
        for (n = ConfigManager.getDisplayTime() + 1; n <= ConfigManager.getDisplayTime() + 2; ++n) {
            this.timers.add(new Timer(this, n));
        }
        this.timers.get(this.timers.size() - 1).guiCloseTaskRegister();
    }

    private void timerUnregister() {
        for (int i = 0; i < this.timers.size(); ++i) {
            this.timers.get(i).cancelAllTask();
        }
    }

    @Override
    public boolean closeEventHandle() {
        if (this.causeToTimer) {
            this.causeToTimer = false;
            return false;
        }
        this.timerUnregister();
        AnimateManager.DisplayCloseAnimateTask(this.getPlayer());
        BukkitRunnable bukkitRunnable = new BukkitRunnable(){

            public void run() {
                DisplayGui.this.mainGui.open(DisplayGui.this.getPlayer());
            }
        };
        bukkitRunnable.runTaskLater((Plugin)FlipCard.instance, 20L);
        return true;
    }

    @Override
    public Inventory getInv() {
        return this.inv;
    }

    @Override
    public Player getPlayer() {
        return this.mainGui.getPlayer();
    }

    @Override
    public void timeRefresh(int n) {
        String string = ConfigManager.getDisplayTime() - n > 0 ? this.mainGui.getOption().getTitle(this.getPlayer()) + LanguageManager.getText("display-gui-title-timer") + String.valueOf(ConfigManager.getDisplayTime() - n) : this.mainGui.getOption().getTitle(this.getPlayer()) + LanguageManager.getText("display-gui-title");
        Inventory inventory = Bukkit.createInventory(null, (int)54, (String)FlipCard.parseColor(ConfigManager.getGui() + string));
        inventory.setContents(this.inv.getContents());
        this.inv = inventory;
        this.causeToTimer = true;
        this.mainGui.getPlayer().openInventory(this.inv);
    }

    public void open() {
        this.mainGui.getPlayer().openInventory(this.inv);
        GuiListener.registerListener(this.mainGui.getPlayer(), this);
        AnimateManager.displayAnimate1(this);
        this.timerRegister();
    }

    public static void openGui(MainGui mainGui) {
        DisplayGui displayGui = new DisplayGui(mainGui);
        displayGui.open();
    }

    @Override
    public void closeGui() {
        this.getMainGui().getPlayer().closeInventory();
    }

    public List<Integer> getUsedSlotList() {
        return this.usedSlotList;
    }

    public MainGui getMainGui() {
        return this.mainGui;
    }

    public ItemStack getAwardItemStackBySlot(int n) {
        return this.slotAwardMap.get(n).getItemStack();
    }

    public Reward getAwardBySlot(int n) {
        return this.slotAwardMap.get(n);
    }

    @Override
    public String getConfigName() {
        return null;
    }
}

