/*
 * Decompiled with CFR 0.152.
 */
package cn.myrealm.flipcard.gui;

import cn.myrealm.flipcard.FlipCard;
import cn.myrealm.flipcard.gui.DisplayGui;
import cn.myrealm.flipcard.gui.InvGui;
import cn.myrealm.flipcard.gui.TimerGui;
import cn.myrealm.flipcard.listener.GuiListener;
import cn.myrealm.flipcard.manager.AnimateManager;
import cn.myrealm.flipcard.manager.CacheManager;
import cn.myrealm.flipcard.manager.CardManager;
import cn.myrealm.flipcard.manager.ConfigManager;
import cn.myrealm.flipcard.manager.LanguageManager;
import cn.myrealm.flipcard.manager.PriceManager;
import cn.myrealm.flipcard.manager.RewardManager;
import cn.myrealm.flipcard.util.Card;
import cn.myrealm.flipcard.util.Option;
import cn.myrealm.flipcard.util.Price;
import cn.myrealm.flipcard.util.Reward;
import cn.myrealm.flipcard.util.Timer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.configuration.Configuration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class MainGui
implements InvGui,
TimerGui {
    private Option option;
    private ArrayList<Card> cards;
    private Map<Card, ArrayList<Integer>> cardSlotMap = new HashMap<Card, ArrayList<Integer>>();
    private Inventory inv;
    private List<Integer> usedSlotList = new ArrayList<Integer>();
    private List<Integer> openedSlotList = new ArrayList<Integer>();
    private List<Reward> awardsList = new ArrayList<Reward>();
    private Player player;
    private boolean causeToTimer = false;
    private List<Timer> timers = new ArrayList<Timer>();
    private Map<Integer, Reward> slotAwardMap = new HashMap<Integer, Reward>();
    private ItemStack offhand;
    private String configName = "";
    private int totalTimes = 0;

    public MainGui(@NotNull Configuration configuration, Player player, String string) {
        this.option = new Option(configuration.getConfigurationSection("option"));
        this.cards = CardManager.getCards(configuration, player);
        this.inv = this.guiConstruct();
        this.configName = string;
        this.player = player;
        this.totalTimes = this.option.getTotalMax();
        this.awardsConstruct();
    }

    @NotNull
    private Inventory guiConstruct() {
        String string = FlipCard.parseColor(ConfigManager.getGui() + this.option.getTitle(this.player));
        if (string.startsWith(":") || string.startsWith("%") || string.startsWith("<")) {
            string = "\u00a7f" + string;
        }
        Inventory inventory = Bukkit.createInventory(null, (int)54, (String)string);
        List<Integer> list = this.option.getSlotList();
        int n = 0;
        for (Card card : this.cards) {
            int n2 = card.getAmount();
            for (int i = 0; i < n2; ++i) {
                inventory.setItem(list.get(n).intValue(), card.getItemStack());
                this.usedSlotList.add(list.get(n));
                if (!this.cardSlotMap.containsKey(card)) {
                    this.cardSlotMap.put(card, new ArrayList());
                }
                ArrayList<Integer> arrayList = this.cardSlotMap.get(card);
                arrayList.add(list.get(n));
                this.cardSlotMap.put(card, arrayList);
                ++n;
            }
        }
        return inventory;
    }

    private void awardsConstruct() {
        if (this.usedSlotList.isEmpty() || this.usedSlotList == null) {
            return;
        }
        for (int n : this.usedSlotList) {
            Card card = this.getCardBySlot(n);
            this.slotAwardMap.put(n, RewardManager.AwardHandel(card));
        }
    }

    @Override
    public void clickEventHandle(int n) {
        if (this.usedSlotList.contains(n) && !this.openedSlotList.contains(n)) {
            Card card = this.getCardBySlot(n);
            if (this.isTotalMax()) {
                AnimateManager.failAnimate(this, n, card, LanguageManager.varHandle(LanguageManager.getText("main-gui-max-total-max"), "max", String.valueOf(this.option.getTotalMax())));
                return;
            }
            if (card.getTimes() > card.getMax()) {
                AnimateManager.failAnimate(this, n, card, LanguageManager.varHandle(LanguageManager.getText("main-gui-max-flip-max"), "max", String.valueOf(card.getMax())));
                return;
            }
            Price price = PriceManager.getTargetPrice(card);
            if (ConfigManager.getCondition() && !price.checkCondition(card.getTimes())) {
                AnimateManager.failAnimate(this, n, card, LanguageManager.varHandle(LanguageManager.getText("main-gui-condition-not-meet"), "price", price.getExplain(card.getTimes())));
                return;
            }
            if (!price.checkPrice(card.getTimes(), false)) {
                AnimateManager.failAnimate(this, n, card, LanguageManager.varHandle(LanguageManager.getText("main-gui-price-not-enough"), "price", price.getExplain(card.getTimes())));
                return;
            }
            price.checkPrice(card.getTimes(), true);
            int n2 = AnimateManager.animate(this, n, card, FlipCard.parseColor(LanguageManager.varHandle(LanguageManager.getText("main-gui-have-cost"), "price", price.getExplain(card.getTimes()))));
            this.awardsList.add(this.slotAwardMap.get(n));
            this.openedSlotList.add(n);
            card.timesPlusOne();
            if (this.totalTimes != -1) {
                --this.totalTimes;
            }
            if (this.option.isAutoClose() && (this.isAllCardMax() || this.isTotalMax())) {
                int n3 = 10;
                if (this.option.isCloseAnimal()) {
                    Bukkit.getScheduler().runTaskLater((Plugin)FlipCard.instance, () -> {
                        List<Integer> list = this.usedSlotList;
                        list.removeAll(this.openedSlotList);
                        for (int n : list) {
                            Card card = this.getCardBySlot(n);
                            this.openedSlotList.add(n);
                            AnimateManager.closeAnimate(this, n, card);
                        }
                    }, (long)(n3 + n2));
                    n3 += 50;
                }
                Bukkit.getScheduler().runTaskLater((Plugin)FlipCard.instance, () -> this.closeGuiTemp(), (long)(n3 + n2 * 2));
            } else {
                this.refreshGui();
            }
        }
    }

    @Override
    public boolean closeEventHandle() {
        this.player.getInventory().setItemInOffHand(this.offhand);
        if (this.causeToTimer) {
            this.causeToTimer = false;
            return false;
        }
        this.timerUnregister();
        if (this.option.isAutoClaimFreeRewards()) {
            List<Integer> list = this.usedSlotList;
            list.removeAll(this.openedSlotList);
            for (int n : list) {
                Card card = this.getCardBySlot(n);
                Price price = PriceManager.getTargetPrice(card);
                if (!price.getType().equals("free")) continue;
                AnimateManager.animate(this, n, card, FlipCard.parseColor(LanguageManager.varHandle(LanguageManager.getText("main-gui-have-cost"), "price", price.getExplain(card.getTimes()))));
                this.awardsList.add(this.slotAwardMap.get(n));
                this.openedSlotList.add(n);
                card.timesPlusOne();
            }
        }
        RewardManager.sendRewards(this.awardsList);
        RewardManager.sendCommandAwards(this.awardsList);
        this.awardsList = new ArrayList<Reward>();
        this.sendReopenMessage();
        return true;
    }

    private void sendReopenMessage() {
        int n = CacheManager.getTime(this.player, this);
        if (n == -1) {
            return;
        }
        if (this.isAllCardMax() || this.isTotalMax()) {
            return;
        }
        n = this.option.getTime() - n;
        if (n <= 0) {
            return;
        }
        String string = LanguageManager.getText("reopen-message");
        string = LanguageManager.varHandle(string, "time", String.valueOf(n));
        TextComponent textComponent = new TextComponent(string);
        textComponent.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/fcreopen " + this.getConfigName()));
        this.player.spigot().sendMessage((BaseComponent)textComponent);
    }

    public void reopen() {
        this.timeRefresh(CacheManager.getTime(this.player, this));
        this.open(this.player);
        if (this.timers != null && this.timers.size() != 0) {
            this.timers.forEach(timer -> timer.setDoGuiTitleRefresh(true));
            this.timers.get(this.timers.size() - 1).setDoGuiClose(true);
        }
    }

    public void open(@NotNull Player player) {
        this.offhand = player.getInventory().getItemInOffHand();
        player.openInventory(this.inv);
        GuiListener.registerListener(player, this);
        if (this.option.isTimer() && this.timers.size() == 0) {
            this.timerRegister();
        }
    }

    public static void openGui(Player player, Configuration configuration, String string) {
        MainGui mainGui = new MainGui(configuration, player, string);
        if (mainGui.getOption().isTimer()) {
            CacheManager.addCache(player, mainGui);
        }
        if (mainGui.option.isDisplay()) {
            DisplayGui.openGui(mainGui);
        } else {
            mainGui.open(player);
        }
    }

    @Override
    public void closeGui() {
        this.player.closeInventory();
        this.player.sendMessage(LanguageManager.getText("main-gui-time-runs-out"));
    }

    private void closeGuiTemp() {
        this.player.closeInventory();
    }

    private void timerRegister() {
        for (int i = 0; i <= this.option.getTime(); ++i) {
            this.timers.add(new Timer(this, i));
            this.timers.get(this.timers.size() - 1).guiTitleRefreshTaskRegister();
            this.timers.get(this.timers.size() - 1).cacheTaskRegister();
        }
        this.timers.get(this.timers.size() - 1).guiCloseTaskRegister();
    }

    private void timerUnregister() {
        for (int i = 0; i < this.timers.size(); ++i) {
            this.timers.get(i).cancelAllTask();
        }
    }

    public void timerClearCache() {
        this.timers.forEach(timer -> timer.setDoCacheTask(false));
    }

    @Override
    public void timeRefresh(int n) {
        String string = this.option.getTitle(this.player) + LanguageManager.getText("main-gui-title-timer") + String.valueOf(this.option.getTime() - n);
        Inventory inventory = Bukkit.createInventory(null, (int)54, (String)FlipCard.parseColor(ConfigManager.getGui() + string));
        inventory.setContents(this.inv.getContents());
        this.inv = inventory;
        this.causeToTimer = true;
        this.player.openInventory(this.inv);
        this.refreshGui();
    }

    @Override
    public Inventory getInv() {
        return this.inv;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    public void refreshGui() {
        for (Card card : this.cards) {
            for (int n : this.cardSlotMap.get(card)) {
                if (this.openedSlotList.contains(n)) continue;
                this.inv.setItem(n, card.getItemStack());
            }
        }
    }

    public Card getCardBySlot(int n) {
        Card card = null;
        for (Card card2 : this.cardSlotMap.keySet()) {
            if (!this.cardSlotMap.get(card2).contains(n)) continue;
            card = card2;
            break;
        }
        return card;
    }

    private boolean isAllCardMax() {
        for (Card card : this.cards) {
            if (card.getTimes() > card.getMax()) continue;
            return false;
        }
        return true;
    }

    private boolean isTotalMax() {
        return this.totalTimes <= 0 && this.totalTimes != -1;
    }

    public ItemStack getAwardItemStackBySlot(int n) {
        return this.slotAwardMap.get(n).getItemStack();
    }

    public Reward getAwardBySlot(int n) {
        return this.slotAwardMap.get(n);
    }

    public List<Integer> getUsedSlotList() {
        return this.usedSlotList;
    }

    public Option getOption() {
        return this.option;
    }

    public Map<Integer, Reward> getSlotAwardMap() {
        return this.slotAwardMap;
    }

    @Override
    public String getConfigName() {
        return this.configName;
    }
}

