/*
 * Decompiled with CFR 0.152.
 */
package cn.myrealm.flipcard.manager;

import cn.myrealm.flipcard.FlipCard;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ConfigManager {
    public static Map<String, Configuration> cardsConfig;

    public static void readCardConfig() {
        File file = new File(FlipCard.instance.getDataFolder() + "/ui");
        if (!file.exists()) {
            file.mkdir();
        }
        File[] fileArray = file.listFiles();
        cardsConfig = new HashMap<String, Configuration>();
        for (File file2 : fileArray) {
            if (!file2.getName().endsWith(".yml")) continue;
            cardsConfig.put(file2.getName().substring(0, file2.getName().length() - 4), (Configuration)YamlConfiguration.loadConfiguration((File)file2));
        }
    }

    public static Configuration getConfigById(String string) {
        if (cardsConfig.containsKey(string)) {
            return cardsConfig.get(string);
        }
        return null;
    }

    public static List<String> getIds() {
        if (cardsConfig.isEmpty()) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(cardsConfig.keySet());
    }

    public static ItemStack getCard(String string) {
        ConfigurationSection configurationSection = FlipCard.instance.getConfig().getConfigurationSection(string);
        if (configurationSection == null) {
            return null;
        }
        Material material = Material.getMaterial((String)configurationSection.getString("material").toUpperCase());
        int n = configurationSection.getInt("cmd");
        ItemStack itemStack = new ItemStack(material);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setCustomModelData(Integer.valueOf(n));
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public static ItemStack getAnimation(String string) {
        String string2;
        ConfigurationSection configurationSection = FlipCard.instance.getConfig().getConfigurationSection("animations." + string);
        String string3 = "WHITE_DYE";
        int n = 0;
        Material material = configurationSection.getKeys(false).iterator();
        if (material.hasNext()) {
            string2 = (String)material.next();
            string3 = configurationSection.getConfigurationSection(string2).getString("material", "WHITE_DYE");
            n = configurationSection.getConfigurationSection(string2).getInt("cmd", 0);
        }
        material = Material.getMaterial((String)string3.toUpperCase());
        string2 = new ItemStack(material);
        ItemMeta itemMeta = string2.getItemMeta();
        itemMeta.setCustomModelData(Integer.valueOf(n));
        string2.setItemMeta(itemMeta);
        return string2;
    }

    public static String getGui() {
        return FlipCard.instance.getConfig().getString("gui", "");
    }

    public static int getDisplayTime() {
        return FlipCard.instance.getConfig().getInt("display_time", 10);
    }

    public static ItemStack getEdge(String string) {
        ConfigurationSection configurationSection = FlipCard.instance.getConfig().getConfigurationSection("edge." + string);
        if (configurationSection == null) {
            return null;
        }
        if (configurationSection.getString("material") == null) {
            return null;
        }
        ItemStack itemStack = new ItemStack(Material.getMaterial((String)configurationSection.getString("material").toUpperCase()));
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setCustomModelData(Integer.valueOf(configurationSection.getInt("cmd", 0)));
        itemMeta.setDisplayName(" ");
        itemMeta.setLore(null);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public static void createCard(String string, List<Integer> list) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("material", "WHITE_DYE");
        hashMap.put("cmd", list.get(0));
        hashMap.put("frame", list.subList(0, 6));
        hashMap.put("reward", list.get(list.size() - 1));
        FlipCard.instance.getConfig().createSection(string, hashMap);
        FlipCard.instance.saveConfig();
    }

    public static void createEdge(String string, int n) {
        if (FlipCard.instance.getConfig().getConfigurationSection("edge") == null) {
            FlipCard.instance.getConfig().createSection("edge");
            FlipCard.instance.saveConfig();
        }
        ConfigurationSection configurationSection = FlipCard.instance.getConfig().getConfigurationSection("edge");
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("material", "WHITE_DYE");
        hashMap.put("cmd", n);
        configurationSection.createSection(string, hashMap);
        FlipCard.instance.saveConfig();
    }

    public static void createAnimate(String string, String string2, int n) {
        ConfigurationSection configurationSection = FlipCard.instance.getConfig().getConfigurationSection("animations." + string + "." + string2);
        if (configurationSection == null) {
            return;
        }
        configurationSection.set("material", (Object)"WHITE_DYE");
        configurationSection.set("cmd", (Object)n);
        FlipCard.instance.saveConfig();
    }

    public static double getCardXScale() {
        return FlipCard.instance.getConfig().getDouble("card_x_scale", 1.0);
    }

    public static double getCardYScale() {
        return FlipCard.instance.getConfig().getDouble("card_y_scale", 1.0);
    }

    public static double getEdgeXScale() {
        return FlipCard.instance.getConfig().getDouble("edge_x_scale", 1.0);
    }

    public static double getEdgeYScale() {
        return FlipCard.instance.getConfig().getDouble("edge_y_scale", 1.0);
    }

    public static double getCardTranslation() {
        return FlipCard.instance.getConfig().getDouble("card_translation", -80.0);
    }

    public static double getEdgeTranslation() {
        return FlipCard.instance.getConfig().getDouble("edge_translation", -70.0);
    }

    public static boolean checkCard(String string) {
        return FlipCard.instance.getConfig().getConfigurationSection(string) != null;
    }

    public static boolean checkEdge(String string) {
        ConfigurationSection configurationSection = FlipCard.instance.getConfig().getConfigurationSection("edge");
        return configurationSection != null && configurationSection.getConfigurationSection(string) != null;
    }

    public static boolean checkAnimate(String string, String string2) {
        ConfigurationSection configurationSection = FlipCard.instance.getConfig().getConfigurationSection("animations." + string);
        return configurationSection != null && configurationSection.getConfigurationSection(string2) != null && configurationSection.getConfigurationSection(string2).getString("cmd") != null;
    }

    public static String getLanguage() {
        return FlipCard.instance.getConfig().getString("language", "english");
    }

    public static boolean getCondition() {
        return FlipCard.instance.getConfig().getBoolean("check-condition", false);
    }

    public static boolean getMath() {
        return FlipCard.instance.getConfig().getBoolean("math.enabled", true);
    }

    public static boolean getUseUUID() {
        return FlipCard.instance.getConfig().getBoolean("use-uuid-save-data", true);
    }

    public static boolean getAutoCopyResourcePack() {
        return FlipCard.instance.getConfig().getBoolean("auto-copy-resourcepack.enabled", false);
    }

    public static String getAutoCopyPlugin() {
        return FlipCard.instance.getConfig().getString("auto-copy-resourcepack.plugin", null);
    }

    public static String getAutoCopyPath() {
        return FlipCard.instance.getConfig().getString("auto-copy-resourcepack.path", "");
    }

    public static boolean getMySQL() {
        return FlipCard.instance.getConfig().getBoolean("mysql.enabled", false);
    }

    public static boolean getLeftTimes() {
        return FlipCard.instance.getConfig().getBoolean("use-left-times-feature", true);
    }

    public static ConfigurationSection getAnimations() {
        return FlipCard.instance.getConfig().getConfigurationSection("animations");
    }
}

