/*
 * Decompiled with CFR 0.152.
 */
package cn.myrealm.flipcard.manager;

import cc.carm.lib.easysql.EasySQL;
import cc.carm.lib.easysql.api.SQLManager;
import cc.carm.lib.easysql.api.action.query.QueryAction;
import cc.carm.lib.easysql.api.builder.TableQueryBuilder;
import cc.carm.lib.easysql.api.builder.UpdateBuilder;
import cc.carm.lib.easysql.api.enums.NumberType;
import cn.myrealm.flipcard.FlipCard;
import cn.myrealm.flipcard.manager.ConfigManager;
import cn.myrealm.flipcard.manager.PlayerCacheManager;
import cn.myrealm.flipcard.util.Cache;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class DatabaseManager {
    private static SQLManager sqlManager;

    public static void initSqlManager() {
        Bukkit.getConsoleSender().sendMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[FlipCard] \u00a7fTrying connect to MySQL database...");
        FileConfiguration fileConfiguration = FlipCard.instance.getConfig();
        String string = "jdbc:mysql://" + fileConfiguration.getString("mysql.host") + ":" + fileConfiguration.getString("mysql.port") + "/" + fileConfiguration.getString("mysql.database") + "?useUnicode=true&characterEncoding=utf8&useSSL=true&serverTimezone=GMT%2B8&allowPublicKeyRetrieval=true";
        String string2 = fileConfiguration.getString("mysql.user");
        String string3 = fileConfiguration.getString("mysql.pass");
        String string4 = "com.mysql.cj.jdbc.Driver";
        if (StringUtils.isBlank((String)string4) || StringUtils.isBlank((String)string) || StringUtils.isBlank((String)string2)) {
            Bukkit.getConsoleSender().sendMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[FlipCard] \u00a7cFailed connect to MySQL database!");
            return;
        }
        sqlManager = EasySQL.createManager(string4, string, string2, string3);
        try {
            if (!sqlManager.getConnection().isValid(5)) {
                Bukkit.getConsoleSender().sendMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[FlipCard] \u00a7cFailed connect to MySQL database!");
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        DatabaseManager.createTable();
    }

    public static void shutDown() {
        if (Objects.nonNull(sqlManager)) {
            EasySQL.shutdownManager(sqlManager);
            sqlManager = null;
        }
    }

    public static void createTable() {
        sqlManager.createTable("flipcard").addAutoIncrementColumn("id", NumberType.INT, true, true).addColumn("player", "VARCHAR(36)").addColumn("config_id", "VARCHAR(32)").addColumn("times", "TINYINT NOT NULL DEFAULT 0").build().execute(null);
    }

    public static void insert(Player player, String string, int n) {
        String string2 = player.getName();
        if (ConfigManager.getUseUUID()) {
            string2 = player.getUniqueId().toString();
        }
        sqlManager.createInsert("flipcard").setColumnNames("player", "config_id", "times").setParams(string2, string, n).executeAsync();
    }

    public static void update(Player player, String string, int n) {
        String string2 = player.getName();
        if (ConfigManager.getUseUUID()) {
            string2 = player.getUniqueId().toString();
        }
        ((UpdateBuilder)((UpdateBuilder)sqlManager.createUpdate("flipcard").addCondition("player = '" + string2 + "'")).addCondition("config_id = '" + string + "'")).setColumnValues("times", n).build().executeAsync();
    }

    public static void query(Player player, String string) {
        String string2 = player.getName();
        if (ConfigManager.getUseUUID()) {
            string2 = player.getUniqueId().toString();
        }
        QueryAction queryAction = (QueryAction)((TableQueryBuilder)((TableQueryBuilder)sqlManager.createQuery().inTable("flipcard").selectColumns("times").addCondition("player = '" + string2 + "'")).addCondition("config_id = '" + string + "'")).build();
        queryAction.executeAsync(sQLQuery -> {
            ResultSet resultSet = sQLQuery.getResultSet();
            if (resultSet == null) {
                DatabaseManager.insert(player, string, 0);
                DatabaseManager.query(player, string);
            }
            if (resultSet.next()) {
                int n = resultSet.getInt("times");
                Cache cache = PlayerCacheManager.getPlayerCache(player);
                if (Objects.nonNull(cache)) {
                    if (cache.getCache().containsKey(string)) {
                        cache.getCache().replace(string, n);
                    } else {
                        cache.getCache().put(string, n);
                    }
                }
            }
        });
    }
}

