/*
 * Decompiled with CFR 0.152.
 */
package cn.myrealm.flipcard.manager;

import cn.myrealm.flipcard.manager.ConfigManager;
import cn.myrealm.flipcard.util.Card;
import cn.myrealm.flipcard.util.Price;
import java.util.ArrayList;
import java.util.List;

public class PriceManager {
    public static List<Price> getApplyPrices(Card card) {
        List<Price> list = card.getPrices();
        int n = card.getTimes();
        ArrayList<Price> arrayList = new ArrayList<Price>();
        for (Price price : list) {
            if (!price.getApply().contains(n) && n < price.getStartApply()) continue;
            arrayList.add(price);
        }
        return arrayList;
    }

    public static List<Price> getAblePrices(Card card) {
        List<Price> list = PriceManager.getApplyPrices(card);
        ArrayList<Price> arrayList = new ArrayList<Price>();
        for (Price price : list) {
            if (!price.checkPrice(card.getTimes(), false)) continue;
            if (ConfigManager.getCondition() && price.checkCondition(card.getTimes())) {
                arrayList.add(price);
                break;
            }
            if (ConfigManager.getCondition()) continue;
            arrayList.add(price);
            break;
        }
        return arrayList;
    }

    public static Price getTargetPrice(Card card) {
        List<Price> list = PriceManager.getAblePrices(card);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        if (PriceManager.getApplyPrices(card).isEmpty()) {
            return new Price();
        }
        return PriceManager.getApplyPrices(card).get(0);
    }

    public static String getPriceExplain(Card card) {
        return PriceManager.getTargetPrice(card).getExplain(card.getTimes());
    }
}

